#include "ISProxy.h"
#include "../File/IONameFile.h"

using namespace Sct::File;

namespace Sct {
namespace ISProxy { 
    
ISProxy::ISProxy(const string& uniqueID, const string& className) throw() : uniqueID(uniqueID), className(className) {
    IONameFile name(uniqueID, className);
    fileName = name.getIOName();
}

ISProxy::ISProxy() throw() {
}
    
string ISProxy::getUniqueID() const throw(LogicError) {
    return uniqueID;
}

string ISProxy::getClassName() const throw() {
    return className;
}
    
string ISProxy::getFileName() const throw() {
    return fileName;
}

void ISProxy::setFileName(const string& fileName) throw() {
    this->fileName = fileName;
}
    
}
}
