#ifndef SCT_IS_IONAMEIS_H
#define SCT_IS_IONAMEIS_H

#include "../IOName.h"
#include <string>

using std::string;

namespace Sct {
namespace IS {

class IONameIS : public IOName {
public:
    IONameIS(const string& nameIO) throw(InvalidArgument);
    IONameIS(const string& uniqueID, const string& className) throw();    
    IONameIS(const string& uniqueID, const string& className, const string& server) throw();
    virtual ~IONameIS() throw();
    
    static string getRegExp(const string& className) throw();
    void setServer(const string& server) throw();
    string getServer() const throw();
    static string getDefaultServer() throw();
    static void setDefaultServer(const string& server) throw();
protected:
    virtual void parse() throw(InvalidArgument);
    virtual void construct() throw();
    
private:
    IONameIS();
    static string defaultServer;
    string server;
};
}
}

#endif //SCT_IS_IONAMEIS_H
