#ifndef SCT_IONAMEARCHIVEFILE_H
#define SCT_IONAMEARCHIVEFILE_H
#include "../IOName.h"
#include "../IoExceptions.h"

namespace Sct{
  namespace Archive{

    /** 
	IOName for an archived file. Uses SCT_PERSISTENT_DIR
    */
    class IONameArchiveFile : public IOName{
    public:
      /** constructor from fileName */
      IONameArchiveFile(const string& fileName) throw(InvalidArgument);
      /** constructor from uniqueID and classname */
      IONameArchiveFile(const string& uniqueID, const string& className) throw();    
      virtual ~IONameArchiveFile() throw();
      /** wildcard if it contains a `*' */
      bool wildcard() const;
    protected:
      virtual void parse() throw(InvalidArgument);
      virtual void construct() throw();
      IONameArchiveFile();
      void expandWildcards();
    };
  }
}

#endif
