#include "Sct/Version.h"
#include "Sct/SctNames.h"
#include <iostream>
#include <fstream>
#include <cstring>
#include <sstream>
#include <stdlib.h>
using namespace Sct;
using namespace std;


void longVersion() {
    cout << "VersionString:" << VersionString << endl;
    cout << "MajorVersion: " << MajorVersion << " Minor Version: " << MinorVersion << " Modifier: " << VersionModifier << endl;
    cout << "Version: " << Version << endl;
    cout << "BuildSystem: " << BuildSystem << endl;
    cout << "BuildHost: " << BuildHost << endl;
    cout << "BuildDate: " << BuildDate << endl;
    cout << "RodDaq Version: " << RodDaqVersion << endl;
    cout << "CmtConfig: " << CmtConfig << endl;
    cout << "Dataflow Version: " << DataFlowVersion << endl;
    cout << "OnlineVersion : " << OnlineVersion << endl;
    cout << "RootVersion: " << RootVersion << endl;
    cout << "GccVersion: " << GccVersion << endl;    
}

void shortVersion() {
    cout << Version << VersionModifier << endl;
}

void check_equal_command(string cmd, string check_output, string label){
  istringstream iss(check_output);
  iss>>check_output;
  ostringstream oss;  oss << SctNames::getTempDir() << "/SctRodDaqVersion.XXXXXX";
  char tempfile_template[oss.str().size()];
  char* tempfile = tempfile_template;
  strcpy(tempfile, oss.str().c_str());
  mkstemp(tempfile);

  string fullcmd=cmd;  
  fullcmd += " > "; fullcmd += tempfile;
  if (system (fullcmd.c_str() ) !=0 ) {
    cerr << "Error executing command :" << cmd << endl;
    exit(1);
  }

  string output; ifstream f(tempfile); f>>output;
  system( (string("rm -f ")+tempfile).c_str() );

  if (output != check_output) {
    cerr << "SctRodDaqVersion: output of command `" << cmd << "'" 
	 << " was : `" << output << "'" << endl 
	 << "... but I think I was built with " << label << " = `" << check_output<< "'" << endl;
    exit(1);
  }else{
    cout << "SctRodDaqVersion: Checked " << label << "\t=\t" << check_output << endl;
  }
}

void checkVersion(){
  check_equal_command ( string ("echo $CMTCONFIG"), CmtConfig, "CmtConfig   ");
  check_equal_command ( string ("echo $CMTRELEASE"), OnlineVersion, "OnlineVersion");
  check_equal_command ( string ("echo $DF_INST_PATH | sed -e \"s@.*/\\\(DF-[0-9]\\+-[0-9]\\+-[0-9]\\+\\).*@\\1@\""), DataFlowVersion, "DataFlow");
  check_equal_command ( string ("root-config --version"), RootVersion, "RootVersion");
  check_equal_command ( string ("gcc -dumpversion"), GccVersion, "GccVersion   ");
  exit(0);
}

void helpMessage() {
    cout << "Prints out version information about the SctRodDaq system." << endl << endl;
    cout << "Usage: SctRodDaqVersion <options>" << endl;
    cout << "Possible options are: " << endl;
    cout << "\t-h, --help\t\tPrint this help message" << endl;
    cout << "\t-l, --long\t\tPrint out all version information" << endl;
    cout << "\t-s, --short\t\tPrint out short version information" << endl;
    cout << "\t-c, --check\t\tCheck versions" << endl;
    cout << endl << "If no option is given, the default is -s" << endl;
}

void handleShortArg(char arg) {
    switch (arg) {
    case 'h':
	helpMessage();
	break;
    case 'l':
	longVersion();
	break;
    case 's':
	shortVersion();
	break;
    case 'c':
	checkVersion();
    default:
	cout << "Argument -" << arg << " not recognized" << endl;
    }
}

void handleLongArg(const char* arg) {
    if (strcmp(arg, "--help") == 0) return handleShortArg('h');
    if (strcmp(arg, "--long") == 0) return handleShortArg('l');
    if (strcmp(arg, "--short") == 0) return handleShortArg('s');
    if (strcmp(arg, "--check") == 0) return handleShortArg('c');
    cout << "Argument " << arg << " not recognized" << endl;
    helpMessage();
}

void handleArg(const char* arg) {
    if (arg[0] != '-') {
	cout << "Argument " << arg << " not recognized" << endl;
	helpMessage();
	return;
    }
    if (strlen(arg) == 2) handleShortArg(arg[1]);
    else handleLongArg(arg);
}

int main(int argc, char** argv) {
    //Handle args
    switch (argc) {
    case 1:
	shortVersion();
	break;
    case 2:
	handleArg(argv[1]);
	break;
    default:
	helpMessage();
    }
    return 0;
}
