// File: RodPrimitive.cxx
// $Header: /afs/cern.ch/user/s/sctpixel/private/cvsroot/RodDaq/RodCrate/RodPrimitive.cxx,v 1.2 2002/12/12 21:25:53 tmeyer Exp $

// Description:
// This class contains the primitives which are sent as a list to the RODs. They control 
// almost all aspects of the ROD DSP behavior. New primitives can be defined to perform
// user-defined actions, but corresponding DSP code must also be written, compiled and
// loaded into the DSPs before the primitive can be executed.
//
// @author Tom Meyer (meyer@iastate.edu) - originator

//! Namespace for the common routines for SCT and PIXEL ROD software.

#include "RodPrimitive.h"

namespace SctPixelRod {

// Constructors
	/*
	The default constructor, provided explicitly.
	*/
	RodPrimitive::RodPrimitive()
	{
	  m_length = 0;
	  m_index = 0;
	  m_id = 0;
          m_version = 100;
	  m_body = 0;
	}

	/*
	An alternate constructor, which initializes the data members from arguments.
	*/
	RodPrimitive::RodPrimitive( long length, long index, long id, long
                                    version, long* body)
	{
	  m_length = length;
	  m_index = index;
	  m_id = id;
          m_version = version;
	  m_body = body;
	}

	/*
	The copy constructor, which uses a deep copy since one data member is referenced
	by a pointer.
	*/
	RodPrimitive::RodPrimitive( const RodPrimitive& rhs)
	{
	  if (this == &rhs) return;
	  m_length = rhs.getLength();
	  m_index = rhs.getIndex();
	  m_id = rhs.getId();
          m_version = rhs.getVersion();
	  m_body = rhs.getBody();
	  return;
	}

// Destructor
	/*
	The destructor. We MUST be sure to delete the space allocated on the heap for m_body.
	For safety, we also set the pointer to zero to avoid pointers into la-la land.
	*/
	RodPrimitive::~RodPrimitive() 
	{
	  m_body = 0;
	}

// Overload = operator
	/*
	Overload the assignment operator to allow us to equate objects of this class. Note the
	special case to handle assigning an object to itself (i.e. A=A).
	*/
	RodPrimitive& RodPrimitive::operator=( const RodPrimitive& rhs)
	{
	  if (this == &rhs) return *this;
	  m_length = rhs.getLength();
	  m_index = rhs.getIndex();
	  m_id = rhs.getId();
          m_version = rhs.getVersion();
	  m_body = rhs.getBody();
	  return *this;
	}

} // End namespace SctPixelRod
