// File: RodOutList.cxx
// $Header: /afs/cern.ch/user/s/sctpixel/private/cvsroot/RodDaq/RodCrate/RodOutList.cxx,v 1.3 2002/12/12 21:25:52 tmeyer Exp $
//
// Description:
//  Class RodOutList contains the reply lists which are responses from a 
//  primitive list.
//
// @author Tom Meyer (meyer@iastate.edu) - originator
//

// Namespace for the common routines for SCT and PIXEL ROD software.

#include "RodOutList.h"

namespace SctPixelRod {

// Constructors
	/*
	The only constructor.
	*/
	RodOutList::RodOutList( long length) {
	  m_length = length;
	  m_body = new unsigned long[length];
	}

	/*
	The copy constructor.
	*/
	RodOutList::RodOutList( const RodOutList& rhs){
	  if (this == &rhs) return;
	  m_length = rhs.getLength();
	  m_body = rhs.getBody();
	  return;
	}

// Destructor
	/*
	The destructor. We MUST be sure to delete the space allocated on the heap for m_body.
	For safety, we also set the pointer to zero to avoid pointers into la-la land.
	*/
	RodOutList::~RodOutList() 
	{
	  delete [] m_body;
	  m_body = 0;
	}

// Overload = operator
	/*
	Overload the assignment operator to allow us to equate objects of this class. Note the
	special case to handle assigning an object to itself (i.e. A=A).
	*/
	RodOutList& RodOutList::operator=( const RodOutList& rhs)
	{
	  if (this == &rhs) return *this;
	  m_length = rhs.getLength();
	  m_body = rhs.getBody();
	  return *this;
	}


} // End namespace SctPixelRod
