/**
 * A sub-package to hold all GUI-related scripting classes.
 */
package GuiComponents.scripting;

import GuiComponents.Console.*;
import org.apache.bsf.*;

/**
 *
 * @author  palmer
 * A list of static methods that ScriptFactories should implement to enable easy addition to the GUI
 */
public class BeanShellFactory implements ScriptFactory {
    public BSFEngine createEngine(BSFManager manager) {
        try {
            //Register beanshell - it isn't a default
            String [] extensions = { "bsh" };
            //manager.registerScriptingEngine("beanshell", "bsh.util.BeanShellBSFEngine", extensions );
            return manager.loadScriptingEngine("beanshell");
        } catch (BSFException be) {
            System.err.println("Error loading beanshell scripting engine: " + be);
            return null;
        }
    }
    
    public JConsole createConsole() {
        return new JConsole();
    }
    
    public NameCompleter createNameCompleter(BSFEngine engine, SearchableObjectRegistry registry) {
        //return new BeanShellNameCompleter(engine);
	return registry;
    }
    
    public Interpreter createInterpreter(BSFManager manager) {
	BSFEngine engine = createEngine(manager);
	JConsole console = new JConsole();
        NameCompleter nc = createNameCompleter(engine, (SearchableObjectRegistry)manager.getObjectRegistry());
        return new BeanShellInterpreter(console, engine, nc);
    }    
}
