/*
 * ChannelParamsPanel.java
 *
 * Created on 02 April 2004, 10:05
 */

package GuiComponents.SctConf;

import org.omg.CORBA.IntHolder;
import org.omg.CORBA.StringHolder;

import sctConf.ConfigurationException;
import sctConf.BOCChannelConfig;

import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import java.awt.Dimension;

/**
 *
 * @author  gallop
 */
public class ChannelParamsPanel extends javax.swing.JPanel {
    
    /** Creates new form ChannelParamsPanel */
    public ChannelParamsPanel() {
        initComponents();
        
        modifyComponents();

        addAncestorListener(new CheckDispose(this));
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jPanel4 = new javax.swing.JPanel();
        serNoLabel = new javax.swing.JLabel();
        removeButton = new javax.swing.JButton();
        remapModuleButton = new javax.swing.JButton();
        jPanel3 = new javax.swing.JPanel();
        jLabel4 = new javax.swing.JLabel();
        currentText = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        delayText = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        markSpaceText = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        txFibreCombo = new javax.swing.JComboBox();
        jPanel1 = new javax.swing.JPanel();
        jLabel8 = new javax.swing.JLabel();
        threshold0Text = new javax.swing.JTextField();
        jLabel7 = new javax.swing.JLabel();
        delay0Text = new javax.swing.JTextField();
        jLabel10 = new javax.swing.JLabel();
        rxFibre0Combo = new javax.swing.JComboBox();
        jPanel2 = new javax.swing.JPanel();
        jLabel6 = new javax.swing.JLabel();
        threshold1Text = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        delay1Text = new javax.swing.JTextField();
        jLabel11 = new javax.swing.JLabel();
        rxFibre1Combo = new javax.swing.JComboBox();

        setLayout(new javax.swing.BoxLayout(this, javax.swing.BoxLayout.Y_AXIS));

        setBorder(new javax.swing.border.TitledBorder("Position " + getPosition()));
        serNoLabel.setText(getModuleSerial());
        jPanel4.add(serNoLabel);

        removeButton.setText("Remove");
        removeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                removeButtonActionPerformed(evt);
            }
        });

        jPanel4.add(removeButton);

        remapModuleButton.setText("Remap module");
        remapModuleButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                remapModuleButtonActionPerformed(evt);
            }
        });

        jPanel4.add(remapModuleButton);

        add(jPanel4);

        jLabel4.setText("Current:");
        jPanel3.add(jLabel4);

        currentText.setColumns(4);
        currentText.setText("jTextField4");
        currentText.setMinimumSize(new java.awt.Dimension(50, 19));
        jPanel3.add(currentText);

        jLabel3.setText("Delay:");
        jPanel3.add(jLabel3);

        delayText.setColumns(4);
        delayText.setText("jTextField7");
        jPanel3.add(delayText);

        jLabel2.setText("Mark space:");
        jPanel3.add(jLabel2);

        markSpaceText.setColumns(4);
        markSpaceText.setText("jTextField3");
        jPanel3.add(markSpaceText);

        jLabel1.setText("TX fibre:");
        jPanel3.add(jLabel1);

        txFibreCombo.setEditable(true);
        txFibreCombo.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "default" }));
        jPanel3.add(txFibreCombo);

        add(jPanel3);

        jLabel8.setText("Threshold:");
        jPanel1.add(jLabel8);

        threshold0Text.setColumns(4);
        threshold0Text.setText("jTextField2");
        jPanel1.add(threshold0Text);

        jLabel7.setText("Delay:");
        jPanel1.add(jLabel7);

        delay0Text.setColumns(4);
        delay0Text.setText("jTextField1");
        jPanel1.add(delay0Text);

        jLabel10.setText("RX fibre 0:");
        jPanel1.add(jLabel10);

        rxFibre0Combo.setEditable(true);
        rxFibre0Combo.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "default" }));
        jPanel1.add(rxFibre0Combo);

        add(jPanel1);

        jLabel6.setText("Threshold:");
        jPanel2.add(jLabel6);

        threshold1Text.setColumns(4);
        threshold1Text.setText("jTextField5");
        jPanel2.add(threshold1Text);

        jLabel5.setText("Delay:");
        jPanel2.add(jLabel5);

        delay1Text.setColumns(4);
        delay1Text.setText("jTextField8");
        jPanel2.add(delay1Text);

        jLabel11.setText("RX fibre 1:");
        jPanel2.add(jLabel11);

        rxFibre1Combo.setEditable(true);
        rxFibre1Combo.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "default" }));
        jPanel2.add(rxFibre1Combo);

        add(jPanel2);

    }//GEN-END:initComponents

    private void removeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeButtonActionPerformed
        try {
            config.unmapModuleMUR(mur, position);
            updateSerial();
        } catch(ConfigurationException c) {
            JOptionPane.showMessageDialog(null, "Failed to map module to MUR: " + c.detail);
        }
    }//GEN-LAST:event_removeButtonActionPerformed

    private void remapModuleButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_remapModuleButtonActionPerformed
        // Map existing module
        ModuleListView moduleList = new ModuleListView(config);

        Vector list = moduleList.getList();

        if(list.size() == 0) {
            JOptionPane.showMessageDialog(null, "No modules to select, add in module list");

            JFrame frame = new JFrame("Module list");
            frame.getContentPane().add(moduleList);

            frame.addWindowListener(new WindowAdapter() {
                    public void windowClosing(WindowEvent e) {
                        e.getWindow().dispose();
                    }
                });
            frame.pack();
            frame.setVisible(true);

            return;
        }

        Object [] objList = new Object[list.size()];
        list.copyInto(objList);
                
        String item = (String)JOptionPane
            .showInputDialog((JComponent)(evt.getSource()),
                             "Select an unused module",
                             "Module selector",
                             JOptionPane.OK_CANCEL_OPTION,
                             null, // JOptionPane.PLAIN_MESSAGE,
                             objList,
                             objList[0]);

        System.out.println("Found a module! " + item); //  + ": " + list.get(item));

        String sn;
        sn = item;

        try {
            config.mapModuleMUR(mur, position, mur, (position% 6) + 1, sn);
            updateSerial();
        } catch(ConfigurationException c) {
            JOptionPane.showMessageDialog(null, "Failed to map module to MUR: " + c.detail);
        }
    }//GEN-LAST:event_remapModuleButtonActionPerformed

    void modifyComponents() {
        updateBOCConfig();
    }
    
    void updateBOCConfig() {
        int [] mappings = new int[48*3];

        try {
            BOCChannelConfig boc = config.getBOCConfig(rod.partition(), rod.crate(), rod.index(), channel); 

            currentText.setText("" + boc.current);
            delayText.setText("" + boc.delay);
            markSpaceText.setText("" + boc.markSpace);
            txFibreCombo.setSelectedItem("" + mappings[channel * 3+0]);
            threshold0Text.setText("" + boc.threshold0);
            delay0Text.setText("" + boc.delay0);
            threshold1Text.setText("" + boc.threshold1);
            delay1Text.setText("" + boc.delay1);

//            addAncestorListener(new CheckDispose(this, position));
        } catch(Exception e) {
            currentText.setText("0");
            delayText.setText("0");
            markSpaceText.setText("0");
            // txFibreCombo.setSelectedItem("" + mappings[channel * 3+0]);
            threshold0Text.setText("0");
            delay0Text.setText("0");
            threshold1Text.setText("0");
            delay1Text.setText("0");
        }
    }
    
    /** Getter for property mur.
     * @return Value of property mur.
     *
     */
    public int getMur() {
        return this.mur;
    }    

    /** Setter for property mur.
     * @param mur New value of property mur.
     *
     */
    public void setMur(int mur) {
        this.mur = mur;
    }
    
    /** Getter for property pos.
     * @return Value of property pos.
     *
     */
    public int getPosition() {
        return this.position;
    }
    
    /** Setter for property pos.
     * @param pos New value of property pos.
     *
     */
    public void setPosition(int position) {
        this.position = position;

         setBorder(new javax.swing.border.TitledBorder("Position " + getPosition()));
    }
    
    /** Getter for property rod.
     * @return Value of property rod.
     *
     */
    public Proxies.RodProxy getRod() {
        return this.rod;
    }
    
    /** Setter for property rod.
     * @param rod New value of property rod.
     *
     */
    public void setRod(Proxies.RodProxy rod) {
        this.rod = rod;
    }
    
    /** Getter for property channel.
     * @return Value of property channel.
     *
     */
    public int getChannel() {
        return this.channel;
    }
    
    /** Setter for property channel.
     * @param channel New value of property channel.
     *
     */
    public void setChannel(int channel) {
        this.channel = channel;

        updateSerial();
        updateBOCConfig();
    }
    
    public void updateSerial() {
        serNoLabel.setText(getModuleSerial());
    }
    
    public String getModuleSerial() {
        if(config == null) {
            removeButton.setEnabled(false);
            return "No config!";
        }

        try {
            StringHolder serial = new StringHolder();

            IntHolder MUR = new IntHolder(), num = new IntHolder();

            config.translateFromROD(rod.partition(), rod.crate(), rod.index(), channel, MUR, num);
            
            setMur(MUR.value);
            
            config.translateToSN(MUR.value, num.value, serial);

            removeButton.setEnabled(true);
            return serial.value;
        } catch(ConfigurationException c) {
            removeButton.setEnabled(false);
            return "Unconfigured";
        }
    }

    public String getBorderString() {
        return "Position " + position;
    }
    
    /** Getter for property config.
     * @return Value of property config.
     *
     */
    public sctConf.Configuration getConfig() {
        return this.config;
    }
    
    /** Setter for property config.
     * @param config New value of property config.
     *
     */
    public void setConfig(sctConf.Configuration config) {
        this.config = config;
    }
    
    public java.awt.Dimension dimensionOf(java.lang.String string) {
        Dimension result = new Dimension(getFontMetrics(getFont()).stringWidth(string), 
                                         getFontMetrics(getFont()).getHeight());
        System.out.println("Dimension is: " + result);
        return result;
    }    
  
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField currentText;
    private javax.swing.JTextField delay0Text;
    private javax.swing.JTextField delay1Text;
    private javax.swing.JTextField delayText;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JTextField markSpaceText;
    private javax.swing.JButton remapModuleButton;
    private javax.swing.JButton removeButton;
    private javax.swing.JComboBox rxFibre0Combo;
    private javax.swing.JComboBox rxFibre1Combo;
    private javax.swing.JLabel serNoLabel;
    private javax.swing.JTextField threshold0Text;
    private javax.swing.JTextField threshold1Text;
    private javax.swing.JComboBox txFibreCombo;
    // End of variables declaration//GEN-END:variables

    /** Holds value of property mur. */
    private int mur;
    
    /** Holds value of property position. */
    private int position;
    
    /** Holds value of property rod. */
    private Proxies.RodProxy rod;
    
    /** Holds value of property channel. */
    private int channel;
    
    /** Holds value of property config. */
    private sctConf.Configuration config;

    class CheckDispose implements AncestorListener {
        ChannelParamsPanel chan;

        public CheckDispose(ChannelParamsPanel m) {
            chan = m;
        }

        public void ancestorAdded(AncestorEvent e) {
        }

        public void ancestorMoved(AncestorEvent e) {
        }

        public void ancestorRemoved(AncestorEvent e) {
            System.out.println("Ancestor removed on mur: " + mur + " position: " + position);
            if(chan.mur >= 0 ) {
                BOCChannelConfig bConf = new BOCChannelConfig();

                try {
                    bConf.current = Short.parseShort(chan.currentText.getText());
                    bConf.delay = Short.parseShort(chan.delayText.getText());
                    bConf.markSpace = Short.parseShort(chan.markSpaceText.getText());
                    bConf.threshold0 = Short.parseShort(chan.threshold0Text.getText());
                    bConf.delay0 = Short.parseShort(chan.delay0Text.getText());
                    bConf.threshold1 = Short.parseShort(chan.threshold1Text.getText());
                    bConf.delay1 = Short.parseShort(chan.delay1Text.getText());
                } catch(NumberFormatException ex) {
                } catch(NullPointerException ex) {
                }

                try {
                    config.configureBOCChannel(chan.mur, chan.position, bConf);
                } catch(ConfigurationException ex) {
                    JOptionPane.showMessageDialog(null, "Failed to update configuration for mur " + chan.mur + ": " + ex.detail);
                }
            }
        }
    }
}
