#include "../service/FitterI.hh"
#include <ipc/object.h>
#include "Sct/SctNames.h"
#include "Sct/Exception.h"
#include <string>

int main(int argc, char**argv){
    Sct::setExceptionHandlers(argv[0]);
    using namespace std;
    using Sct::SctNames;  
    
    cout << "FittingService test:"<<endl;
    FitterIStatus status;
    
    cout <<"... looking in partition ..."<<SctNames::getPartitionName()<<ends;
    IPCPartition& p = SctNames::getPartition();
    
    cout <<" ... getting a handle ..."<<ends;
    IPCObjectVar<FitterI_T_FitterInterface> handle = 
	p.lookup(FitterI_C_FitterInterface_serverName,FitterI_C_FitterInterface_instanceName,FitterI_T_FitterInterface::ILUClassRecord);
    
    if (handle==0){ cerr<<"Error: handle==0"<<endl; return -1;}
    
    cout <<"Got Handle..."<<endl;
    
    status.returnCode=0;

    if (argc>1){
	handle->setFitStrategy(&status, argv[1]);
    }
    if (argc>2){
	handle->setFitOptions(&status, argv[2]);
    }

    char* theStatus=handle->status(&status);
    cout <<"Status is:"<<theStatus <<endl;
    
    char* theStrategy=handle->getFitStrategy(&status);
    cout <<"strategy is: "<<theStrategy <<endl;
    
    char* theOptions=handle->getFitOptions(&status);
    cout <<"options are: "<<theOptions <<endl;
    
    cout <<handle->nFitsDone(&status)<<" fits done with "<<handle->nFitErrors(&status)<<" errors"<<endl;
    return 0;
}
