#include "FitStrategy.h"
#include <TH1.h>
#include <TF1.h>
#include <sstream>

using std::ostringstream;
using namespace Sct;

namespace SctFitter{
    void FitStrategy::setOptions(string opt=string("")) throw() {
	options=opt;
    } 
    
    FitStrategy::~FitStrategy(){}

    const string& FitStrategy::getOptions() const throw() {
	return options;
    }
    
    FitStrategy::FitStrategy(string opt) throw() {
	setOptions(opt);
    }


    FitStrategyFactory& FitStrategyFactory::instance() throw() {
	if (!bertha) bertha = new FitStrategyFactory();
	return *bertha;
    }

    FitStrategy* FitStrategyFactory::getStrategy(string name) throw(LogicError) {
	if (strategyMap.find(name) == strategyMap.end()) {
	    ostringstream s; s<<"Couldn't find FitStrategy `"<<name<<"'";
	    throw InvalidArgumentError(s.str(), __FILE__, __LINE__);
	}
	return strategyMap[name];
    }


    bool FitStrategyFactory::addToMap(const string& name, FitStrategy& s) throw(){
	if (strategyMap.find(name) != strategyMap.end())
	    return false;
	//cout <<"FitStrategyFactory added "<<name<<endl;
	strategyMap[name] = &s;
	return true;
    }
    
    FitStrategyFactory* FitStrategyFactory::bertha;
}
