#ifndef THRESHOLDFITALGORITHM_H
#define THRESHOLDFITALGORITHM_H

#include "FitAlgorithm.h"

namespace SctFitter {
    
/**
  Fits threshold scans!
  */
class ThresholdFitAlgorithm : public FitAlgorithm {
public:
    static bool putInMap() throw();
    
protected:
    //overrides
    virtual auto_ptr<FitObject> getPrototype() const throw();    
    virtual void guessParameters(const TH1& hist, FitObject& fitOb) const throw (LogicError, MathsError);
    virtual void checkForDefects(const TH1& hist, const ModuleElement& e, DefectList&) const throw (LogicError);
    virtual void createSummaryHistograms(FitScanResult& fits) const throw();
    virtual void checkForDefects(const FitObject&, const ModuleElement&, DefectList&) const;
private:
    ThresholdFitAlgorithm() throw();
    static bool inMap; ///True if in the FitAlgorithmMap
};
}
#endif //#ifndef THRESHOLDFITALGORITHM_H
