#ifndef STROBEDELAYFITALGORITHM_H
#define STROBEDELAYFITALGORITHM_H

#include "FitAlgorithm.h"

namespace SctFitter {
    
/**
  Fits a strobe delay
  */
class StrobeDelayFitAlgorithm : public FitAlgorithm {
protected:
    //overrides
    virtual auto_ptr<FitObject> getPrototype() const throw();
    virtual void guessParameters(const TH1& hist, FitObject& fitOb) const throw (LogicError, MathsError);
    virtual void checkForDefects(const TH1& hist, const ModuleElement&, DefectList&) const throw (LogicError);
    virtual void createSummaryHistograms(FitScanResult& fits) const throw();
    virtual void checkForDefects(const FitObject& fo, const ModuleElement&, DefectList& d) const;
private:
    StrobeDelayFitAlgorithm() throw();
    static bool inMap;  ///Put into FitAlgorithmMap
};
}

#endif //STROBEDELAYFITALGORITHM_H
