#ifndef TIMEWALKTEST_H
#define TIMEWALKTEST_H

#include "../ipc/TestRequest.h"
#include "../ipc/CalibrationController.h"
#include "../ipc/ScanLibrary.h"
#include "../ipc/Sct_CalibrationController.hh"

#include "../SctApiAccessException.h"
#include "Sct/LogicErrors.h"
#include "../SctApiCall.h"

#include <CommonWithDsp/ABCD/ABCDscans.h>
#include <iostream>
#include <vector>

using namespace Sct;
using namespace std;
using namespace SctCalibrationController::Ipc;
using namespace SctCalibrationController;

namespace SctCalibrationController {
namespace Scripts {
    
class TimeWalkTest : public TestRequestImpl {
public:	
    static TimeWalkTest& instance() {
	static TimeWalkTest tw;
	return tw;
    }
    
    virtual void startTest(Sct_SctApi_T_SctApi& api, string& name, unsigned short& testVariable, unsigned long& nScans, vector<double>& testPoints) {	
	this->api = &api;

        // Compression mode 2
        APICALL(&api, modifyABCDVar(&st, ST_COMPRESSION, 2), "TimeWalkTest::startTest")

        // Edge detect on
        APICALL(&api, modifyABCDVar(&st, ST_EDGE_DETECT, 1), "TimeWalkTest::startTest")

        // No masked channels
        APICALL(&api, modifyABCDVar(&st, ST_SEND_MASK, 0), "TimeWalkTest::startTest")

         // 1 fC threshold
        APICALL(&api, modifyABCDVar(&st, ST_QTHR, 1), "TimeWalkTest::startTest")

	name = "TimeWalkTest";
	testVariable = ST_QCAL;                     // QCAL

	charges.push_back(1.25);
	charges.push_back(1.50);
	charges.push_back(1.75);
	charges.push_back(2.00);
	charges.push_back(3.0);
	charges.push_back(4.00);
	charges.push_back(5.00);
	charges.push_back(6.00);
	charges.push_back(8.00);
	charges.push_back(10.00);

	testPoints = charges;
	nScans = testPoints.size();
    }

    virtual ScanRequest* getNextScan(unsigned long index) {
	APICALL(api, modifyABCDVar(&st, ST_QCAL, charges[index]), "TimeWalkTest::getNextScan")

	ScanLibrary& sl = CalibrationControllerImpl::instance().getScanLibrary();
        return &sl.strobeDelayScan(100);
    }

    virtual bool canFeedback() {
	return false;
    }

    virtual void endTest() {
	charges.clear();
	api = 0;
    }

private:
    TimeWalkTest() {}
    Sct_SctApi_T_SctApi* api;
    std::vector<double> charges;
};
}
}
#endif //TIMEWALKTEST_H
