#ifndef THREEPOINTGAINTEST_H
#define THREEPOINTGAINTEST_H

#include "../ipc/TestRequest.h"
#include "../ipc/CalibrationController.h"
#include "../ipc/ScanLibrary.h"
#include "../ipc/Sct_CalibrationController.hh"
#include "../CalibrationControllerImpl.h"

#include "../SctApiAccessException.h"
#include "Sct/LogicErrors.h"
#include "../SctApiCall.h"

#include <CommonWithDsp/ABCD/ABCDscans.h>
#include <iostream>
#include <vector>

using namespace Sct;
using namespace std;
using namespace SctCalibrationController::Ipc;

namespace SctCalibrationController {
namespace Scripts {
    
class ThreePointGainTest : public TestRequestImpl {
public:	
    static ThreePointGainTest& instance() {
	static ThreePointGainTest rc;
	return rc;
    }
    
    virtual void startTest(Sct_SctApi_T_SctApi& api, string& name, unsigned short& testVariable, unsigned long& nScans, vector<double>& testPoints) {	
	this->api = &api;

        // Compression mode X1X
        APICALL(&api, modifyABCDVar(&st, ST_COMPRESSION, 1), "ThreePointGainTest::startTest")

        // Edge detect off
        APICALL(&api, modifyABCDVar(&st, ST_EDGE_DETECT, 0), "ThreePointGainTest::startTest")

        // No masked channels
        APICALL(&api, modifyABCDVar(&st, ST_SEND_MASK, 0), "ThreePointGainTest::startTest")

	name = "NPtGainTest";
	testVariable = ST_QCAL;

	charges.push_back(1.5);
	charges.push_back(2);
	charges.push_back(2.5);

	testPoints = charges;
	nScans = testPoints.size();
    }

    virtual ScanRequest* getNextScan(unsigned long index) {
	ScanLibrary& sl = CalibrationControllerImpl::instance().getScanLibrary();

	APICALL(api, modifyABCDVar(&st, ST_QCAL, charges[index]), "ThreePointGainTest::getNextScan")

        return &sl.thresholdScanfC(1000, charges[index]);		
    }
    
    virtual bool canFeedback() {
	return true;
    }
    
    virtual void endTest() {
	api = 0;
	charges.clear();
    }
    
    
private:
    ThreePointGainTest() {}
    Sct_SctApi_T_SctApi* api;    
    vector<double> charges;
};
}
}
#endif //THREEPOINTGAINTEST_H
