#ifndef PIPELINETEST_H
#define PIPELINETEST_H

#include "../ipc/TestRequest.h"
#include "../ipc/CalibrationController.h"
#include "../ipc/ScanLibrary.h"
#include "../ipc/Sct_CalibrationController.hh"
#include "../CalibrationControllerImpl.h"

#include "../SctApiAccessException.h"
#include "Sct/LogicErrors.h"
#include "../SctApiCall.h"

#include <CommonWithDsp/ABCD/ABCDscans.h>
#include <iostream>
#include <vector>

using namespace Sct;
using namespace std;
using namespace SctCalibrationController::Ipc;
using namespace SctCalibrationController;

namespace SctCalibrationController {
namespace Scripts {
    
class PipelineTest : public TestRequestImpl {
public:	
    static PipelineTest& instance() {
	static PipelineTest rc;
	return rc;
    }
    
    virtual void startTest(Sct_SctApi_T_SctApi& inapi, string& name, unsigned short& testVariable, unsigned long& nScans, vector<double>& testPoints) {	
	this->api = &inapi;

        // Compression mode X1X
        APICALL(api, modifyABCDVar(&st, ST_COMPRESSION, 1), "PipelineTest::startTest")

        // Edge detect off
        APICALL(api, modifyABCDVar(&st, ST_EDGE_DETECT, 0), "PipelineTest::startTest")

        // No masked channels
        APICALL(api, modifyABCDVar(&st, ST_SEND_MASK, 0), "PipelineTest::startTest")

	name = "PipelineTest";
	nScans = 2;
	testPoints.push_back(0);
	testPoints.push_back(1);
	testVariable=ST_MASK;
    }
    
    virtual ScanRequest* getNextScan(unsigned long index) {
	// Set configuration
	APICALL(api, modifyABCDVar(&st, ST_MASK, 3.0*(1-index)), "PipelineTest::getNextScan")

        ScanLibrary& sl = CalibrationControllerImpl::instance().getScanLibrary();
        ScanRequestImpl& request = sl.defaultScan();

	// Create scan
        Sct_SctApi_T_Scan* s = 0;
        APIRETCALL(api, s, createScan(&st), "PipelineTest::getNextScan")
        request.setScan(s);

        APICALL(s, setNTrigs(&st, 100), "PipelineTest::getNextScan")

	// Adjust trigger
        Sct_SctApi_T_Trigger* t = 0;
        APIRETCALL(s, t, getTrigger1(&st), "PipelineTest::getNextScan")

	// 129 is critical to the pulse arriving correctly
        APICALL(t, softPulseL1A(&st, 140, 129), "PipelineTest::getNextScan")

	// "Command" 1 is the delay (starting at 140)
	APICALL(t, setCommIncr(&st, 1, 1), "PipelineTest::getNextScan")

	// Configure scan
	APICALL(s, configure(&st, ST_ELAPSED, 140, 151, 1), "PipelineTest::getNextScan")

	return &request;
    }

    virtual bool canFeedback() {
	return false;
    }

    virtual void endTest() {
	api = 0;
    }

private:
    PipelineTest() {}
    Sct_SctApi_T_SctApi* api;
};
}
}
#endif //PIPELINETEST_H
