#ifndef NMASKSCAN_H
#define NMASKSCAN_H

#include "../ipc/Sct_CalibrationController.hh"
#include "../CalibrationControllerImpl.h"
#include "../SctApiAccessException.h"
#include "../SctApiCall.h"
#include "Sct/LogicErrors.h"

#include <CommonWithDsp/ABCD/ABCDscans.h>

using namespace Sct;
using namespace SctCalibrationController::Ipc;
namespace SctCalibrationController {
namespace Scripts {
    
class NMaskScan : public ScanRequestImpl {
public:
  static ScanRequestImpl& nmaskScan(unsigned long nTrigs) {
    static NMaskScan request;
    Sct_SctApi_T_SctApi* api = CalibrationControllerImpl::instance().getApi();
    Sct_SctApi_T_Scan* s=0;
    APIRETCALL(api, s, createScan(&st), "Failed to create scan")
    request.setScan(s);
    
    APICALL(s, setNTrigs(&st, nTrigs), "Failed to set triggers")
    
    Sct_SctApi_T_Trigger* t = 0;
    APIRETCALL(s, t, getTrigger1(&st), "Failed to get Trigger1")

    APICALL(t, singleL1A(&st), "Failed to set trigger type")

    APICALL(s, configure(&st, ST_NMASK, 0, 128, 1), "Failed to set Scan information")
    return request;
    }
    
private:
  NMaskScan(){;}
};
    
}
}

#endif //NMASKSCAN_H
