#ifndef SCTCALIBRATIONCONTROLLER_REQUESTEXCEPTION_H    
#define SCTCALIBRATIONCONTROLLER_REQUESTEXCEPTION_H

#include "Sct/IpcException.h"

namespace SctCalibrationController {
namespace Ipc {

/**
 * Thrown to indicate an error with an Ipc call to a Request of some sort.
 * @ingroup Exceptions     
 * @author Matthew Palmer
 */
class RequestException : public Sct::IpcException {
public:
    /**
      Creates an Exception with message msg and no cause
      */
    RequestException(const ilu_Exception& error, const string& msg, const string& file, int line) throw()
	: Sct::IpcException(error, msg, file, line) {
	initialize("REQUEST_EXCEPTION", "CalibrationController::RequestException", msg, 0, file, line);
    }
    
    /**
      Creates an Exception with a cause.  Useful for simply wrapping
      exceptions.
      */
    RequestException(const ilu_Exception& error, Throwable& cause, const string& file, int line) throw()
	: Sct::IpcException(error, msg, file, line) {
	initialize("REQUEST_EXCEPTION", "CalibrationController::RequestException", "", &cause, file, line);
    }
    
    /**
      Creates an Exception with a message and a cause
      */
    RequestException(const ilu_Exception& error, const string& msg, Throwable& cause, const string& file, int line) throw()
	: Sct::IpcException(error, msg, file, line) {
	initialize("REQUEST_EXCEPTION", "CalibrationController::RequestException", msg, &cause, file, line);
    }
        
protected:
    RequestException() throw() {}   
};
}
}
#endif //SCTCALIBRATIONCONTROLLER_REQUESTEXCEPTION_H
