#include "TestLibraryImpl.h"
#include "scripts/ResponseCurve.h"
#include "scripts/ThreePointGainTest.h"
#include "scripts/StrobeDelayTest.h"
#include "scripts/NoiseOccupancyTest.h"
#include "scripts/PipelineTest.h"
#include "scripts/TrimRangeTest.h"
#include "scripts/FullBypassBarrelTest.h"
#include "scripts/FullBypassEndcapTest.h"
#include "scripts/TimeWalkTest.h"
#include "scripts/NMaskTest.h"
#include "scripts/RxDelayTest.h"
#include "scripts/RxThresholdTest.h"

namespace SctCalibrationController {
    
using namespace Scripts;

TestLibraryImpl::TestLibraryImpl() {
    cout << "create TestLibraryImpl" << endl;
}

TestLibraryImpl& TestLibraryImpl::instance() {
    static TestLibraryImpl* instance = new TestLibraryImpl();
    return *instance;
}

TestRequestImpl& TestLibraryImpl::responseCurve() const {
    return ResponseCurve::instance();
}

TestRequestImpl& TestLibraryImpl::threePointGain () const {
    return ThreePointGainTest::instance();
}

TestRequestImpl& TestLibraryImpl::strobeDelay () const {
    return StrobeDelayTest::instance();
}

TestRequestImpl& TestLibraryImpl::pipeline () const {
    return PipelineTest::instance();
}

TestRequestImpl& TestLibraryImpl::noiseOccupancy () const {
    return NoiseOccupancyTest::instance();
}
TestRequestImpl& TestLibraryImpl::timeWalk () const {
    return TimeWalkTest::instance();
}

TestRequestImpl& TestLibraryImpl::fullBypassBarrel () const {
    return FullBypassBarrelTest::instance();
}

TestRequestImpl& TestLibraryImpl::fullBypassEndcap () const {
	    return FullBypassEndcapTest::instance();
}

TestRequestImpl& TestLibraryImpl::trimRange () const {
    return TrimRangeTest::instance();
}

TestRequestImpl& TestLibraryImpl::nmask () const {
    return NMaskTest::instance();
}

TestRequestImpl& TestLibraryImpl::rxDelay() const {
    return RxDelayTest::instance();
}

TestRequestImpl& TestLibraryImpl::rxThreshold () const {
    return RxThresholdTest::instance();
}

}
