#ifndef SCTCALIBRATIONCONTROLLER_SCTAPIACCESSEXCEPTION_H
#define SCTCALIBRATIONCONTROLLER_SCTAPIACCESSEXCEPTION_H

#include "Sct/IpcException.h"

namespace SctCalibrationController {

/**
 * Thrown to indicate an error with an Ipc call to the SctApi
 * @ingroup Exceptions     
 * @author Matthew Palmer
 */
class SctApiAccessException : public Sct::IpcException {
public:
    /**
      Creates an Exception with message msg and no cause
      */
    SctApiAccessException(const ilu_Exception& error, const string& msg, const string& file, int line) throw()
	: Sct::IpcException(error, msg, file, line) {
	initialize("SCTAPI_EXCEPTION", "CalibrationController::SctApiAccessException", msg, 0, file, line);
    }
    
    /**
      Creates an Exception with a cause.  Useful for simply wrapping
      exceptions.
      */
    SctApiAccessException(const ilu_Exception& error, Throwable& cause, const string& file, int line) throw()
	: Sct::IpcException(error, msg, file, line) {
	initialize("SCTAPI_EXCEPTION", "CalibrationController::SctApiAccessException", "", &cause, file, line);
    }
    
    /**
      Creates an Exception with a message and a cause
      */
    SctApiAccessException(const ilu_Exception& error, const string& msg, Throwable& cause, const string& file, int line) throw()
	: Sct::IpcException(error, msg, file, line) {
	initialize("SCTAPI_EXCEPTION", "CalibrationController::SctApiAccessException", msg, &cause, file, line);
    }
        
protected:
    SctApiAccessException() throw() {}   
};
}
#endif //SCTCALIBRATIONCONTROLLER_SCTAPIACCESSEXCEPTION_H
