#ifndef SCANLIBRARYIMPL_H
#define SCANLIBRARYIMPL_H

#include "ipc/ScanLibrary.h"

namespace SctCalibrationController {
using namespace Ipc;

class ScanLibraryImpl : public ScanLibrary {
public:
    static ScanLibraryImpl& instance();
    
    virtual ScanRequestImpl& thresholdScan(unsigned long nTrigs) const;
    virtual ScanRequestImpl& thresholdScanfC(unsigned long nTrigs, double calCharge) const;    
    virtual ScanRequestImpl& thresholdScanfCOffset(unsigned long nTrigs, double calCharge, double offset) const;    
    virtual ScanRequestImpl& noiseOccupancyScan() const;    
    virtual ScanRequestImpl& strobeDelayScan(unsigned long nTrigs) const;
    virtual ScanRequestImpl& nmaskScan(unsigned long nTrigs) const;    
    virtual ScanRequestImpl& tokenScan() const;
    virtual ScanRequestImpl& defaultScan() const;
    virtual ScanRequestImpl& rawScan(unsigned long nTrigs) const;
private:
    Sct_SctApi_T_SctApi* api;
    ScanLibraryImpl();
};    
}

#endif //SCANLIBRARYIMPL_H
