#ifndef SCTCALIBRATIONRUNCONTROLLER_H
#define SCTCALIBRATIONRUNCONTROLLER_H

#ifdef linux
#undef linux
#endif

#include <rc/rc_interface.h>
#include <boost/utility.hpp>
#include <string>

using std::string;

class Sct_SctApi_T_SctApi;

namespace SctCalibrationController {

class CalibrationControllerImpl;

class RunControl : public rc_interface, boost::noncopyable {
public:
    enum ErrorState {
        SCTAPI_ACCESS_FAILURE
    };

    static RunControl& instance();

    //methods associated with Alive
    //  virtual void enterAlive();
    //virtual void exitAlive();
    //  virtual void killaction ();
    virtual int resetaction ();

    //methods associated to Initial
    //  virtual void enterInitial();
    //  virtual void exitInitial();
    /**
      Get hold of SctApi and pass it to the CalibrationController
      
      */
    virtual int loadaction ();
    //virtual void terminateaction ();

    //methods associated with Active
    //virtual void enterActive();
    //  virtual void exitActive();
    //  virtual int stopaction ();

    //methods associated with Running
    //virtual void enterRunning();
    virtual void exitRunning();
    //  virtual int pauseaction ();

    //methods associated with Paused
    //  virtual void enterPaused();
    //  virtual void exitPaused();
    //  virtual int stepaction ();
    //  virtual int resumeaction ();

    //methods associated with Configured
    //virtual void enterConfigured();
    //  virtual void exitConfigured();
    //virtual int unconfigaction();
    virtual int startaction ();

    //methods associated with Loaded
    //  virtual void enterLoaded();
    //  virtual void exitLoaded();
    virtual int unloadaction ();
    virtual int configaction ();

    /**
      Call this to indicate an error accessing the api
      */
    void sctApiError(ErrorState state, const string& reason);

private:
    RunControl();
    CalibrationControllerImpl& cc;
    Sct_SctApi_T_SctApi* api;

};

}

#endif //SCTCALIBRATIONRUNCONTROLLER_H
