#include "ConfigUpdaterManager.h"
#include "ConfigUpdater.h"

#include "Sct_SctApi/Sct_SctApi.hh"
#include "Sct/LogicErrors.h"
#include "SctData/TestResult.h"
#include "Sct/SctNames.h"

using namespace Sct;
using namespace SctData;

namespace SctCalibrationController {
    
ConfigUpdaterManager::ConfigUpdaterManager() {
}

ConfigUpdaterManager& ConfigUpdaterManager::instance() {
    static ConfigUpdaterManager cum;
    return cum;
}

void ConfigUpdaterManager::update(const SctData::TestResult& t, Sct_SctApi_T_SctApi& api) const {
    if (t.getPassed()){
    	getUpdater(t.getClassName()).update(t, api);
    }else{
	std::ostringstream oss;
	oss << "Module failed - configuration not updated" << t.getClassName() << " " << t.getUniqueID();
        SctNames::Mrs() << "UPDATE_NOT_DONE" 
		        << MRS_TEXT(oss.str().c_str()) << MRS_DIAGNOSTIC << ENDM;
    }
}
    
ConfigUpdater& ConfigUpdaterManager::getUpdater(const string& className) const {
    ConfigUpdaterMap::const_iterator it = updaterMap.find(className);
    if ( it == updaterMap.end() ) {
        cerr << "Calibration Controller: no updater for " << className << endl;
        cerr << "known updaters:" << endl ;
        for (ConfigUpdaterMap::const_iterator it = updaterMap.begin(); it != updaterMap.end(); ++it) {
            cerr << (*it).first << endl;
        }
        throw InvalidArgumentError("Calibration Controller: no updater for " + className, __FILE__, __LINE__ );
    } else {
        return *(*it).second ;
    }    
}
    
bool ConfigUpdaterManager::setUpdater(const string& testName, shared_ptr<ConfigUpdater> updater) {
    if (updaterMap.find(testName) == updaterMap.end() ) {
        updaterMap[testName] = updater;
        return true;
    }
    return false;
}
    
} 

