#ifndef SCTARCHIVING_TRANSFERCOMMAND_H
#define  SCTARCHIVING_TRANSFERCOMMAND_H
#include "GetCommand.h"
#include "PutCommand.h"

namespace SctArchiving{
  /**
   *  ArchivingCommand which retrieves an object with a GetCommand,
   *  and then places it with a PutCommand.
   *  Checks the Sct::IOName of the GetCommand for wildcards, 
   *  and uses the ArchivingCommandList to do the transfer 
   *  for each name from the expanded wildcard.
  */
  class TransferCommand : public ArchivingCommand {
  public:
    /** constructor with name of object to transfer */
    TransferCommand(boost::shared_ptr<GetCommand> get, 
		    boost::shared_ptr<PutCommand> put);
    /** destructor */
    ~TransferCommand();
    /** does GetCommand then PutCommand */
    virtual void execute();
    /** virtual constructor */
    virtual boost::shared_ptr<ArchivingCommand> create() const;
  protected:
    /** GetCommand */
    shared_ptr<GetCommand> m_get;
    /** PutCommand */
    shared_ptr<PutCommand> m_put;
    TransferCommand();
  };
}

#endif
