#ifndef SCTARCHIVING_ISPUTCOMMAND_H
#define  SCTARCHIVING_ISPUTCOMMAND_H
#include "PutCommand.h"

namespace SctArchiving{
  /** PutCommand to put an object in the archive 
   * Uses the Sct::IS::IOManagerISProxy to publish */
  class IsPutCommand : public PutCommand{
  public:
    /** Puts object in archive */
    IsPutCommand(boost::shared_ptr<Sct::Serializable> ob);
    /** Puts object in archive - need to use setObject first */
    IsPutCommand();
    /** destructor */
    ~IsPutCommand();
    /** puts the object from the archive */
    virtual void execute();
    /** set the IS server to write to */
    virtual void setServer(const string& name);
    /** impliment */
    virtual boost::shared_ptr<ArchivingCommand> create() const;
  protected:
    std::string m_server;
  };
}

#endif
