#ifndef ARCHIVINGWORKERGROUP_H
#define ARCHIVINGWORKERGROUP_H
#include "ArchivingCommand.h"
#include "SctService/WorkerGroup.h"

#include "boost/shared_ptr.hpp"

using boost::shared_ptr;
using namespace SctService;

namespace SctArchiving {
  class ArchivingCommand;

/**
   Represents a group of worker threads which interpret 
   and carry out ArchivingCommand s.
 */
class ArchivingWorkerGroup : public WorkerGroup<shared_ptr<ArchivingCommand> > {
 public:
  /// initialise the number of calls to 0.
  ArchivingWorkerGroup() {}

    /// destructor
    virtual ~ArchivingWorkerGroup() {}

private:
    /**
       Interprets and 
       Handles its own exceptions, sending messages to MRS.
    */
    virtual void work( shared_ptr<ArchivingCommand> ) throw() ;
};

}// end of namespace SctArchiving

#endif // #define ARCHIVINGWORKERGROUP_H
