#ifndef PIPELINEALGORITHM_H
#define PIPELINEALGORITHM_H

#include "AnalysisAlgorithm.h"

namespace SctAnalysis {
    /**
       Algorithm for single-scan Pipeline Test.
       Uses a single RawScanResult to find defects in the pipeline.
    */
class PipelineAlgorithm : public AnalysisAlgorithm {
public:
    virtual void analyze();
    virtual void loadData();
    virtual bool canAnalyze() const;
    virtual shared_ptr<SctData::TestResult> createTestResult() const;
    virtual boost::shared_ptr<AnalysisAlgorithm> clone(const TestData& testData, const string& moduleName) const throw();
    /** 
	constructor 
     */
    PipelineAlgorithm(const TestData& testData, const string& moduleName, const AnalysisAlgorithm& alg) throw() : AnalysisAlgorithm(testData, moduleName, alg) {}
    /** 
	destructor 
     */
    virtual ~PipelineAlgorithm() throw() {}
private:
    PipelineAlgorithm() {}
    static bool inMap;
};
}

#endif //PIPELINEALGORITHM_H
