#include "NMaskAlgorithm.h"
#include "AnalysisAlgorithmMap.h"
#include "SctData/NMaskTestResult.h"
#include "SctData/RawScanResult.h"
#include "SctData/StandardDefects.h"
#include "SctData/ModuleElement.h"
#include <TH1.h>
#include <TH2.h>

using namespace std;
using namespace boost;
using namespace SctData;
using namespace Sct;

namespace SctAnalysis {

bool NMaskAlgorithm::inMap = AnalysisAlgorithmMap::instance().setAlgorithm("NMaskTest", auto_ptr<AnalysisAlgorithm>(new NMaskAlgorithm()));

shared_ptr<AnalysisAlgorithm> NMaskAlgorithm::clone(const TestData& testData, const string& moduleName) const throw() {
    return shared_ptr<AnalysisAlgorithm>(new NMaskAlgorithm(testData, moduleName, *this));
}

void NMaskAlgorithm::loadData() {
    loadAllRaws();
}

bool NMaskAlgorithm::canAnalyze() const {
    return hasAllRaws();
}

shared_ptr<SctData::TestResult> NMaskAlgorithm::createTestResult() const {
    return shared_ptr<NMaskTestResult> (new NMaskTestResult());
}

void NMaskAlgorithm::analyze() {
    shared_ptr<NMaskTestResult> result =  dynamic_pointer_cast<NMaskTestResult> ( getTestResult() );

    shared_ptr<const RawScanResult> raw = getRaw(0);
    result->setScanVariable(raw->getHeader().getVariable());	
    
    TH2D& link0 = raw->getScanData(0);
    TH2D& link1 = raw->getScanData(1);
    int nTriggers = (int)result->getTestPointAt(0);
    
    for (unsigned int channel = 0; channel<Sct::nChannelModule; ++channel) {
	for (unsigned int bin = 0; bin<link0.GetNbinsY(); ++bin) {
	    int content = (int) channel < Sct::nChannelLink ? link0.GetBinContent(channel+1, bin+1) : link1.GetBinContent(channel+1-nChannelLink, bin+1);
	    if (channel%nChannelChip < bin) {
		if (content != 0) {
		    result->getDefects().addDefect(Defect(StandardDefects::OVER, ModuleElement::Channel(channel)));
		    break;
		}
	    } else {
		if (content != nTriggers) {
		    result->getDefects().addDefect(Defect(StandardDefects::UNDER, ModuleElement::Channel(channel)));
		    break;
		}
	    }
	}
    }
    if (result->getDefects().getAllDefects().size() != 0)
	result->setPassed(false);
    else 
	result->setPassed(true);
}
} // end of namespace SctAnalysis
