#include "AnalysisAlgorithmMap.h"
#include "AnalysisAlgorithm.h"
#include "CalibrationController/IS/TestData.h"
#include <sstream>

using namespace std;

namespace SctAnalysis {

typedef map<string, shared_ptr<AnalysisAlgorithm> > MapType;
    
AnalysisAlgorithmMap& AnalysisAlgorithmMap::instance() {
    static AnalysisAlgorithmMap* instance = new AnalysisAlgorithmMap();
    return *instance;
}
    
shared_ptr <AnalysisAlgorithm> AnalysisAlgorithmMap::getAlgorithm(const TestData& testData, const string& moduleName) const throw(Sct::InvalidArgument) {
    if (algMap.count(testData.testName) == 0) {
	Sct::InvalidArgumentError iae("No map for Test: " + testData.testName, __FILE__, __LINE__);
	iae.setSeverity(MRS_DIAGNOSTIC);
	throw iae;
    }
    return (*algMap.find(testData.testName)).second->clone(testData, moduleName);
}
    
bool AnalysisAlgorithmMap::setAlgorithm(const string testName, auto_ptr<AnalysisAlgorithm> alg) throw() {
    algMap[testName] = shared_ptr<AnalysisAlgorithm>(alg);
    return true;    
}

string AnalysisAlgorithmMap::getStatus(string testName) {
    if (algMap.count(testName) == 0) {
	return string();
    }
    return algMap[testName]->getStatus();
}
    
string AnalysisAlgorithmMap::getAllStatus() {
    ostringstream status;
    for (MapType::const_iterator i=algMap.begin(); i!=algMap.end(); ++i) {
	status << i->first << " Algorithm " << i->second->getStatus() << "\n";
    }
    return status.str();
}

    
}
