#include <iostream>
#include <string>
#include <vector>
#include <time.h>

//IS stuff
#include <is/isinfotmpl.h>
#include <is/isnamedinfo.h>
#include <is/isinfoany.h>

#include <cmdl/cmdargs.h>

#include "sctddc/SCTDdcCommandSender.hxx"
#include "sctddc/SCTDdcRequest.hxx"
#include "sctddc/SCTDCSCommand.hxx"

int main(int argc, char *argv[])
{
  SCTDCSCommand* myDaq = NULL;
  int	controllerNumber = (argc-3)/2;
  cerr << "We deal with " << controllerNumber << " controllers:" << endl;

  CmdArgStr	partition_name('p', "partition", "partition-name", "partition to work in.", CmdArg::isREQ);
  CmdArgStr	ctrl1_name('c', "controller1", "controller-id", "controller to work with", CmdArg::isREQ);
  CmdArgStr	ctrl2_name('M', "controller2", "controller-id", "controller to work with");
  CmdArgStr	ctrl3_name('N', "controller3", "controller-id", "controller to work with");
  CmdArgStr	ctrl4_name('O', "controller4", "controller-id", "controller to work with");
  
  //
  // Declare command object and its argument-iterator
  //       
  CmdLine  cmdLine(*argv, &partition_name, &ctrl1_name, &ctrl2_name, &ctrl3_name, &ctrl4_name, NULL);
  CmdArgvIter  arg_iter(--argc, ++argv);
  
  //
  // Parse arguments
  //
  cmdLine.parse(arg_iter);
  
  string* ctrls[5];
  ctrls[0] = new string((string)ctrl1_name);
  cerr << *ctrls[0] << endl;
  if(controllerNumber > 1) {
    ctrls[1] = new string((string)ctrl2_name);
    cerr << *ctrls[1] << endl;
  }
  if(controllerNumber > 2) {
    ctrls[2] = new string((string)ctrl3_name);
    cerr << *ctrls[2] << endl;
  }
  if(controllerNumber > 3) {
    ctrls[3] = new string((string)ctrl4_name);
    cerr << *ctrls[3] << endl;
  }
  ctrls[controllerNumber] = 0;
	
  IPCCore::init(true, false);
  
  IPCPartition testPartition((const char*)partition_name);
  
  myDaq = new SCTDCSCommand(testPartition, ctrls);
  
  //======================================================================================================
  //======================================= Here are some tests ==========================================
  //======================================================================================================

  //******************************************************************************************************
  //=============================== this is for barrel environement project ==============================
  //******************************************************************************************************
    /*
  if(myDaq->openDCSControl("SCTbarr1", 1))
    {
      //int sycle = 0;
      //while(sycle<1000)
      //  {
      cout<<"=============== control got"<< endl;
      myDaq->setDPStatus("SCTbarr1:HVol.Stat", 0x14, 5);
      //	sycle++;
      //  }
      //.......
      myDaq->closeDCSControl("SCTbarr1", 5);
    }
  else
    {
      cout << "DDC ERROR: access to DCS control failled"<<endl;
    }
    while(1)
    {
      cout<<"=============== finised"<< endl;
      sleep(5);
    }
    */
  //******************************************************************************************************
  //=========================================== Test for IV curve  =======================================
  //******************************************************************************************************
    //the following parameters, for instance, are meaningless!!
    //  myDaq->requestIVCurve(0, 0, 0, 100, 10, 0, 10, 4, 3, 5);
  //******************************************************************************************************
  //================================== this is for  power supply project =================================
  //******************************************************************************************************

  //======================================= Set Channel parameters ============================
  /*
  //set one variable in a channel 
  string ch_para("LVch_Vcc");
  
  for(int icrate=0; icrate<1; icrate++)
    {
      float value = 15.0;
      for(int ichannel=0; ichannel<3; ichannel++)
	{
	  myDaq->setChannelParameter(icrate, ichannel, ch_para, value, 5);
	  value = value + 10;
	}
    }

  //set several variables in a channel 
  std::map<string, float> ch_dpeNamesAnddpeValues;
  ch_dpeNamesAnddpeValues["LVch_Vcc"] = 22;
  ch_dpeNamesAnddpeValues["LVch_Vdd"] = 23;
  ch_dpeNamesAnddpeValues["LVchPINV"] = 24;
  ch_dpeNamesAnddpeValues["LVchDTrp"] = 25;
  myDaq->setChannelParameters(0, 0, ch_dpeNamesAnddpeValues, 5);
  */
  //======================================= Set Card parameters ============================
  /*
  //set one variable in a card 
  string ca_para("LVcaTrip");
  
  for(int icrate=0; icrate<1; icrate++)
    {
      float value = 15.0;
      for(int icard=0; icard<3; icard++)
	{
	  myDaq->setCardParameter(icrate, icard, ca_para, value, 5);
	  value = value + 10;
	}
    }

  //set several variables in a card 
  std::map<string, float> ca_dpeNamesAnddpeValues;

  ca_dpeNamesAnddpeValues["LVcaTrip"] = 42;
  ca_dpeNamesAnddpeValues["LVcaMask"] = 43;
  myDaq->setCardParameters(0, 0, ca_dpeNamesAnddpeValues, 5);
  */
  //======================================= Set Crate Controllers parameters ============================
  /*
  //set one variable in a crate 
  string cr_para("CC_Reset");
  float cr_value = 15;
  for(int icrate=0; icrate<2; icrate++)
    {
      myDaq->setCrateCtrlParameter(icrate, cr_para, cr_value, 5);
      cr_value = cr_value + 10;
    }

  //set several variables in a crate 
  std::map<string, float> cr_dpeNamesAnddpeValues;

  cr_dpeNamesAnddpeValues["CC_Reset"] = 52;
  cr_dpeNamesAnddpeValues["CCch_Set"] = 53;
  cr_dpeNamesAnddpeValues["CCchRead"] = 54;
  myDaq->setCrateCtrlParameters(0, cr_dpeNamesAnddpeValues, 5);
  //myDaq->setCrateCtrlParameters(1, cr_dpeNamesAnddpeValues, 5);
  */
  //======================================= Read Channel parameters ============================
    
  // int variables
  string dpeNameInt("LVchStat");
  int dpeValueInt = 0;
  myDaq->getChannelParameter(0, 0, dpeNameInt, dpeValueInt, 10);
  cout<<"=========== channel dpeValueInt = "<<dpeValueInt<<endl;
  /*
  //float variables
  std::vector<string> ch_dpeNames;
  ch_dpeNames.push_back(string("LVch_Vcc"));
  ch_dpeNames.push_back(string("LVps_Vcc"));
  ch_dpeNames.push_back(string("LVretVcc"));
  ch_dpeNames.push_back(string("LVch_Icc"));

  std::map<string, float> ch_dpeValues;
  myDaq->getChannelParameters(0, 0, ch_dpeNames, ch_dpeValues, 10);
  map<string, float>::const_iterator map_itr;
  int ch_i = 0;
  float ch_dpeValue = 9999.9;
  for(map_itr=ch_dpeValues.begin(); map_itr!=ch_dpeValues.end(); map_itr++)
    {
      cout<<"========= ch_map1: "<<map_itr->first<<'\t'<<map_itr->second<<endl;
      myDaq->getChannelParameter(0, 0, ch_dpeNames[ch_i], ch_dpeValue, 10); ch_i++;
      cout<<"========= ch_map2: "<<ch_dpeValue<<endl;
    }
  */
  //string variables
  
  //======================================== read Card parameters ================================
    /*
  // int variables
  dpeNameInt = "LVcaStat";
  dpeValueInt = 0;
  myDaq->getCardParameter(0, 0, dpeNameInt, dpeValueInt, 10);
  cout<<"=========== card dpeValueInt = "<<dpeValueInt<<endl;

  // float variables
  std::vector<string> ca_dpeNames;
  //ca_dpeNames.push_back(string("LVcaStat"));
  //ca_dpeNames.push_back(string("LVcaTemp"));
  //ca_dpeNames.push_back(string("LVcaPowr"));
  ca_dpeNames.push_back(string("HVcaStat"));
  
  std::map<string, float> ca_dpeValues;
  myDaq->getCardParameters(0, 0, ca_dpeNames, ca_dpeValues, 10);
  //map<string, float>::const_iterator map_itr;
  int ca_i = 0;
  float ca_dpeValue = 9999.9;
  for(map_itr=ca_dpeValues.begin(); map_itr!=ca_dpeValues.end(); map_itr++)
    {
      cout<<"========= ca_map1: "<<map_itr->first<<'\t'<<map_itr->second<<endl;
      myDaq->getCardParameter(0, 0, ca_dpeNames[ca_i], ca_dpeValue, 10); ca_i++;
      cout<<"========= ca_map2: "<<ca_dpeValue<<endl;
    }
    */
  //================================ read Crate controller parameters ============================
    /*
  //read send value
  std::vector<string> ctrl_dpeNames;
  ctrl_dpeNames.push_back(string("CC_Reset"));
  ctrl_dpeNames.push_back(string("CCch_Set"));
  ctrl_dpeNames.push_back(string("CCchRead"));

  std::map<string, float> ctrl_dpeValues;
  myDaq->getCrateCtrlParameters(0, ctrl_dpeNames, ctrl_dpeValues, 10, "Send");
  int ctrl_i = 0;
  float ctrl_dpeValue = 9999.9;
  //map<string, float>::const_iterator map_itr;
  for(map_itr=ctrl_dpeValues.begin(); map_itr!=ctrl_dpeValues.end(); map_itr++)
    {
      cout<<"=========1 ctrl_Send: "<<map_itr->first<<'\t'<<map_itr->second<<endl;
      myDaq->getCrateCtrlParameter(0,  ctrl_dpeNames[ctrl_i], ctrl_dpeValue, 10, "Send"); 
      ctrl_i++;
      cout<<"=========2 ctrl_Send: "<<ctrl_dpeValue<<endl;
    }
    */
  //======================================= read Crate parameters ================================
  /*
  // int variables
  dpeNameInt = "Stat";
  dpeValueInt = 0;
  myDaq->getCrateParameter(0, dpeNameInt, dpeValueInt, 10);
  cout<<"=========== crate dpeValueInt = "<<dpeValueInt<<endl;

  // float variables
  std::vector<string> cr_dpeNames;
  cr_dpeNames.push_back(string("Stat"));
  
  std::map<string, float> cr_dpeValues;
  myDaq->getCrateParameters(0, cr_dpeNames, cr_dpeValues, 10);
  int cr_i = 0;
  float cr_dpeValue = 9999.9;
  //map<string, float>::const_iterator map_itr;
  for(map_itr=cr_dpeValues.begin(); map_itr!=cr_dpeValues.end(); map_itr++)
    {
      cout<<"========= cr_map: "<<map_itr->first<<'\t'<<map_itr->second<<endl;
      myDaq->getCrateParameter(0,  cr_dpeNames[cr_i], cr_dpeValue, 10); cr_i++;
      cout<<"========= cr_map2: "<<cr_dpeValue<<endl;
    }

  */
  //======================================= IV Curve Data============================================
/*
  float* float_array;
  int array_size;
  cout<<"==================================IV Curve 1"<<endl;
  myDaq->getIVCurveData(float_array, array_size, 20);
  cout<<"================================== array_size = "<< array_size <<endl;
  for(int i=0; i<array_size; i++)
    {
      cout<<"==================================float_array1 = "<< float_array[i]<<endl;
    }
*/
  //========================== change state, load config and hard reset =============================
  /*
  myDaq->changeState(0, 0, 33, 5);
  sleep(3);
  myDaq->changeState(0, "ALL", 33, 5);
  sleep(3);
  //load configuration constants for all channels in a given crate
  myDaq->loadConfiguration(0, 44, 5);
  sleep(3);
  //reset one module ( correponding to a channel in a PS crate)
  sleep(3);
  myDaq->hardReset(0, 26, 5);
  sleep(3);
  //reset 48 modules ( correponding to all channels in a PS crate)
  myDaq->hardReset(0, "ALL", 5);
  */

  //======================== change the slect line for a given crate channels ========================
  myDaq->setChannelsSelectLine(0, 0, 60);
  sleep(15);
  myDaq->setChannelsSelectLine(0, 1, 60);
  //======================================= Read from IS ============================================

  //this is a test for a method that read the a varible from an IS server.. the query of this is done
  //via configuration file (may be useful when the required varibles are know at configuration time!)

  float  value_float = 9999.9;
  myDaq->readFromIS("Crate00.Channel00.MOch_Tm0.Recv", value_float);
  //myDaq->run(ctrls);
  
  //this loop is to the program alife
  while(true)
    {
      cout<<"=========== value_float2 = "<<value_float<<endl;
      sleep(4);
    }
  
  delete myDaq;
  
  for(int i=0; ctrls[i] != 0; i++) 
	  free(ctrls[i]);	
  
  return(0);	
}
