package ProdDatabase;

public interface barrelMetrologyData {

  static final String[] barrelEvents = {"IN","SB","TC","LT","LTL","IRR"};

  static final String[] categories = {"Good","PASS","PASS2","SPARE","FAIL"};

  static final String[] xyMetrologyParameters = {
  "mhx","mhy","msx","msy","sepf","sepb","midxf","midyf","a1","a2","a3","a4",
  "stereo","hymxf","hymyf","hymaf","hymxb","hymyb","hymab","conp1x","conp1y",
  "machine","temperature"};

   static final String[] zBarrelDBParameters = {
  "MAXZLWR",
 "MAXZUPR",
 "LEFT_A",
 "LEFT_B",
 "LEFT_C",
 "RIGHT_A",
 "RIGHT_B",
 "RIGHT_C",
 "MIDPLHGHT",
 "MODTHKNSS",
 "OPTMAXZERRLWR",
 "OPTMAXZERRUPR",
 "OPTRMSZERRLWR",
 "OPTRMSZERRUPR",
 "MODCNCVTY_X",
 "MODCNCVTY_Y",
 "SNSRSKW_X",
 "SNSRSKW_Y",
 "CTBTHKNSS",
 "FTBTHKNSS",
 "HLFTBTHKNSS",
 "TBSKW_Y",
 "ADHTHKNSSTTL",
 "ADHASYMMTRY",
 "LOCOOLNGF_A",
 "LOCOOLNGF_B",
 "LOCFCNCVTY",
 "HYB1NRH",
 "HYB1FRH",
 "HYB2NRH",
 "HYB2FRH",
 "HYB1CNCVTY",
 "HYB2CNCVTY",
 "HYB1CMAXH",
 "HYB2CMAXH",
 "HYBMAXTHKNSS",
 "CMAXTHKNSS",
 "MESUREJIG",
 "TEMPERATURE"};

// offsets to convert xy metrology from relative to absolute
static final double[] XYOffsets = {-6500.0,
-37000.0,38500.0,-37000.0,64090.0,64090.0,
0.0,0.0,0.0,0.0,0.0,0.0,
-20.0,7698.5,-154.0,-20.0,7698.5,154.0,20.0,3611.8,-69451.1};

// conversion factors to convert um to mm
static final double[] XYConversions = {1000.0,
1000.0,1000.0,1000.0,1000.0,1000.0,1000.0,1000.0,
1.0,1.0,1.0,1.0,1.0,1000.0,1000.0,1.0,1000.0,1000.0,1.0,
1000.0,1000.0};

// the toleranaces for good/pass/pass2/spare
static final double[][] XYTolerances = {
{30.,30.,100.,30.,10.,10.,10.,5.,0.13,0.13,0.13,0.13,0.13,100.,100.,3.145,100.,100.,3.145,320.,100.},  //GOOD
{40.,40.,140.,40.,20.,20.,20.,8.,0.13,0.13,0.13,0.13,0.13,200.,200.,3.145,200.,200.,3.145,480.,200.},  //PASS
{50.,50.,170.,50.,30.,30.,30.,10.,0.16,0.16,0.16,0.16,0.16,500.,300.,6.29,500.,300.,6.29,640.,300.},   //PASS2
{60.,60.,200.,60.,40.,40.,40.,15.,0.24,0.24,0.24,0.24,0.24,500.,300.,6.29,500.,300.,6.29,640.,300.}    //SPARE
};

// the precision, ie the number of digits that follow the decimal point
static final int[] XYTolerances_rd = {0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,3,0,0,3,0,0};

static final double[] XYLowerLimit = {-7100.0,-37600.0,36500.0,-37600.0,63890.0,63890.0,
-200.0,-100.0,-3.0,-3.0,-3.0,-3.0,
-23.0,5600.0,-2200.0,-100.0,5600.0,-2000.0,-50.0,-3000.0,-71500.0};

static final double[] XYUpperLimit = {-5900.0,-36400.0,40500.0,-36400.0,64290.0,64290.0,
200.0,100.0,3.0,3.0,3.0,3.0,
-17.0,10000.0,2000.0,50.0,10000.0,2200.0,100.0,10100.0,-67000.0};


  static final String[] zMetrologyParameters = {
  "maxZlower","maxZupper","left_a","left_b","left_c","right_a","right_b","right_c",
  "midplaneHeight","moduleThcknss",
  "optMaxZerrorLower","optMaxZerrorUpper","optRmsZerrorLower","optRmsZerrorUpper",
  "modConcavity x","modConcavity y","sensorSkew x","SensorSkew y",
  "coolingTabThcknss","farTabThcknss","halfTabThcknss","tabSkew y","adhesiveThcknss",
  "adhesiveAsymm","loCoolingFac a","loCoolingFac b","loCoolConcavity",
  "hyb1NearH","Hyb1FarH","Hyb2NearH","Hyb2FarH","hyb1Concavity","hyb2Concavity",
  "hyb1CapMaxH","hyb2CapMaxH","hybMaxThcknss","capMaxThcknss",
  "machine","temperature"};

// Design values

static final double[][] ZTolerances = {
{-0.2,0.2,-1.,-1.,-1.,-1.,-1.,-1.,-1.,1.25,0.05,0.05,0.025,0.025,-1.,-1.,-1.,-1.,-1.,-1.,-1.,-1.,-1.,-1.,0.5,3.,0.03,0.19,0.19,0.19,0.19,0.15,0.15,2.73,2.73,3.74,6.44,-1.,-.1},
{-0.2,0.2,-1.,-1.,-1.,-1.,-1.,-1.,-1.,1.25,0.07,0.07,0.025,0.025,-1.,-1.,-1.,-1.,-1.,-1.,-1.,-1.,-1.,-1.,0.5,5.,0.03,0.25,0.25,0.25,0.25,0.25,0.25,2.73,2.73,3.74,6.44,-1.,-.1},
{-0.2,0.2,-1.,-1.,-1.,-1.,-1.,-1.,-1.,1.30,0.09,0.09,0.03,0.03,-1.,-1.,-1.,-1.,-1.,-1.,-1.,-1.,-1.,-1.,0.6,6.,0.04,0.35,0.35,0.35,0.35,0.35,0.35,2.73,2.73,3.74,6.44,-1.,-.1},
{-0.2,0.2,-1.,-1.,-1.,-1.,-1.,-1.,-1.,1.35,0.11,0.11,0.03,0.03,-1.,-1.,-1.,-1.,-1.,-1.,-1.,-1.,-1.,-1.,0.6,7.,0.05,0.35,0.35,0.35,0.35,0.35,0.35,2.73,2.73,3.74,6.44,-1.,-.1}
};

// the precision, ie the number of digits that follow the decimal point
static final int[] ZTolerances_rd = {1,1,0,0,0,0,0,0,0,2,2,2,3,3,0,0,0,0,0,0,0,0,0,0,1,0,2,2,2,2,2,2,2,1,1,2,2,0,0};
// 0=minimum value, 1=max value, 2=tolerance, 3=ignore
static final int[] ZToleranceType = {0,1,3,3,3,3,3,3,3,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,1,1,1,1,3,3};

//
static final boolean[] is_SB_ZTolerance =
{true,true,false,false,false,false,false,false,false,true,true,true,true,true,
false,false,false,false,false,false,false,false,false,false,true,true,true,
false,false,false,false,false,false,false,false,false,true,false,false};

static final double[] ZDesignValues = {0.0,0.0,0.0,0.0,0.47,0.0,0.0,0.47,0.47,
1.15,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,
0.94,0.94,0.47,0.0,0.16,0.0,0.0,0.0,0.0,
1.18,1.18,1.18,1.18,0.0,0.0,2.43,2.43,3.3,5.8};

static final double[] ZLowerLimit = {-4.0,-4.0,-0.06,-0.06,-0.29,-0.06,-0.06,-0.29,-0.29,
-0.85,-1.0,-1.0,-0.5,-0.5,-2.0,-2.0,-8.0,-8.0,-0.56,-0.56,-0.29,-1.5,-1.44,
-1.6,-10.0,-60.0,-0.6,-2.62,-2.62,-2.62,-2.62,-3.0,-3.0,-3.57,-3.57,-5.7,-7.6};

static final double[] ZUpperLimit = {4.0,4.0,0.06,0.06,1.23,0.06,0.06,1.23,1.23,3.15,
1.0,1.0,0.5,0.5,2.0,2.0,8.0,8.0,2.44,2.44,1.23,1.5,1.76,1.6,10.0,60.0,0.6,
4.98,4.98,4.98,4.98,3.0,3.0,8.43,8.43,12.3,19.2};

}