package ProdDatabase;
/**
 *
 * @author  robinson
 */
import java.util.*;
import java.sql.*;

public class WaferUtilities {

// ******************************************************************************************************************
   public static String getCalCorrFactor(String wafer) throws Exception {
       StringBuffer        sqlStat;
      int recordCount=0;
      java.text.DecimalFormat myFormatter = new java.text.DecimalFormat("#.###");
      sqlStat = new StringBuffer("SELECT tests.ser_no,tests.test_no,items.mfr_ser_no,test_wafer_e_param.structure,test_wafer_e_param.toxp1n_plus");
      sqlStat.append(" FROM tests,items,test_wafer_e_param WHERE test_wafer_e_param.test_no=tests.test_no");
      sqlStat.append(" AND items.mfr_ser_no LIKE'"+wafer+"'");
      sqlStat.append(" AND items.ser_no=tests.ser_no");
      sqlStat.append(" ORDER BY tests.ser_no,tests.test_no");
      Hashtable thisHash = new Hashtable();

      String S1key = "S1KEY";
      String S2key = "S2KEY";
      String S3key = "S3KEY";
      String S4key = "S4KEY";
      String S5key = "S5KEY";

      SCTDBInterface db = SCTDBInterface.getInstance();
      ResultSet resultSet;
      Statement statement = db.connection.createStatement();

//    System.out.println("Interrogating tests and test_wafer_e_param tables ...");
//     System.out.println(sqlStat.toString());
     resultSet = statement.executeQuery(sqlStat.toString());
     recordCount=0;
     String thisTestNo="";
     for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
          recordCount++;
          if(recordCount%200 == 0) System.out.println("Retrieved "+recordCount+" structure records so far...");
          String serno = resultSet.getString(1);
          String testno = resultSet.getString(2);
          String lotno = resultSet.getString(3);
          String structureNo = resultSet.getString(4);
          String oxthickness = resultSet.getString(5);
          try {
              double ox = Double.parseDouble(oxthickness);  // trap in case corrupt or invalid data

              if(!testno.equals(thisTestNo)) {   // in case there is more than one test for this wafer, take only the latest
                  thisHash = new Hashtable();
                  thisTestNo=testno;
              }

               String thiskey = "S"+structureNo+"KEY";
               thisHash.put(thiskey,oxthickness);
               
          } catch(Exception e2) {System.out.println("WARNING: Corrupt database data: Invalid TOXP1N_PLUS value for serial no "+serno);}
 
 
	    }
//      System.out.println("Retrieved "+recordCount+" records in total.");
 
      statement.close();
      if(recordCount==0) {
            System.out.println("Cal corr factors not available for wafer "+wafer);
            return "";
            }

      double[] ts = new double[5];
      int tscount=0;
      for(int j=1;j<6;j++) {
        ts[j-1]=0.0;
        String theKey = "S"+j+"KEY";
        if(thisHash.containsKey(theKey)) {
                  ts[j-1] = Double.valueOf( (String)thisHash.get(theKey) ).doubleValue();
                  tscount++;
                  }
        else System.out.println("No data for structure "+j+" from wafer "+wafer);
        }
          
        double mean=0.0;
        for(int j=1;j<6;j++) mean += ts[j-1];
        mean = tscount>0 ?  mean/(double)tscount: 0.0;
        double corr = mean>0.0 ? 420./mean : 0.0;

        String stringCorr = myFormatter.format(corr);
        return stringCorr;


      }

}