package ProdDatabase;
/*
 * SCTDBInfo.java
 */

/**
 *
 * @author  robinson
 */
public interface SCTDBInfo  {
static final String[] dataSheetTestDBNames = {"bmMOD_RData","bmHASIC_RData","bmHP_RData","bmSB_RData","bmBB_RData"};
static final String[] moduleParts = {"Module","ASIC-Hybrid","Bare Hybrid","Sensor-Baseboard","Baseboard"};
static final int bmBB=4;
static final int bmSB=3;
static final int bmHPC=2;
static final int bmHASIC=1;
static final int bmMODULE=0;
static final int SENSOR_TESTDATA=5;

   static final String[] Clusters = {"Japan","USA","Scand","UK"};
   static final String[] UserNames = {"KEK","LBL","UPPS","RAL"};
   static final String[] MfrNames = {"KEK","Berkley LBL","Uppsala","RAL"};            // note bad spelling of berkeley
   static final String[] clusterNames = {"KEK","Berkeley LBL","Uppsala","RAL"};
   static final String CERNbb = "CERN Brl Base";
   static final String CERNbbFlag = "48";
   static final String[] snFlag = {"17","04","38","33"};
   static final String[] Institutes = {"Anywhere",
				       "Atmel","Barcelona",
                                       "Bergen",
                                       "Berkeley LBL",
                                       "Bern",
                                       "Birmingham",
                                       "Cambridge",
                                       "CERN","CERN Brl Base","CERN FE Chip","CERN Sys Test",
				       "ChipDicingCa","ChipDicingFr","ChipDicingUK",
                                       "CiS",
                                       "Cracow FPNT",
                                       "Cracow INP",
                                       "Dortmund",
                                       "Freiburg",
                                       "Geneva",
                                       "Glasgow",
                                       "Hamburg",
                                       "Hamamatsu",
                                       "Hiroshima",
                                       "KEK",
                                       "Kyoto",
                                       "Lancaster",
                                       "Liverpool",
                                       "Ljubljana",
                                       "London, UCL",
                                       "London,QMW",
                                       "Manchester",
                                       "Melbourne",
                                       "Moscow, NPI",
                                       "Munich MPI",
                                       "NIKHEF",
                                       "New Mexico",
                                       "Oslo",
                                       "Oxford",
                                       "Prague Acad Sci",
                                       "Prague CU",
                                       "Prague CVUT",
                                       "Protvino",
                                       "RAL",
                                       "Sheffield",
                                       "Sydney",
                                       "Taiwan",
                                       "Tsukuba",
                                       "UC Irvine",
                                       "UC Santa Cruz",
                                       "Uppsala",
                                       "Valencia",
                                       "Wisconsin"};
static final String[] fileSuffixes = {"BASEBOARD_","SENSOR_BASEBOARD_","HPC_HYBRID_","ASIC_HYBRID_","MODULE_","XYSURVEY_","ZSURVEY_"};
static final String[] fileDescriptions = {"Baseboard","Sensor-Baseboard","HPC-Hybrid","ASIC-Hybrid","Module","XY Survey","Z Survey"};
static final String[] attributeName = {"bmBB_RData","bmSB_RData","bmHP_RData","bmHASIC_RData","bmMOD_RData","bmSurveyXY","bmSurveyZ"};
static final String[] dataSheetTestNames = {"bmBB_RData","bmSB_RData","bmHP_RData","bmHASIC_RData","bmMOD_RData","ModBarXYsurvey","ModBarZsurvey"};
    
   static final String[] sctdaqNormalTestNames = {
       "Reset","Redundancy","FullByPass","Pipeline",
       "StrobeDelay","3PtGain","Trim","ResponseCurve","Noise","TimeWalk","LongTerm","IVscan"};

   static final String[] sctdaqDBTestNames = {
       "HybReset","HybRedund","HybBPass","HybPipe",
       "HybDelay","Hyb3PGain","HybTrim","HybRC","HybNoise","HybTWalk","HybLTT","DetModIV"};

   static final String[] sctdaqDBTableNames = {
       "SCT_TSTHYBRESET","SCT_TSTHybRedund","SCT_TSTHybBPass","SCT_TSTHybPipe",
       "SCT_TSTHybDelay","SCT_TSTHYBRC","SCT_TSTHybTrim","SCT_TSTHYBRC","SCT_TSTHybNoise","SCT_TSTHybTW","SCT_TSTHYBLTT","tstdetivs"};

   static final String[] chipDBnames = {"M0_","S1_","S2_","S3_","S4_","E5_","M8_","S9_","S10_","S11_","S12_","E13_"};
   static final String[][] DBChipParameterNames = {
                   {},
                   {},
                   {"TOKEN","RTOKEN","COMMENT","RCOMMENT"},
                   {"NGOOD"},
                   {"DELAY"},
                   {"RC_MN_VT50","RC_RMS_VT50","RC_MN_GAIN","RC_RMS_GAIN","RC_MN_OFFSET","RC_RMS_OFFSET","RC_MN_NSE","RC_MN_ENC","RC_RMS_ENC","RC_FIT","RC_P0","RC_P1","RC_P2"},
                   {"TR_RANGE","TR_TARGET","TR_NTRIM","TR_MN_VT50","TR_RMS_VT50","TR_MNOFFSET","TR_RMSOFFSET","TR_MN_STEP","TR_RMS_STEP"},
                   {"RC_MN_VT50","RC_RMS_VT50","RC_MN_GAIN","RC_RMS_GAIN","RC_MN_OFFSET","RC_RMS_OFFSET","RC_MN_NSE","RC_MN_ENC","RC_RMS_ENC","RC_FIT","RC_P0","RC_P1","RC_P2"},
                   {"NO_OFFSET","NO_MN_OCC","NO_RMS_OCC","NO_NSE"},
                   {"TW","TCAL"},
                   {},
                   {}
          };
   static final String[][] fullTestParameterNames = {
                {},
                {},
                {"Token","RToken","Comment","RComment"},
                {"N(bad)"},
                {"Delay"},
                {"vt50 (mV)","vt50 RMS","Gain (mV/fC)","Gain RMS","Offset (mV)","Offset RMS","Output Noise (mV)","Input Noise (enc)","Noise RMS (enc)","Fit","P0","P1","P2","Comment"},
                {"Range","Target","N(untrimmed)","vt50 (mV)","vt50 RMS","Offset (mV)","Offset RMS","Step size (mV)","Step Size RMS"},
                {"vt50 (mV)","vt50 RMS","Gain (mV/fC)","Gain RMS","Offset (mV)","Offset RMS","Output Noise (mV)","Input Noise (enc)","Noise RMS (enc)","Fit","P0","P1","P2","Comment"},
                {"Offset","Occupancy","RMS Occupancy","Noise (enc)"},
                {"TimeWalk","TCal"},
                {},
                {},
         };

   public static final int SCTDB_TEST_RESET=0;
   public static final int SCTDB_TEST_REDUNDANCY=1;
   public static final int SCTDB_TEST_FULLBYPASS=2;
   public static final int SCTDB_TEST_PIPELINE=3;
   public static final int SCTDB_TEST_STROBEDELAY=4;
   public static final int SCTDB_TEST_3PTGAIN=5;
   public static final int SCTDB_TEST_TRIM=6;
   public static final int SCTDB_TEST_NPTGAIN=7;
   public static final int SCTDB_TEST_NOISE=8;
   public static final int SCTDB_TEST_TIMEWALK=9;
   public static final int SCTDB_TEST_LONGTERM=10;
   public static final int SCTDB_TEST_IV=11;
}