package Preferences;
/*
 * Preference.java
 *
 * Created on 14 October 2003, 13:28
 */

/**
 *
 * @author  robinson
 */
public class Preference extends javax.swing.JDialog {

    private javax.swing.JLabel titleLabel;
    private javax.swing.JButton updateButton;
    private javax.swing.JButton closeButton;
    private javax.swing.JLabel valueLabel;
    private int parameter;
    private PreferencesInterface preferences = PreferencesInterface.getInstance();
    private javax.swing.JFrame topFrame;

    /** Creates new form JDialog */
    public Preference(javax.swing.JFrame parent, int parameter) {
        super(parent, "Set Preference", true);
        topFrame=parent;
        this.parameter=parameter;
        initComponents();
        setLocationRelativeTo(topFrame);
        setVisible(true);
    }
    public String getValue() {
        return valueLabel.getText();
        }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        titleLabel = new javax.swing.JLabel();
        updateButton = new javax.swing.JButton();
        closeButton = new javax.swing.JButton();
        valueLabel = new javax.swing.JLabel();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        titleLabel.setFont(new java.awt.Font("Arial", 1, 12));
        titleLabel.setForeground(new java.awt.Color(255, 0, 0));
        titleLabel.setText(preferences.getDescription(parameter));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 0.4;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        getContentPane().add(titleLabel, gridBagConstraints);

        valueLabel.setFont(new java.awt.Font("Arial", 0, 12));
        valueLabel.setText(preferences.getPreference(parameter));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        gridBagConstraints.weighty = 0.3;
        getContentPane().add(valueLabel, gridBagConstraints);

        updateButton.setFont(new java.awt.Font("Arial", 0, 12));
        updateButton.setText("Change...");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        gridBagConstraints.weightx = 0.3;
        getContentPane().add(updateButton, gridBagConstraints);

        closeButton.setFont(new java.awt.Font("Arial", 0, 12));
        closeButton.setText("Close");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        gridBagConstraints.weightx = 0.3;
        getContentPane().add(closeButton, gridBagConstraints);

        closeButton.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) { 
                     closeForm();      
                     }
             });



        updateButton.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                     javax.swing.JFileChooser fc;
                     int returnVal;
                     switch(parameter) {
                       case PreferencesInterface.PSVIEWER:
                          fc = new javax.swing.JFileChooser();
                          fc.setDialogTitle("Find a postscript viewer executable:");
                          returnVal = fc.showOpenDialog(topFrame);
                          if (returnVal == javax.swing.JFileChooser.APPROVE_OPTION) {
                               java.io.File file = fc.getSelectedFile();
                               if(!file.exists()) javax.swing.JOptionPane.showMessageDialog(null,file.getAbsolutePath()+" does not exist","Error",javax.swing.JOptionPane.ERROR_MESSAGE);
                               else {
                                 valueLabel.setText(file.getAbsolutePath());
                                 preferences.setPreference(PreferencesInterface.PSVIEWER,file.getAbsolutePath());
                                 pack();
                                 }
                               }
                          break;
                       case PreferencesInterface.SCRATCH_DIR:
                          fc = new javax.swing.JFileChooser();
                          fc.setDialogTitle("Select a suitable scratch disk:");
                          fc.setFileSelectionMode(javax.swing.JFileChooser.DIRECTORIES_ONLY);

                          returnVal = fc.showOpenDialog(topFrame);
                          if (returnVal == javax.swing.JFileChooser.APPROVE_OPTION) {
                               java.io.File file = fc.getSelectedFile();
                               if(!file.exists()) javax.swing.JOptionPane.showMessageDialog(null,file.getAbsolutePath()+" does not exist","Error",javax.swing.JOptionPane.ERROR_MESSAGE);
                               else {
                                 valueLabel.setText(file.getAbsolutePath());
                                 preferences.setPreference(PreferencesInterface.SCRATCH_DIR,file.getAbsolutePath());
                                 pack();
                                 }
                               }
                          break;
                       case PreferencesInterface.UPLOAD_DIR:
                          fc = new javax.swing.JFileChooser();
                          fc.setDialogTitle("Select a suitable upload directory:");
                          fc.setFileSelectionMode(javax.swing.JFileChooser.DIRECTORIES_ONLY);

                          returnVal = fc.showOpenDialog(topFrame);
                          if (returnVal == javax.swing.JFileChooser.APPROVE_OPTION) {
                               java.io.File file = fc.getSelectedFile();
                               if(!file.exists()) javax.swing.JOptionPane.showMessageDialog(null,file.getAbsolutePath()+" does not exist","Error",javax.swing.JOptionPane.ERROR_MESSAGE);
                               else {
                                 valueLabel.setText(file.getAbsolutePath());
                                 preferences.setPreference(PreferencesInterface.UPLOAD_DIR,file.getAbsolutePath());
                                 pack();
                                 }
                               }
                          break;
                       case PreferencesInterface.WEB_LOOKUP_DIR:
                          fc = new javax.swing.JFileChooser();
                          fc.setDialogTitle("Select the directory for the web lookup table:");
                          fc.setFileSelectionMode(javax.swing.JFileChooser.DIRECTORIES_ONLY);

                          returnVal = fc.showOpenDialog(topFrame);
                          if (returnVal == javax.swing.JFileChooser.APPROVE_OPTION) {
                               java.io.File file = fc.getSelectedFile();
                               if(!file.exists()) javax.swing.JOptionPane.showMessageDialog(null,file.getAbsolutePath()+" does not exist","Error",javax.swing.JOptionPane.ERROR_MESSAGE);
                               else {
                                 valueLabel.setText(file.getAbsolutePath());
                                 preferences.setPreference(PreferencesInterface.WEB_LOOKUP_DIR,file.getAbsolutePath());
                                 pack();
                                 }
                               }
                          break;
                       case PreferencesInterface.IV_DIRECTORY:
                          fc = new javax.swing.JFileChooser();
                          fc.setDialogTitle("Select IVscan data directory:");
                          fc.setFileSelectionMode(javax.swing.JFileChooser.DIRECTORIES_ONLY);

                          returnVal = fc.showOpenDialog(topFrame);
                          if (returnVal == javax.swing.JFileChooser.APPROVE_OPTION) {
                               java.io.File file = fc.getSelectedFile();
                               if(!file.exists()) javax.swing.JOptionPane.showMessageDialog(null,file.getAbsolutePath()+" does not exist","Error",javax.swing.JOptionPane.ERROR_MESSAGE);
                               else {
                                 valueLabel.setText(file.getAbsolutePath());
                                 preferences.setPreference(PreferencesInterface.IV_DIRECTORY,file.getAbsolutePath());
                                 pack();
                                 }
                               }
                          break;
                       case PreferencesInterface.INSTITUTE:
                         java.util.Vector listOfLocations = new java.util.Vector();
                         try {
                         listOfLocations = ProdDatabase.GeneralUtilities.getLocationList();
                         }catch(Exception e2){}
                         String thisLoc = preferences.getPreference(PreferencesInterface.INSTITUTE);
                         if(thisLoc.equals(PreferencesInterface.unDefinedString)) thisLoc="Any";
                         guiUtilities.userPrompt thisPrompt = new guiUtilities.userPrompt(topFrame,thisLoc,"Institute", listOfLocations);
                         thisPrompt.pack();
                         thisPrompt.setLocationRelativeTo(topFrame);
                         thisPrompt.setVisible(true);
                         String thisLocation = thisPrompt.getValidatedText();
                         if (!thisLocation.equals("None")) {
                                 valueLabel.setText(thisLocation);
                                 preferences.setPreference(PreferencesInterface.INSTITUTE,thisLocation);
                                 pack();
                                 }                   
                         break;
                       case PreferencesInterface.SCT_VIEW:
                         java.util.Vector listOfViews = new java.util.Vector();
                         for(int i=0;i<DisplayGUI.SCTInfo.SCTViewNames.length;i++) listOfViews.addElement(DisplayGUI.SCTInfo.SCTViewNames[i]);
                         String thisView = preferences.getPreference(PreferencesInterface.SCT_VIEW);
                         if(thisView.equals(PreferencesInterface.unDefinedString)) thisView="Barrel 3";
                         thisPrompt = new guiUtilities.userPrompt(topFrame,thisView,"SCT View", listOfViews);
                         thisPrompt.pack();
                         thisPrompt.setLocationRelativeTo(topFrame);
                         thisPrompt.setVisible(true);
                         thisView = thisPrompt.getValidatedText();
                         if (!thisView.equals("None")) {
                                 valueLabel.setText(thisView);
                                 preferences.setPreference(PreferencesInterface.SCT_VIEW,thisView);
                                 pack();
                                 }                   
                         break;
                      case PreferencesInterface.DCS_SERVER_NAME:
                         String response = javax.swing.JOptionPane.showInputDialog("Enter DCS IS Server Name",preferences.getPreference(PreferencesInterface.DCS_SERVER_NAME));
                         if(response!=null) {  
                                 valueLabel.setText(response);                               
                                 preferences.setPreference(PreferencesInterface.DCS_SERVER_NAME,response);
                                 }                   
                         break;
                     case PreferencesInterface.PASSWORD:
                         response = javax.swing.JOptionPane.showInputDialog("Enter SCTDB Password",preferences.getPreference(PreferencesInterface.PASSWORD));
                         if(response!=null) {  
                                 valueLabel.setText(response);                               
                                 preferences.setPreference(PreferencesInterface.PASSWORD,response);
                                 }                   
                         break;
                       default: 
                       }                           
                     }
             });
        pack();
    }
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {
        closeForm();
    }
    private void closeForm() {
        setVisible(false);
        dispose();
    }
    
    
    

    
}
