package DisplayGUI;

import java.io.*;
import java.util.*;
import is.*;
import Sct.Serializable;
import Sct.IS.*;
//import SctControl.*;
import java.sql.*;
import ProdDatabase.SCTDBInterface;
import ProdDatabase.SCTDBInfo;
import Sct_CalibrationController.TestData;
/*
 * SCTDBTestDownloader.java
 *
 */

/**
 *
 * @author  robinson
 */
public class SCTDBTestDownloader extends Thread implements SCTDBInfo, DisplayGUI.TestDataInfo {
    Vector listOfModules;
    int testIndex;
    String location;
    boolean isWarm;
    boolean refresh;
    boolean download;

    String runString;
    boolean isSCTDAQData;

    public static final double NODATA = -9999.;

    public SCTDBTestDownloader(Vector listOfModules, int testIndex, String location, boolean isWarm, boolean refresh) {
         super("SCTDB_DOWNLOAD");
         this.listOfModules=listOfModules;
         this.testIndex=testIndex;
         this.location=location;
         this.isWarm=isWarm;
         this.refresh=refresh;

         download=true;
         isSCTDAQData=true;

         for(int i=listOfModules.size()-1;i>=0;i--) {
            String module = (String)listOfModules.elementAt(i);
            String objectName = "SCTDBData."+testNames[testIndex]+"."+location+"."+(String)listOfModules.elementAt(i);
            // if ANY sctdb test object exists, and not requested a 'refresh' then don't download anything
            if(SctNames.getISRepository().contains(objectName) && !refresh) {
                download=false;
                break;
                }
            }

         if(testIndex==TEST_NMASK) download=false; // no such sctdaq test

         setPriority(Thread.MIN_PRIORITY);

         }

    public SCTDBTestDownloader(String runString, int testIndex, String location) {
// download SctRodDaq data
         super("SCTDB_DOWNLOAD");
         this.runString=runString;
         this.testIndex=testIndex;
         this.location=location;
         refresh=true;

         download=true;
         isSCTDAQData=false;

         setPriority(Thread.MIN_PRIORITY);

         }


    public boolean downloadsRequired() {
         return download;
         }
    public boolean isOkToStart() {
         Thread[] allThreads = new Thread[Thread.activeCount()];
         Thread.enumerate(allThreads);
         for(int i=0;i<allThreads.length;i++) {
            if(allThreads[i]!=null && allThreads[i].getName().equals("SCTDB_DOWNLOAD") && allThreads[i].isAlive()) {
                  javax.swing.JOptionPane.showMessageDialog(null,"A download from the SCT database is already in progress.\nPlease wait for this to complete before requesting another download.");
                  return false;
                  }
            }
         return true;
         }

    public void run() {
            
         Map snHash = new HashMap();
         Map testnoHash = new HashMap();
         Map dcsHash = new HashMap();

         Statement statement;
         ResultSet resultSet;

         String run=null;
         String scan=null;
         if(!isSCTDAQData) {
              java.util.regex.Pattern runP = java.util.regex.Pattern.compile("(\\d+)[-]?(\\d+)?");
              java.util.regex.Matcher matcher = runP.matcher(runString);
              if(matcher.matches()) {
                run = runString.substring(matcher.start(1),matcher.end(1));
                if(matcher.groupCount()==2) scan = runString.substring(matcher.start(2),matcher.end(2));
                else scan = "0";
                }
              else {
                System.err.println("SctGUI::SCTDBTestDownloader - Unrecognised run and scan number");
                return;
                }
              }

         StringBuffer moduleList = new StringBuffer();
         if(isSCTDAQData) {
          for(int i=0;i<listOfModules.size();i++) {
              if(i>0) moduleList.append(",");
              String module = (String)listOfModules.elementAt(i);
              if(module.equals("SCTTestAPI_PseudoModule")) moduleList.append("20220330200020");
              else moduleList.append(module);
              }
           System.out.println("SctGUI::SCTDBTestDownloader - Downloading "+listOfModules.size()+" module "+testNames[testIndex]+" tests.");
           }
         else System.out.println("SctGUI::SCTDBTestDownloader - Downloading SctRodDaq "+testNames[testIndex]+" data for Run "+runString);

         StringBuffer sqlStat = new StringBuffer();
// if this is SctRodDaq data, then first we must publish the control object
         if(!isSCTDAQData) {
             if(!publishControlObject(run,scan)) return;
             }


          sqlStat = new StringBuffer("SELECT tests.ser_no,tests.pass,tests.problem,tests.TEST_no,tests.locn_name,tests.TEST_date");
          sqlStat.append(",SCT_TSTDAQINFO.host,SCT_TSTDAQINFO.version,SCT_TSTDAQINFO.test_time");
          switch(testIndex) {
                    case SCTDB_TEST_RESET:
                    case SCTDB_TEST_REDUNDANCY:
                    case SCTDB_TEST_LONGTERM:
                    case SCTDB_TEST_IV:
                        break;
                    default:
                        for(int y=0;y<chipDBnames.length;y++) {
                           for(int paramIndex=0;paramIndex<DBChipParameterNames[testIndex].length;paramIndex++) {
                                  sqlStat.append(","+chipDBnames[y]+DBChipParameterNames[testIndex][paramIndex]);
                                  }
                          }

                     }
         sqlStat.append(" FROM "+sctdaqDBTableNames[testIndex]+",tests,SCT_TSTDAQINFO");
         if(isSCTDAQData) sqlStat.append(",sct_tstdcsinfo");

         sqlStat.append(" WHERE tests.TEST_name = '"+sctdaqDBTestNames[testIndex]+"'");
         if(isSCTDAQData) sqlStat.append(" AND tests.ser_no IN ("+moduleList.toString()+")");
         if(!location.equals("Any")) sqlStat.append(" AND tests.locn_name LIKE '"+location+"'");
         sqlStat.append(" AND tests.TEST_no = "+sctdaqDBTableNames[testIndex]+".TEST_no");
         sqlStat.append(" AND tests.test_no = SCT_TSTDAQINFO.test_no");
         if(isSCTDAQData) {
              sqlStat.append(" AND SCT_TSTDAQINFO.version NOT LIKE 'SctRodDaq%'");  // SCTDAQ data only
              if(isWarm) sqlStat.append(" AND sct_tstdcsinfo.t0>10 AND sct_tstdcsinfo.TEST_no=tests.TEST_no"); 
              else  sqlStat.append(" AND sct_tstdcsinfo.t0<=10 AND sct_tstdcsinfo.TEST_no=tests.TEST_no"); 
               }
         else sqlStat.append(" AND tests.run_no = '"+runString+"' AND SCT_TSTDAQINFO.version LIKE 'SctRodDaq%'");
         sqlStat.append(" ORDER BY tests.TEST_date DESC,tests.TEST_no DESC");

         try {

         statement = SCTDBInterface.getInstance().connection.createStatement();
//         System.out.println(sqlStat.toString());
         resultSet = statement.executeQuery(sqlStat.toString());
         for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
            int rc=1;

            String sn = resultSet.getString(rc++);
            if(snHash.containsKey(sn)) continue;
            int status = (resultSet.getString(rc++).equals("YES")) ? 0 : 2;
            if(status==0 && resultSet.getString(rc++).equals("YES")) status = 1;

            SCTDB_Data sctdbData = new SCTDB_Data(); 
            sctdbData.status=status; // 0: pass, 1: problem, 2: fail
            sctdbData.testIndex=testIndex;
            sctdbData.testNumber = resultSet.getString(rc++);
            String location = resultSet.getString(rc++);;
            sctdbData.testLocation = location;
            String date = guiUtilities.DaveUtils.extractDate(resultSet.getString(rc++));
            sctdbData.testDate=date;

            sctdbData.daqInfo = new String[5];
            for(int i=0;i<3;i++) {
                 String value = resultSet.getString(rc++);
                 sctdbData.daqInfo[i] = (value==null) ? "Unknown" : value;
                 }
            sctdbData.daqInfo[3]=date;
            sctdbData.daqInfo[4]=location;

            System.out.println("SctGUI::SCTDBTestDownloader - Downloading "+testNames[testIndex]+" for "+sn+" taken by "+sctdbData.testLocation+" on "+sctdbData.testDate);

            sctdbData.data_m0 = new double[DBChipParameterNames[testIndex].length];
            for(int r=0;r<DBChipParameterNames[testIndex].length;r++) sctdbData.data_m0[r]=getData(resultSet.getString(rc++));
            sctdbData.data_s1 = new double[DBChipParameterNames[testIndex].length];
            for(int r=0;r<DBChipParameterNames[testIndex].length;r++) sctdbData.data_s1[r]=getData(resultSet.getString(rc++));
            sctdbData.data_s2 = new double[DBChipParameterNames[testIndex].length];
            for(int r=0;r<DBChipParameterNames[testIndex].length;r++) sctdbData.data_s2[r]=getData(resultSet.getString(rc++));
            sctdbData.data_s3 = new double[DBChipParameterNames[testIndex].length];
            for(int r=0;r<DBChipParameterNames[testIndex].length;r++) sctdbData.data_s3[r]=getData(resultSet.getString(rc++));
            sctdbData.data_s4 = new double[DBChipParameterNames[testIndex].length];
            for(int r=0;r<DBChipParameterNames[testIndex].length;r++) sctdbData.data_s4[r]=getData(resultSet.getString(rc++));
            sctdbData.data_e5 = new double[DBChipParameterNames[testIndex].length];
            for(int r=0;r<DBChipParameterNames[testIndex].length;r++) sctdbData.data_e5[r]=getData(resultSet.getString(rc++));
            sctdbData.data_m8 = new double[DBChipParameterNames[testIndex].length];
            for(int r=0;r<DBChipParameterNames[testIndex].length;r++) sctdbData.data_m8[r]=getData(resultSet.getString(rc++));
            sctdbData.data_s9 = new double[DBChipParameterNames[testIndex].length];
            for(int r=0;r<DBChipParameterNames[testIndex].length;r++) sctdbData.data_s9[r]=getData(resultSet.getString(rc++));
            sctdbData.data_s10 = new double[DBChipParameterNames[testIndex].length];
            for(int r=0;r<DBChipParameterNames[testIndex].length;r++) sctdbData.data_s10[r]=getData(resultSet.getString(rc++));
            sctdbData.data_s11 = new double[DBChipParameterNames[testIndex].length];
            for(int r=0;r<DBChipParameterNames[testIndex].length;r++) sctdbData.data_s11[r]=getData(resultSet.getString(rc++));
            sctdbData.data_s12 = new double[DBChipParameterNames[testIndex].length];
            for(int r=0;r<DBChipParameterNames[testIndex].length;r++) sctdbData.data_s12[r]=getData(resultSet.getString(rc++));
            sctdbData.data_e13 = new double[DBChipParameterNames[testIndex].length];
            for(int r=0;r<DBChipParameterNames[testIndex].length;r++) sctdbData.data_e13[r]=getData(resultSet.getString(rc++));

// painful conversion from number of good channels to number of bad channels
            int index=0;
            switch(testIndex) {
               case SCTDB_TEST_PIPELINE:
                 convertData(sctdbData,0);
                 break;
               case SCTDB_TEST_TRIM:
                 convertData(sctdbData,2);
                 break;
               default:
               }


            snHash.put(sn,sctdbData);
            testnoHash.put(sctdbData.testNumber,new ArrayList()); // to be filled with the no of defects in next query
//            dcsHash.put(sctdbData.testNumber,new HashMap()); // to be filled with the no of defects in next query
            }
        statement.close();

        if(snHash.size()==0) {
            System.out.println("SctGUI::SCTDBTestDownloader - No Data available from SCTDB");
            return;
            }
        StringBuffer temp = new StringBuffer();
        int count=0;
        for (java.util.Iterator i = testnoHash.keySet().iterator(); i.hasNext(); ) {
            if(count>0) temp.append(",");
            count++;
            temp.append((String)i.next());
            }
        sqlStat = new StringBuffer();
        sqlStat.append("SELECT defects.TEST_no,defects.chan_1st,defects.chan_last,defects.defect_name");
        sqlStat.append(" FROM defects");
        sqlStat.append(" WHERE defects.TEST_no IN ("+temp.toString()+")");


        statement = SCTDBInterface.getInstance().connection.createStatement();
//         System.out.println(sqlStat.toString());
        resultSet = statement.executeQuery(sqlStat.toString());

        for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){ 
            String thisTestNo = resultSet.getString(1);
            List tempHash = (List)testnoHash.get(thisTestNo);
            String channels = resultSet.getString(2)+"-"+resultSet.getString(3);
            String defect = resultSet.getString(4);
//            System.out.println("defects: "+channels+" : "+defect);
            tempHash.add(channels+" : "+defect);
            }
        statement.close();
// now dcs data
        sqlStat = new StringBuffer();
        sqlStat.append("SELECT vdet,idet,t0,t1,vcc,icc,vdd,idd,test_no");
        sqlStat.append(" FROM SCT_TSTDCSINFO");
        sqlStat.append(" WHERE TEST_no IN ("+temp.toString()+")");


        statement = SCTDBInterface.getInstance().connection.createStatement();
//         System.out.println(sqlStat.toString());
        resultSet = statement.executeQuery(sqlStat.toString());

        for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){ 
            SummaryReader.DCSInfo dcs = new SummaryReader.DCSInfo();
            dcs.put(SummaryReader.DCSInfo.VDET,Double.parseDouble(resultSet.getString(1)));
            dcs.put(SummaryReader.DCSInfo.IDET,Double.parseDouble(resultSet.getString(2)));
            dcs.put(SummaryReader.DCSInfo.T0,Double.parseDouble(resultSet.getString(3)));
            dcs.put(SummaryReader.DCSInfo.T1,Double.parseDouble(resultSet.getString(4)));
            dcs.put(SummaryReader.DCSInfo.VCC,Double.parseDouble(resultSet.getString(5)));
            dcs.put(SummaryReader.DCSInfo.ICC,Double.parseDouble(resultSet.getString(6)));
            dcs.put(SummaryReader.DCSInfo.VDD,Double.parseDouble(resultSet.getString(7)));
            dcs.put(SummaryReader.DCSInfo.IDD,Double.parseDouble(resultSet.getString(8)));
            String testno=resultSet.getString(9);
            dcsHash.put(testno,dcs);
            }
        statement.close();

        for (java.util.Iterator i = snHash.keySet().iterator(); i.hasNext(); ) {
            String sn = (String)i.next();
            SCTDB_Data sctdbData = (SCTDB_Data)snHash.get(sn);
            List defectlist = (List)testnoHash.get(sctdbData.testNumber);
// defects
            sctdbData.noDefectChannels = defectlist.size();   
            sctdbData.defectList = new String[defectlist.size()];
            for(int y=0;y<defectlist.size();y++) sctdbData.defectList[y]=(String)defectlist.get(y);
// dcs
            sctdbData.dcsinfo = new double[8];
            if(dcsHash.containsKey(sctdbData.testNumber)) {
              SummaryReader.DCSInfo dcs = (SummaryReader.DCSInfo)dcsHash.get(sctdbData.testNumber);
              if(dcs==null) for(int j=0;j<8;j++) sctdbData.dcsinfo[j]=NODATA;
              else {
                for(int j=0;j<8;j++) {
                  Double dcsValue = (Double)dcs.get(j);
                  if(dcsValue!=null) sctdbData.dcsinfo[j]=dcsValue.doubleValue();
                  else {
                   System.err.println("SctGUI::SCTDBTestDownloader - Null dcs data for parameter "+j);
                   sctdbData.dcsinfo[j]=NODATA;
                   }
                  }
                }
            }
            else for(int j=0;j<8;j++) sctdbData.dcsinfo[j]=NODATA;
        
           
            String objectName = isSCTDAQData ? "SCTDBData."+testNames[testIndex]+"."+location+"."+sn : "SCTDBData."+location+".Summary."+run+"."+scan+"."+sn;
            
            if(SctNames.getISRepository().contains(objectName)) {
                if(!refresh) continue;
                SctNames.getISRepository().remove(objectName);
                }
            SctNames.getISRepository().insert(objectName, sctdbData);  
            System.out.println("SctGUI::SCTDBTestDownloader - SCTDB Object published as "+objectName);        
            }


        if(isSCTDAQData) {
          int notDownloaded = listOfModules.size()-snHash.size();
          if(notDownloaded>0) {
           for(int i=0;i<listOfModules.size();i++) {
              String module = (String)listOfModules.elementAt(i);
              if(!snHash.containsKey(module)) System.out.println("SctGUI::SCTDBTestDownloader - No "+testNames[testIndex]+" data available for "+(String)listOfModules.elementAt(i));
              }
           }
         }

        }catch(Exception e) {System.out.println("SctGUI::SCTDBTestDownloader - Failed to publish SCTDB Data: "+e.toString());}


   }

   private boolean publishControlObject(String run, String scan) {
         List mList = new ArrayList();
         StringBuffer sqlStat = new StringBuffer();
         String testno=null;
         String version = null;

         try {

         String controlObjectName = "SCTDBData.ControlData.TestData."+run+"."+scan;
         if(SctNames.getISRepository().contains(controlObjectName)) return true; // already there

         sqlStat = new StringBuffer("SELECT tests.test_no,tests.ser_no,SCT_TSTDAQINFO.version FROM tests,SCT_TSTDAQINFO WHERE tests.run_no = '"+runString+"' AND SCT_TSTDAQINFO.version LIKE 'SctRodDaq%'");
         sqlStat.append(" AND tests.test_no = SCT_TSTDAQINFO.test_no AND tests.locn_name LIKE '"+location+"'");
         sqlStat.append(" AND tests.TEST_name = '"+sctdaqDBTestNames[testIndex]+"'");
         Statement statement = SCTDBInterface.getInstance().connection.createStatement();
//         System.out.println(sqlStat.toString());
         ResultSet resultSet = statement.executeQuery(sqlStat.toString());
         for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
              testno = resultSet.getString(1);
              mList.add(resultSet.getString(2));
              version = resultSet.getString(3);
              }
         statement.close();

         if(mList.size()==0) {
              System.err.println("SctGUI::SCTDBTestDownloader - no modules found for run-scan "+runString);
              return false;
              }

         int noPoints=-1;
         String[] pointValues = new String[16];
         if(testno!=null) {
             sqlStat = new StringBuffer("SELECT POINT_TYPE,N_POINTS");
             for(int i=0;i<16;i++) sqlStat.append(",POINT_"+i);
             sqlStat.append(" FROM SCT_TSTSCANINFO WHERE TEST_NO="+testno); 
             statement = SCTDBInterface.getInstance().connection.createStatement();
//           System.out.println(sqlStat.toString());
             resultSet = statement.executeQuery(sqlStat.toString());
 
             for(boolean n = resultSet.next() ; n==true ; n=resultSet.next() ){
               String point_type = resultSet.getString(1);
               String nPoints = resultSet.getString(2);
               noPoints = Integer.parseInt(nPoints);
               for(int i=0;i<16;i++) pointValues[i]=resultSet.getString(i+3);
               }
              statement.close();
              }
            TestData testData = new TestData();
            testData.testName = testNames[testIndex];
            testData.runNumber = Integer.parseInt(run);
            testData.nScans = (noPoints!=-1) ? noPoints : 1;
            testData.startScanNumber = Integer.parseInt(scan);
            testData.testVariable = 0;
            if(noPoints!=-1) {
              testData.testPoints = new double[noPoints];
              for(int i=0;i<noPoints;i++) testData.testPoints[i] = Double.parseDouble(pointValues[i]);
              }
            else {
              testData.testPoints = new double[1];
              testData.testPoints[0]=0.;
              }
            testData.status=TestData.COMPLETED;
            testData.startTime = "";
            testData.endTime = "";
            testData.modules = new String[mList.size()];
            for(int i=0;i<mList.size();i++) testData.modules[i] = new String((String)mList.get(i));
            testData.version = 0;
// publish the control object!
            SctNames.getISRepository().insert(controlObjectName, testData);  
            System.out.println("SctGUI::SCTDBTestDownloader - Published control object "+controlObjectName);
            }catch(Exception e) {
              System.err.println("SctGUI::SCTDBTestDownloader - Exception creating control object - "+e.toString());
              return false;
              }
            return true;
            }



   private void convertData(SCTDB_Data sctdbData, int index) {
               sctdbData.data_m0[index]=128.-sctdbData.data_m0[index];
               sctdbData.data_s1[index]=128.-sctdbData.data_s1[index];
               sctdbData.data_s2[index]=128.-sctdbData.data_s2[index];
               sctdbData.data_s3[index]=128.-sctdbData.data_s3[index];
               sctdbData.data_s4[index]=128.-sctdbData.data_s4[index];
               sctdbData.data_e5[index]=128.-sctdbData.data_e5[index];
               sctdbData.data_m8[index]=128.-sctdbData.data_m8[index];
               sctdbData.data_s9[index]=128.-sctdbData.data_s9[index];
               sctdbData.data_s10[index]=128.-sctdbData.data_s10[index];
               sctdbData.data_s11[index]=128.-sctdbData.data_s11[index];
               sctdbData.data_s12[index]=128.-sctdbData.data_s12[index];
               sctdbData.data_e13[index]=128.-sctdbData.data_e13[index];
               }
   private double getData(String dataString) {
        double data = -1.;
           try {
               data = Double.parseDouble(dataString);
           }catch(Exception e) {
               dataString = dataString.toLowerCase();
               if(dataString.equals("not tested")) data=0.;
               else if(dataString.equals("minimal tested")) data=1.;
               else System.err.println("Unrecognised data from SCT database: "+dataString);
               }
         return data;
         }
       


}
