package DisplayGUI;
import java.util.*;
import Preferences.*;

/**
 *
 * @author  robinson
 */

public class IVTestInterface implements SummaryReader.regExpressions {
   Vector ivtests;
   ConfigurationInterface conf;
   SortedMap ivMap;  // sorted map of run*1e6+scan to IVInfo
   List table;
   IVInfo selectedIV;  // summary of IVscan info for a given run and scan number, for selected IV scan
   int sctView;
   java.util.regex.Pattern rPattern = java.util.regex.Pattern.compile("^Run Number\\s*:\\s*(\\d+)-(\\d+)");
   java.util.regex.Pattern dPattern = java.util.regex.Pattern.compile("^TEST_DATE\\s*:\\s*(\\d{2})/(\\d{2})/(\\d{4})");
   java.util.regex.Pattern fPattern = java.util.regex.Pattern.compile("CRATE\\d{2}CHAN\\d{2}_(\\d4)(\\d{2})(\\d{2})\\.txt");

   public IVTestInterface(int sctView) {
     conf = ConfigurationInterface.getInstance();
     ivMap = new TreeMap();
     this.sctView=sctView;
     }
   public void clear() {
     conf = ConfigurationInterface.getInstance();
     ivMap = new TreeMap();
     selectedIV=null;
     }
   public int getNoTests() {
     return ivMap.size();
     }
   public void refresh() {

     String ivdirectory = PreferencesInterface.getInstance().getPreference(PreferencesInterface.IV_DIRECTORY);
     if(ivdirectory.equals(PreferencesInterface.unDefinedString)) {
          javax.swing.JOptionPane.showMessageDialog(null,"You have not defined the IV data directory. Please do this first in the Options->DCS menu.");
          return;
          }
     java.io.File ivDir = new java.io.File(ivdirectory);
     if(!ivDir.exists()) {
        javax.swing.JOptionPane.showMessageDialog(null,"Your IV Data directory does not exist! Please correct it in the Options->DCS menu.");
        return;
        }

     Set moduleList = conf.getSortedVector(sctView);

     for (Iterator j = moduleList.iterator(); j.hasNext(); ) {
         String thisSN=(String)j.next();
         String ivHeader = conf.getSNInfo(thisSN,SNInfo.IV_FILE_HEADER);
         java.io.File[] ivfiles = ivDir.listFiles(new ivFileFilter(ivHeader));
         for(int i=0;i<ivfiles.length;i++) getFileInfo(thisSN,ivfiles[i]);
         }
    }
    public List getTableList() {
      table =  new ArrayList();
      for (Iterator i=ivMap.values().iterator(); i.hasNext(); ) {
         IVInfo ivInfo = (IVInfo)i.next();
         table.add(ivInfo);
         }
       return table;
       }
     public IVInfo getIVInfo(int index) {
       return (IVInfo)ivMap.values().toArray()[index];
       }
     public void getFileInfo(String serialNo,java.io.File filename) {

        java.util.regex.Matcher matcher;
        IVInfo ivInfo = null;
        boolean nextLineIsTime=false;
        List scanList = new ArrayList();
        boolean skipTest=false;
        try {
          java.io.BufferedReader in = new java.io.BufferedReader(new java.io.FileReader(filename));
          String line;
          while((line=in.readLine())!=null) {

             if(line.matches("^%NewTest")) {
                if(ivInfo!=null && ivInfo.isValid()) updateIVMap(serialNo,ivInfo);
                ivInfo = new IVInfo();
                skipTest=false;
                }

             if(skipTest) continue;

             if(line.startsWith("SERIAL NUMBER")) ivInfo.addModule(serialNo);

             matcher = rPattern.matcher(line);
             if(matcher.matches()) {
                   String scan = line.substring(matcher.start(2),matcher.end(2));
                   String run = line.substring(matcher.start(1),matcher.end(1));
                   Integer key = IVInfo.getIVKey(run,scan);
                   if(scanList.contains(key)) {
                     System.err.println("SctGUI::IVTestInterface - Duplicate run/scan number found in "+filename.getName());
                     ivInfo.inValidate();
                     skipTest=true;
                     continue;
                     }
                   scanList.add(key);
                   ivInfo.setRun(run);
                   ivInfo.setScan(scan);
           //        if(gotIVInfo(run,scan)) {
           //           skipTest=true;
           //           continue;
           //           }
                   }
             matcher = dPattern.matcher(line);
             if(matcher.matches()) ivInfo.setDate(line.substring(matcher.start(1),matcher.end(1)),line.substring(matcher.start(2),matcher.end(2)),line.substring(matcher.start(3),matcher.end(3)));

// get voltage data for this run and scan no
             matcher = filenamePattern.matcher(line);
             if(matcher.matches()) {
                SummaryReader.IVTest ivTest = new SummaryReader.IVTest();
                java.io.File originalRawdataFile = new java.io.File(line.substring(matcher.start(1),matcher.end(1)));
                java.io.File rawDataFile = new java.io.File(filename.getParent(),originalRawdataFile.getName());
                ivTest.addIVData(rawDataFile);
                ivInfo.setVData(ivTest.getVList());
                 }


             if(nextLineIsTime) ivInfo.setTime(line.replaceAll("\"",""));

             nextLineIsTime = line.matches("^#TIME$");
             }
          in.close();
          if(ivInfo!=null && ivInfo.isValid()) updateIVMap(serialNo,ivInfo);

         }catch(Exception e){System.err.println("SctGUI::IVTestInterface - Exception reading "+filename.getName()+" : "+e.toString());}

         }
   private void updateIVMap(String serialNo,IVInfo ivInfo) {
            Integer key = ivInfo.getIVKey();
            IVInfo oldIVInfo = (IVInfo)ivMap.get(key);
            if(oldIVInfo==null) ivMap.put(key,ivInfo);
            else oldIVInfo.addModule(serialNo);
            }
   public boolean gotIVInfo(String run, String scan) {
            Integer key = IVInfo.getIVKey(run,scan);
            return ivMap.containsKey(key);
            }

   public String getIVFileStem() {
       if(selectedIV==null) return null;
       return selectedIV.getFileStem();
       }     

   public String getDataString(Integer run,Integer scan, String module, String filestem) {
         java.util.regex.Matcher matcher;
         String ivHeader = conf.getSNInfo(module,SNInfo.IV_FILE_HEADER);
         StringBuffer dataString = new StringBuffer();
         String ivdirectory = PreferencesInterface.getInstance().getPreference(PreferencesInterface.IV_DIRECTORY);
         java.io.File dataFile;
         boolean skipTest=false;
         try {
         dataFile = new java.io.File(ivdirectory,ivHeader+filestem);
         java.io.BufferedReader in = new java.io.BufferedReader(new java.io.FileReader(dataFile));
         String line;

         while((line=in.readLine())!=null) {

             if(line.matches("^%NewTest")) {
                dataString = new StringBuffer();
                dataString.append(line+"\n");
                skipTest=false;
                continue;
                }

             if(skipTest) continue;

             matcher = rPattern.matcher(line);
             if(matcher.matches()) {
                   String thisScan = line.substring(matcher.start(2),matcher.end(2));
                   String thisRun = line.substring(matcher.start(1),matcher.end(1));
                   if(!thisScan.equals(scan.toString()) || !thisRun.equals(run.toString())) {
                     skipTest=true;
                     continue;
                     }
                   }
// get voltage data for this run and scan no
             matcher = filenamePattern.matcher(line);
             if(matcher.matches()) {
                SummaryReader.IVTest ivTest = new SummaryReader.IVTest();
                java.io.File originalRawdataFile = new java.io.File(line.substring(matcher.start(1),matcher.end(1)));
                java.io.File rawDataFile = new java.io.File(ivdirectory,originalRawdataFile.getName());
                ivTest.addIVData(rawDataFile);
                List iList = ivTest.getIList();
                List vList = ivTest.getVList();
                for(int i=0;i<vList.size();i++) dataString.append("IVDATA:"+((Double)vList.get(i)).toString()+":"+((Double)iList.get(i)).toString()+"\n");
                dataString.append("###END");
                break;
                }
              else dataString.append(line+"\n");
              }
            in.close();
            }catch(Exception e){System.err.println("SctGUI::IVTestInterface - "+e.toString()); return null;}
            if(skipTest) {
               System.err.println("SctGUI::IVTestInterface - no raw data for IVScan file "+dataFile.getName());
               return null;
               }
            return (dataString.length()==0) ? null : dataString.toString();
            }

          
            
       


   
       
}

      
       
                
           

   

   