package DisplayGUI;

import java.util.regex.*;
import java.util.*;
import is.*;
import Sct.Serializable;
import Sct.IS.*;
import Sct_CalibrationController.TestData;

/*
 * ISCounter.java
 *
 */

/**
 *
 * @author  robinson
 */
public class ISCounter {
        final java.util.regex.Pattern objectPattern = java.util.regex.Pattern.compile(".*TestData\\.[0-9]+\\.[0-9]+");
        List masterList = new ArrayList();
        String[] serverNames = {SctNames.getEventISServer(),SctNames.getFitISServer(),SctNames.getTestISServer(),
                                "RetrievedData","RetrievedData","RetrievedData"};
        String[] serverRegexs = {
         SctNames.getEventISServer()+".*SctData",
         SctNames.getFitISServer()+".*SctData",
         SctNames.getTestISServer()+".*SctData",
         "RetrievedData.*SctData::RawScanResult",
         "RetrievedData.*SctData::FitScanResult",
         "RetrievedData.*SctData.*TestResult" 
         };

         
        HashMap m;
        Pattern oPattern = Pattern.compile("(.*)\\.SctData::.*\\.(\\d+\\.\\d+)\\.(\\d{14})");

        private boolean requestUpdate=false;

        public ISCounter() {
           m = new HashMap();
           masterList = new ArrayList();
           }
        public void refresh(String regex) {
           m = new HashMap();
           masterList = new ArrayList();
           readIS(regex);
           }          

        public synchronized void readIS(String regex) {

// regex is ".*(runNo.ScanNo1|runNo.ScanNo2|runNo.ScanNo3)"
           GuiComponents.System.ISInterface is = GuiComponents.System.ISInterface.getInstance();


           String[] objects;

// first get the list of control objects

           for(int j=0;j<serverRegexs.length;j++) {
             m.put(serverRegexs[j]+regex+"(\\d{14})", new HashMap());
             }



// now go through the data
           for(int j=0;j<serverNames.length;j++) {
             switch(j) { 
                case 3:
                  objects = is.getISObjects(serverNames[j],".*RawScanResult.*"+regex+".*");
                  break;
                case 4:
                  objects = is.getISObjects(serverNames[j],".*FitScanResult.*"+regex+".*");
                  break;
                case 5:
                  objects = is.getISObjects(serverNames[j],".*TestResult.*"+regex+".*");
                  break;
                default:
                  objects = is.getISObjects(serverNames[j],regex+".*");
                }
             for(int o=0;o<objects.length;o++) {
               Matcher matcher2 = oPattern.matcher(objects[o]);
               if(!matcher2.matches()) continue;   // a non-data object
               masterList.add(objects[o]);  
               String regexKey=null;   
               String sn=null;
               ILOOP:   
               for (Iterator i=m.entrySet().iterator(); i.hasNext(); ) {
                 Map.Entry e = (Map.Entry)i.next();
                 String thisRegex = (String)e.getKey();
                 Pattern rPattern = Pattern.compile(thisRegex);
                 Matcher matcher = rPattern.matcher(objects[o]);
                 if(matcher.matches()) {
                    sn=objects[o].substring(matcher.start(2),matcher.end(2));
                    regexKey = thisRegex;
                    break ILOOP;
                    }
                 }
                if(regexKey==null || sn==null) {
                   System.out.println("SctGUI::ISCounter: No key/sn found for "+objects[o]+" !!!");
                   continue;
                   }
                Map sm = (HashMap)m.get(regexKey);
                List snList = (List)sm.get(sn);
                if(snList==null) snList = new ArrayList();
                snList.add(objects[o]);
//                System.out.println("Added "+objects[o]+" to snList, whcih now has size "+snList.size());
                sm.put(sn,snList);
                masterList.add(objects[o]);
                }
              }


         }

    public synchronized Map getModuleMap(int serverIndex,String regex, boolean isRetrievedData) {
        if(regex==null) return null;
        if(isRetrievedData) serverIndex+=3;
        String mRegex = serverRegexs[serverIndex]+regex+"(\\d{14})";
        return (Map)m.get(mRegex);

        }
    public synchronized List getModuleList(int serverIndex, String regex, String sn, boolean isRetrievedData) {
        if(regex==null) return null;
        if(isRetrievedData) serverIndex+=3;
        String mRegex = serverRegexs[serverIndex]+regex+"(\\d{14})";

        Map sm = (HashMap)m.get(mRegex);
        if(sm==null) return null;
        return (List)sm.get(sn);
        }

    public synchronized void addObject(String objectName) {

        Matcher matcher2 = oPattern.matcher(objectName);
        if(!matcher2.matches()) return;   // a non-data object
        if(masterList.contains(objectName)) return;
        String regexKey=null,sn=null;
        for (Iterator i=m.entrySet().iterator(); i.hasNext(); ) {
                 Map.Entry e = (Map.Entry)i.next();
                 String regex = (String)e.getKey();
                 Pattern rPattern = Pattern.compile(regex);
                 Matcher matcher = rPattern.matcher(objectName);
                 if(matcher.matches()) {
                    sn=objectName.substring(matcher.start(2),matcher.end(2));
                    regexKey = regex;
                    break;
                    }
                 }
        if(regexKey==null || sn==null) {
//                   System.out.println("SctGUI::ISCounter: No key/sn found for "+objectName+" !!!");
                   return;
                   }
        Map sm = (Map)m.get(regexKey);
        List snList = (List)sm.get(sn);
        if(snList==null) snList = new ArrayList();
        snList.add(objectName);
        sm.put(sn,snList);
        masterList.add(objectName);
        }

    public synchronized boolean archivedObjectsRetrievedOk(int serverIndex, String regex) {

        GuiComponents.System.ISInterface is = GuiComponents.System.ISInterface.getInstance();

        if(!m.containsKey(serverRegexs[serverIndex+3]+regex+"(\\d{14})")) {
           System.out.println("SctGUI::IsCounter - ERROR No key for "+serverRegexs[serverIndex+3]+regex+"(\\d{14})");
           return false;
           }
        Map sm = (HashMap)m.get(serverRegexs[serverIndex+3]+regex+"(\\d{14})");
        return (sm.size()>0);
        }


}
                  
          

                   


 