package DisplayGUI;
import java.awt.event.*;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JMenu;
import javax.swing.KeyStroke;
import javax.swing.JFrame;
import javax.swing.JCheckBox;
import javax.swing.JPopupMenu;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import Preferences.*;
//
import Sct.Version;
import Sct_CalibrationController.TestRequest;
import Sct_CalibrationController.SequenceRequest;
import Sct_CalibrationController.CalibrationControllerPackage.*;

import GuiComponents.System.*;
import GuiComponents.scripting.*;
import GuiComponents.Console.JConsole;

public class GuiMenuBar2 extends JMenuBar implements displayParams,ActionListener,TestDataInfo {
    gui guiControl;
    ManualConfiguration manualConfiguration;
    private SystemInterface si;
    String option;
    private String[] configOptionNames={"Read Hardware Configuration","Manual Configuration..."};
//    private String[] displayOptionNames={"ModuleGroup Selection","Data Manager","Test Results","SCTDAQ Reference","SctRodDaq Reference","DCS Info"};
    private String serialNumber;

    protected ISTree isTree;
    private JMenu menu, systemMenu, displayMenu, ccMenu, testMenu, panelTestMenu, panelDisplayMenu;
    private JMenu testResultMenu, sctdbDataMenu, configMenu, dcsOptionMenu, ivScanOptionMenu;
    public JMenu testDataMenu,sctdbDataSNMenu, dataManagerSNMenu, ivScanMenu;
    private JMenu testDataOptionMenu, panelTestDataOptionMenu, sctdbSCTDAQOptionMenu,sctdbRODDAQOptionMenu,tableDataOptionMenu, ccDataOptionMenu, displayOptionMenu, panelsctdbSCTDAQOptionMenu,panelsctdbRODDAQOptionMenu;
    private JMenuItem menuItem;
    private JMenuItem[] configOptions = new JMenuItem[configOptionNames.length];
//    private JMenuItem[] displayOptions = new JMenuItem[DisplayStatus.statusNames.length-1];
//     private JMenuItem ccPingItem, ccNMaskItem, ccStrobeDelayItem, ccThreePointGainItem, ccTrimItem, ccResponseCurveItem, ccNoiseItem, ccFullBypassItem, ccPipelineItem, ccTimeWalkItem;
 //    private JMenuItem ccCharacterisationItem;

    private JMenuItem sctapiPing, sctapiInitialise;
    private JMenuItem[] sctapiItems = new JMenuItem[testMenuNames.length];

    private JCheckBox sctdbAutoDownload = new JCheckBox("Enable SCTDAQ Auto-Download");
    private JCheckBox sctdbAutoUpload = new JCheckBox("Enable SctRodDaq Auto-Upload");
//    private JCheckBox dcsEnabled = new JCheckBox("Enable DCS Monitoring");
    private String[] ccUpdateStrings = {"Update","No-Update","Wait"};
    private JCheckBox[] ccUpdateModes = new JCheckBox[ccUpdateStrings.length];
    public JCheckBox autoSelectMode = new JCheckBox("AutoSelect New Tests");
    
    private JMenuItem scriptBeanShellItem, scriptJythonItem;
    private JMenuItem isTreeItem;
    private JCheckBox[] testFilterButtons = new JCheckBox[testMenuNames.length+1];
    private JMenu testFilterMenu;

    private JMenuItem[] testDataOptions = new JMenuItem[3];

    private JMenuItem[] preferenceItem = new JMenuItem[PreferencesInterface.getInstance().getNoPreferences()];

    private JMenuItem testReportItem;

    private JFrame hardwareWindow = null;

    int itemIndex;

    private DisplayChoiceToolbar displayChoiceToolbar;

    public GuiMenuBar2(gui parent) {
	guiControl=parent;
	createMenuBar();
    }
    public String getSelectedSerialNo() {
	return serialNumber;
    }
    public void setSelectedSerialNo(String sn) {
	serialNumber=sn;
    }

    public boolean autoUploadIsEnabled() {
      return sctdbAutoUpload.isSelected();
      }

    public void createMenuBar() {


	si = SystemInterface.getInstance();


       getTestDataMenu();
       getIVScanMenu();
       getSCTDBDataMenu();
       getTableDataSNMenu();

      
       systemMenu = new JMenu("System");
       systemMenu.setBackground(backgroundColor);
       systemMenu.setFont(menuFont);
       systemMenu.setForeground(menuColor);

       menuItem = new JMenuItem("Refresh");
       menuItem.setFont(menuFont);
       menuItem.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                    si.refresh();  
                    guiControl.displayPane.refreshDisplay();                 
                     }
             });
       systemMenu.add(menuItem);

       menuItem = new JMenuItem("Hardware Configuration...");
       menuItem.setFont(menuFont);
       menuItem.addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
            if(hardwareWindow==null) {
                hardwareWindow = new JFrame("Hardware Configuration");                  
                hardwareWindow.getContentPane().add(new HardwareConfigurationPanel());
                hardwareWindow.pack();
                java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
                java.awt.Dimension WSize = hardwareWindow.getSize();
                hardwareWindow.setLocation((screenSize.width-(int)WSize.getWidth())/2,(screenSize.height-(int)WSize.getHeight())/2);
                hardwareWindow.addWindowListener(new WindowAdapter() {
                            public void windowClosing(WindowEvent e) {
                                  hardwareWindow=null;
//                                e.getWindow().dispose();
                            }
                        });
                }
            hardwareWindow.show();
              }
          });  
       systemMenu.add(menuItem);


       ccDataOptionMenu = getCCDataOptionMenu();
       systemMenu.add(ccDataOptionMenu);
       systemMenu.addSeparator();
       menuItem = new JMenuItem("Exit SctGUI");
       menuItem.setFont(menuFont);
       menuItem.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                    guiControl.exitForm(null);                   
                     }
             });
       systemMenu.add(menuItem);
       add(systemMenu);      

// Display menu

       displayMenu = getDisplayMenu();
       displayMenu.addSeparator();
       menuItem = new JMenuItem("Toolbar ...");
       menuItem.setFont(menuFont);
       menuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                     if(displayChoiceToolbar!=null) displayChoiceToolbar.setVisible(true);
                     else {
                         displayChoiceToolbar = new DisplayChoiceToolbar(guiControl);      
                         java.awt.Dimension s = displayChoiceToolbar.getSize();
                         displayChoiceToolbar.setSize((int)s.getWidth()+1,(int)s.getHeight()+1);
                         }                            
                     }
             });
       displayMenu.add(menuItem);
       add(displayMenu);

// display menu for right mouse clicks on main display panel
       panelDisplayMenu = getDisplayMenu();
       panelDisplayMenu.setText("Select Display");

// All tests
       testMenu = getTestInvokeMenu();
       testMenu.setBackground(backgroundColor);
       testMenu.setFont(menuFont);
       testMenu.setForeground(menuColor);
       add(testMenu);

       panelTestMenu = getTestInvokeMenu();
       panelTestMenu.setText("Invoke Tests");
       panelTestMenu.setFont(menuFont);

// Options menu
       ivScanOptionMenu = getIVScanOptionMenu();
       dcsOptionMenu = getDCSOptionMenu();
       displayOptionMenu = getDisplayOptionMenu();
       testDataOptionMenu = getTestDataOptionMenu();
       tableDataOptionMenu = getTableDataOptionMenu();
       sctdbSCTDAQOptionMenu = getDBSCTDAQDataOptionMenu(false);
       sctdbRODDAQOptionMenu = getDBRODDAQDataOptionMenu(false);
       menu = new JMenu("Options");
       menu.setBackground(backgroundColor);
       menu.setFont(menuFont);
       menu.setForeground(menuColor);

       configMenu = new JMenu("Configuration");
       configMenu.setFont(menuFont);
       for(int i=0;i<configOptionNames.length;i++) {
          configOptions[i] = new JMenuItem(configOptionNames[i]);
          configOptions[i].setFont(menuFont);
          configMenu.add(configOptions[i]);
          switch(i) {
            case 0:
             configOptions[i].addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                    ConfigurationInterface.getInstance().Refresh();
                    guiControl.displayStatus.setConfigurationMode();                   
                     }
             });
             break;
            case 1:
             configOptions[i].addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                   guiControl.displayStatus.setModuleGroupSelectionMode();
                   if(manualConfiguration==null) manualConfiguration = new ManualConfiguration(guiControl);
                   else manualConfiguration.showFrame();                  
                     }
             });
            default:
            }
          }
       menu.add(configMenu);
       menu.add(displayOptionMenu);       
       menu.add(tableDataOptionMenu);
       menu.add(testDataOptionMenu);
     
       JMenu sctdbMenu = new JMenu("SCT Database");
       sctdbMenu.setFont(menuFont);
       sctdbMenu.add(sctdbSCTDAQOptionMenu);
       sctdbMenu.add(sctdbRODDAQOptionMenu);
       menu.add(sctdbMenu);
       menu.add(dcsOptionMenu);

       add(menu);

       panelTestDataOptionMenu = getTestDataOptionMenu();
       panelsctdbSCTDAQOptionMenu = getDBSCTDAQDataOptionMenu(true);
       panelsctdbRODDAQOptionMenu = getDBRODDAQDataOptionMenu(true);


// Tools menu
       menu = new JMenu("Tools");
       menu.setBackground(backgroundColor);
       menu.setFont(menuFont);
       menu.setForeground(menuColor);
       isTreeItem = new JMenuItem("IS Tree...");
       isTreeItem.setFont(menuFont);
       isTreeItem.addActionListener(this);
       menu.add(isTreeItem);

       JMenu menu2 = new JMenu("Scripting");
       menu2.setFont(menuFont);
       /*scriptJavaScriptItem = new JMenuItem("JavaScript");
       scriptJavaScriptItem.setFont(menuFont);
       scriptJavaScriptItem.addActionListener(this);
       menu2.add(scriptJavaScriptItem);*/
       scriptBeanShellItem = new JMenuItem("BeanShell");
       scriptBeanShellItem.setFont(menuFont);
       scriptBeanShellItem.addActionListener(this);
       menu2.add(scriptBeanShellItem);
       scriptJythonItem = new JMenuItem("Jython");
       scriptJythonItem.setFont(menuFont);
       scriptJythonItem.addActionListener(this);
       menu2.add(scriptJythonItem);
       menu.add(menu2);

       JMenuItem item = new JMenuItem("Run GarbageCollector");
       item.setFont(menuFont);
       item.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
               Runtime r = Runtime.getRuntime();
               long freeMem = r.freeMemory();        
               long maxMem = r.maxMemory();
               long totalMem = r.totalMemory();
               System.out.println("Total Mem: " + totalMem/1024. + ", Max Mem:" + maxMem/1024. + " , Free Mem: " + freeMem/1024.);
               r.gc();
               try {
                 Thread.sleep(500);
               } catch (InterruptedException ie) {}
               r.gc();
               freeMem = r.freeMemory();
               maxMem = r.maxMemory();
               totalMem = r.totalMemory();
               System.out.println("Total Mem: " + totalMem/1024. + ", Max Mem:" + maxMem/1024. + " , Free Mem: " + freeMem/1024.  );
                   }
              });
       menu.add(item);
       item = new JMenuItem("Refresh Display");
       item.setFont(menuFont);
       item.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
               guiControl.displayPane.setDisplayColors();
               guiControl.displayPane.refreshDisplay();
                   }
              });
       menu.add(item);

       item = new JMenuItem("Launch SctApi GUI");
       item.setFont(menuFont);
       item.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                JFrame frame = new JFrame("SctApi GUI");
                frame.getContentPane().add(new GuiComponents.Panels.SctApiGui());

                frame.pack();
                frame.setVisible(true);
            }
           }); 
       menu.add(item);

       add(menu);

// Help menu
       menu = new JMenu("Help");
       menu.setBackground(backgroundColor);
       menu.setFont(menuFont);
       menu.setForeground(menuColor);
       
       JMenuItem helpItem = new JMenuItem("View User Manual");
       helpItem.setFont(menuFont);
       menu.add(helpItem);
       helpItem.addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
                   guiControl.htmlViewer.show("http://www.hep.phy.cam.ac.uk/~robinson/DisplayGUI.html","Online manual");
                   }
              });
              
       JMenuItem aboutItem = new JMenuItem("About");
       aboutItem.setFont(menuFont);
       menu.add(aboutItem);
       aboutItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                String v = Version.instance.getAllInformation();
                String s = "SctGui is the user interface for end users.  See the manual for more information";                    
                s += "\nSctGui Author: Dave Robinson.";
                s += "\nSctDaqRod Authors: Alan Barr, Bruce Gallop, Matthew Palmer, Dave Robinson and Alexander Tricoli";
                s += "\n\n" + v;
                JOptionPane.showMessageDialog(guiControl, s, "About SctGui", JOptionPane.INFORMATION_MESSAGE);
            }
           });
      add(menu);

       add(javax.swing.Box.createHorizontalGlue());

// Preferences menu
       PreferencesInterface prefs = PreferencesInterface.getInstance();
       menu = new JMenu("Preferences");
       menu.setBackground(backgroundColor);
       menu.setFont(menuFont);
       menu.setForeground(menuColor);

       for(int i=0;i<prefs.getNoPreferences();i++) {
         switch(i) {
         case PreferencesInterface.SCT_VIEW:
         preferenceItem[i] = new JMenuItem(prefs.getDescription(i));
         preferenceItem[i].setFont(menuFont);
         menu.add(preferenceItem[i]);
             preferenceItem[i].addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
                   Preference preference = new Preference(guiControl,PreferencesInterface.SCT_VIEW);   
                   guiControl.selectorPane.setSCTView(preference.getValue());                
                   }
              });
              break;
         case PreferencesInterface.INSTITUTE:
         preferenceItem[i] = new JMenuItem(prefs.getDescription(i));
         preferenceItem[i].setFont(menuFont);
         menu.add(preferenceItem[i]);
             preferenceItem[i].addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
                   Preference preference = new Preference(guiControl,PreferencesInterface.INSTITUTE);                   
                   }
              });
              break;
         case PreferencesInterface.PASSWORD:
         preferenceItem[i] = new JMenuItem(prefs.getDescription(i));
         preferenceItem[i].setFont(menuFont);
         menu.add(preferenceItem[i]);
             preferenceItem[i].addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
                   Preference preference = new Preference(guiControl,PreferencesInterface.PASSWORD);                   
                   }
              });
              break;
         case PreferencesInterface.PSVIEWER:
         preferenceItem[i] = new JMenuItem(prefs.getDescription(i));
         preferenceItem[i].setFont(menuFont);
         menu.add(preferenceItem[i]);
             preferenceItem[i].addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
                   Preference preference = new Preference(guiControl,PreferencesInterface.PSVIEWER);                   
                   }
              });
              break;
         case PreferencesInterface.SCRATCH_DIR:
         preferenceItem[i] = new JMenuItem(prefs.getDescription(i));
         preferenceItem[i].setFont(menuFont);
         menu.add(preferenceItem[i]);
             preferenceItem[i].addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
                   Preference preference = new Preference(guiControl,PreferencesInterface.SCRATCH_DIR);                   
                   }
              });
              break;
         case PreferencesInterface.UPLOAD_DIR:
         preferenceItem[i] = new JMenuItem(prefs.getDescription(i));
         preferenceItem[i].setFont(menuFont);
         menu.add(preferenceItem[i]);
             preferenceItem[i].addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
                   Preference preference = new Preference(guiControl,PreferencesInterface.UPLOAD_DIR);                   
                   }
              });
              break;
         case PreferencesInterface.WEB_LOOKUP_DIR:
         preferenceItem[i] = new JMenuItem(prefs.getDescription(i));
         preferenceItem[i].setFont(menuFont);
         menu.add(preferenceItem[i]);
             preferenceItem[i].addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
                   Preference preference = new Preference(guiControl,PreferencesInterface.WEB_LOOKUP_DIR);                   
                   }
              });
              break;
         default:
         }

         }
       add(menu);

       testFilterMenu = getTestFilterMenu();
  
       setBorder(javax.swing.BorderFactory.createEmptyBorder());
       setBackground(backgroundColor);
   }

//****************************************************
    private void updateToolBar(int i) {
	if(displayChoiceToolbar!=null) displayChoiceToolbar.setButton(i);
    }

//**********************************************************
    public void actionPerformed(ActionEvent e) {
	JMenuItem source = (JMenuItem)(e.getSource());


// Scripting
	if(source==scriptBeanShellItem) {
	    addNewConsole(ScriptingInterface.instance().getBeanShellInterpreter(), "BeanShell");
	    return;
	}        
        /*if(source==scriptJavaScriptItem) {
            addNewConsole(ScriptingInterface.instance().getJavaScriptInterpreter(), "JavaScript");
            return;
            }*/
        if(source==scriptJythonItem) {
            addNewConsole(ScriptingInterface.instance().getJythonInterpreter(), "Jython");
            return;
            }
// Tools
        if(source==isTreeItem) {
            if(isTree==null) isTree = new ISTree(guiControl,guiControl.isInterface.getISTree());
            else isTree.setTree(guiControl.isInterface.getISTree());
            return;
            }


        }
//********************************************************
    public void enableCCMenuItems(boolean enabled) {
	java.awt.Component[] component = testMenu.getMenuComponents();
	for(int i=0;i<component.length;i++) {
	    if(component[i].getClass().getName().startsWith("javax.swing.JPopupMenu")) break;
	    if(!component[i].getClass().getName().startsWith("javax.swing.JMenu")) continue;             
	    JMenu subMenu = (JMenu)component[i];
	    for(int y=0;y<subMenu.getItemCount();y++) {
		JMenuItem item = subMenu.getItem(y);
		if(item!=null) item.setEnabled(enabled);
	    }
	}	
	component = panelTestMenu.getMenuComponents();
	for(int i=0;i<component.length;i++) {
	    if(component[i].getClass().getName().startsWith("javax.swing.JPopupMenu")) break;
	    if(!component[i].getClass().getName().startsWith("javax.swing.JMenu")) continue;             
	    JMenu subMenu = (JMenu)component[i];
	    for(int y=0;y<subMenu.getItemCount();y++) {
		JMenuItem item = subMenu.getItem(y);
		if(item!=null) item.setEnabled(enabled);
	    }
	}
    }
    

    public void enableDisplayMenuItems(boolean enabled) {
	displayMenu.setEnabled(enabled);
    }
           
    
    protected boolean addNewConsole(Interpreter interpreter, String suffix) {    
	if (interpreter == null) {
	    System.out.println("Can only have 1 scripting window open at once\n");
            return false;
        }
        JFrame frame = new JFrame();
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(interpreter.getConsole());
        frame.getContentPane().add(scroll);  
        frame.setTitle("Scripting Window:" + suffix);
        frame.show();
        frame.setSize(800, 500);        
        return true;
    }
       
   public void showCCPopupMenu(MouseEvent e) {
        JPopupMenu pMenu = ccDataOptionMenu.getPopupMenu();
        pMenu.show(e.getComponent(),e.getX(),e.getY());
        pMenu.setInvoker(ccDataOptionMenu);
        }
//**********************************************
// popup menus for tables
   public void showTablesPopupMenu(int clickedTable, MouseEvent e) {
        JPopupMenu pMenu;
        switch(clickedTable) {
        case 1:
          switch(guiControl.displayStatus.getStatus()) {
            case DisplayStatus.IS_MONITOR:
              pMenu = dataManagerSNMenu.getPopupMenu();
              pMenu.show(e.getComponent(),e.getX(),e.getY());
              pMenu.setInvoker(dataManagerSNMenu);
              break;
            case DisplayStatus.TEST_DATA:
              pMenu = testDataMenu.getPopupMenu();
              pMenu.show(e.getComponent(),e.getX(),e.getY());
              pMenu.setInvoker(testDataMenu);
              break;
            case DisplayStatus.SCTDB_DATA:
              pMenu = sctdbDataSNMenu.getPopupMenu();
              pMenu.show(e.getComponent(),e.getX(),e.getY());
              pMenu.setInvoker(sctdbDataSNMenu);
              break;
            case DisplayStatus.SCTDB_RODDAQ_DATA:
              pMenu = sctdbDataSNMenu.getPopupMenu();
              pMenu.show(e.getComponent(),e.getX(),e.getY());
              pMenu.setInvoker(sctdbDataSNMenu);
              break;
            case DisplayStatus.IV_DATA:
              pMenu = ivScanMenu.getPopupMenu();
              pMenu.show(e.getComponent(),e.getX(),e.getY());
              pMenu.setInvoker(ivScanMenu);
              break;
            default:
          }
          break;
         case 0:
          switch(guiControl.displayStatus.getStatus()) {
            case DisplayStatus.IS_MONITOR:
              pMenu = getTable0Menu().getPopupMenu();
              pMenu.show(e.getComponent(),e.getX(),e.getY());
//              pMenu.setInvoker(tableDataOptionMenu);
              break;
            case DisplayStatus.TEST_DATA:
              pMenu = testFilterMenu.getPopupMenu();
              pMenu.show(e.getComponent(),e.getX(),e.getY());
              pMenu.setInvoker(testFilterMenu);
              break;
            default:
          }
          break;
         default:
         }

        }

   public void showPopupMenu(MouseEvent e) {
        JPopupMenu pMenu;
        JMenu newMenu = new JMenu();
        switch(guiControl.displayStatus.getStatus()) {
        case DisplayStatus.UNDEFINED:
           pMenu = configMenu.getPopupMenu();
           pMenu.show(e.getComponent(),e.getX(),e.getY());
           pMenu.setInvoker(configMenu);
           break;  
        case DisplayStatus.MODULE_GROUP_SELECTION:
           pMenu = displayMenu.getPopupMenu();
           pMenu.show(e.getComponent(),e.getX(),e.getY());
           pMenu.setInvoker(displayMenu);
           break;  
        case DisplayStatus.IS_MONITOR:
           newMenu.add(panelDisplayMenu);
           newMenu.add(panelTestMenu);
           newMenu.addSeparator();
           JMenuItem rItem = new JMenuItem("Retrieve Archived Data");
           rItem.setFont(menuFont);
           newMenu.add(rItem);
           rItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
               ArchiveQueryBox b = new ArchiveQueryBox(guiControl);
               b.setLocationRelativeTo(guiControl);
               b.setVisible(true);
            }
           });

//           pMenu = testMenu.getPopupMenu();
           pMenu = newMenu.getPopupMenu();
           pMenu.show(e.getComponent(),e.getX(),e.getY());
//           pMenu.setInvoker(testMenu);
           pMenu.setInvoker(newMenu);
           break;  
        case DisplayStatus.TEST_DATA:
           newMenu.add(panelDisplayMenu);
           newMenu.add(panelTestMenu);
           newMenu.add(panelTestDataOptionMenu);
           pMenu = newMenu.getPopupMenu();
           pMenu.show(e.getComponent(),e.getX(),e.getY());
           pMenu.setInvoker(newMenu);
           break;
        case DisplayStatus.SCTDB_DATA:
           newMenu.add(panelDisplayMenu);
           newMenu.add(panelsctdbSCTDAQOptionMenu);
           pMenu = newMenu.getPopupMenu();
           pMenu.show(e.getComponent(),e.getX(),e.getY());
           pMenu.setInvoker(newMenu);
           break;
        case DisplayStatus.SCTDB_RODDAQ_DATA:
           newMenu.add(panelDisplayMenu);
           newMenu.add(panelsctdbRODDAQOptionMenu);
           pMenu = newMenu.getPopupMenu();
           pMenu.show(e.getComponent(),e.getX(),e.getY());
           pMenu.setInvoker(newMenu);
           break;
        case DisplayStatus.DCS_DATA:
           newMenu.add(panelDisplayMenu);
           newMenu.add(panelTestMenu);
           pMenu = newMenu.getPopupMenu();
           pMenu.show(e.getComponent(),e.getX(),e.getY());
           pMenu.setInvoker(newMenu);
           break;
        case DisplayStatus.IV_DATA:
           newMenu.add(panelDisplayMenu);
           newMenu.add(ivScanOptionMenu);
           pMenu = newMenu.getPopupMenu();
           pMenu.show(e.getComponent(),e.getX(),e.getY());
           pMenu.setInvoker(newMenu);
           break;
  
        default:
           }
        }
//**************************************************
   private JMenu getTestDataOptionMenu() {
       JMenu thisMenu = new JMenu("Test Results");
       thisMenu.setFont(menuFont);
       testDataOptions[0] = new JMenuItem("ROD Data");
       testDataOptions[0].setFont(menuFont);
       testDataOptions[0].addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                    guiControl.displayPane.setDisplayOption(0);                   
                     }
             });
       testDataOptions[1] = new JMenuItem("SCTDAQ Reference Data");
       testDataOptions[1].setFont(menuFont);
       testDataOptions[1].addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                    guiControl.displayPane.setDisplayOption(1);                   
                     }
             });

       testDataOptions[2] = new JMenuItem("Comparison ROD-SCTDAQ");
       testDataOptions[2].setFont(menuFont);
       testDataOptions[2].addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                    guiControl.displayPane.setDisplayOption(2);                   
                     }
             });
       thisMenu.add(testDataOptions[0]);
       thisMenu.add(testDataOptions[1]);
       thisMenu.add(testDataOptions[2]);

       JMenuItem item = new JMenuItem("Upload to SCT Database");
       item.setFont(menuFont);
       item.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                    TestSelection t = guiControl.tablesDisplayPane.getTestSelection();
                    if(t==null) {
                      javax.swing.JOptionPane.showMessageDialog(null,"There is no Data to upload!");
                      return;
                      }
                    int response = JOptionPane.showConfirmDialog(null,"Are you sure want to upload the data for Run/Scan "+t.getRunNo()+"/"+t.getScanNo()+"?");
                    if(response!=javax.swing.JOptionPane.YES_OPTION) return;
                    UploadManager upload = new UploadManager(guiControl);                   
                     }
             });
       thisMenu.addSeparator();
       thisMenu.add(item);
      
       return thisMenu;
       }
//**************************************************************************
    private JMenu getDisplayOptionMenu() {
       JMenu thisMenu = new JMenu("Display");
       thisMenu.setFont(menuFont);

       JMenuItem item = new JMenuItem("Clear Result Cache");
       item.setFont(menuFont);
       item.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                    System.out.println("SctGUI: Clearing cache (was "+guiControl.isInterface.cache.size()+" objects deep)");
                    guiControl.isInterface.cache.clear();
                 }
             });
       thisMenu.add(item);

       item = new JMenuItem("Reset all Color Scales");
       item.setFont(menuFont);
       item.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                   int response = javax.swing.JOptionPane.showConfirmDialog(null,"This will permanently reset all color scales to their defaults. Continue?","Confirm",javax.swing.JOptionPane.YES_NO_OPTION,javax.swing.JOptionPane.INFORMATION_MESSAGE);
                   if(response==javax.swing.JOptionPane.YES_OPTION) {
                      ColorScaleManager.getInstance().clearAll();
                      guiControl.colorScalePane.setColorScale();
                      guiControl.displayPane.setDisplayColors();
                      guiControl.displayPane.refreshDisplay();
                      }
                        
                 }
             });
       thisMenu.add(item);

       autoSelectMode.setFont(menuFont);
       autoSelectMode.setSelected(PreferencesInterface.getInstance().getPreference(PreferencesInterface.AUTO_TEST_SELECT).equals("TRUE"));
       thisMenu.add(autoSelectMode);
       autoSelectMode.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                    String status = autoSelectMode.isSelected() ? "TRUE" : "FALSE";
                    PreferencesInterface.getInstance().setPreference(PreferencesInterface.AUTO_TEST_SELECT,status);                        
                 }
             });

       return thisMenu;
       }
//**************************************************************************
    private JMenu getTableDataOptionMenu() {
       JMenu thisMenu = new JMenu("Data Manager");
       thisMenu.setFont(menuFont);

       JMenuItem item = new JMenuItem("Plot Selected Data");
       item.setFont(menuFont);
       item.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                    switch(guiControl.displayStatus.getStatus()) {
                       case DisplayStatus.IS_MONITOR:
                          String objectname;
                          if((objectname = guiControl.tablesDisplayPane.getSelectedObject())!=null) guiControl.isInterface.launchExternalViewer(objectname);
                          else javax.swing.JOptionPane.showMessageDialog(null,"No data selected.");
                        break;
                    default:
                     }                                   
                 }
             });
       thisMenu.add(item);

       item = new JMenuItem("Delete Selected Test(s)");
       item.setFont(menuFont);
       item.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                    switch(guiControl.displayStatus.getStatus()) {
                       case DisplayStatus.IS_MONITOR:
                         TestSelection testSelection = guiControl.tablesDisplayPane.getTestSelection();
                         if(testSelection==null) {
                             javax.swing.JOptionPane.showMessageDialog(null,"No data selected.");
                             return;
                             } 
                         int selectedRow = guiControl.tablesDisplayPane.getSelectedTest();
                         int response = JOptionPane.showConfirmDialog(null,"Delete "+testSelection.getTestName()+" test for Run/Scan "+testSelection.getRunNo()+"/"+testSelection.getScanNo()+"?","Confirm Deletion",JOptionPane.YES_NO_OPTION,JOptionPane.QUESTION_MESSAGE);
                         if(response==JOptionPane.NO_OPTION) return;
                         guiControl.isInterface.removeTests(guiControl.tablesDisplayPane.getTestControlObjectNames(),selectedRow,selectedRow); 
                         guiControl.tablesDisplayPane.updateTables();
                         break;
                       default:
                     }                                   
                 }
             });
       thisMenu.add(item);


       item = new JMenuItem("View Selected IS Object");
       item.setFont(menuFont);
       item.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                    switch(guiControl.displayStatus.getStatus()) {
                       case DisplayStatus.IS_MONITOR:
                          String objectname;
                          if((objectname = guiControl.tablesDisplayPane.getSelectedObject())!=null) guiControl.isInterface.viewISData(objectname);
                          else javax.swing.JOptionPane.showMessageDialog(null,"No data selected.");
                        break;
                    default:
                     }                                   
                 }
             });

       thisMenu.add(item);

       item = new JMenuItem("View Selected Module Configuration");
       item.setFont(menuFont);
       item.addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
               String sn = guiControl.tablesDisplayPane.getSelectedSerialNo();
               if(sn==null) return;
                  JFrame frame2 = new JFrame("Module Configuration");                                
                  frame2.getContentPane().add(new GuiComponents.Panels.ModuleConfigurationPanel(sn));
                  frame2.pack();
                  frame2.show();
                     }

          });  
       thisMenu.add(item);

       item = new JMenuItem("Retrieve Archived Data");
       item.setFont(menuFont);
       item.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
               ArchiveQueryBox b = new ArchiveQueryBox(guiControl);
               b.setLocationRelativeTo(guiControl);
               b.setVisible(true);
            }
           });
       thisMenu.add(item);

       return thisMenu;
       }
//**************************************************************************
    private JMenu getTable0Menu() {
       JMenu thisMenu = new JMenu("Data Manager - table0");

       thisMenu.setFont(menuFont);

       JMenuItem item = new JMenuItem("Delete Selected Test(s)");
       item.setFont(menuFont);
       item.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                    switch(guiControl.displayStatus.getStatus()) {
                       case DisplayStatus.IS_MONITOR:
                         TestSelection testSelection = guiControl.tablesDisplayPane.getTestSelection();
                         if(testSelection==null) {
                             javax.swing.JOptionPane.showMessageDialog(null,"No data selected.");
                             return;
                             }
                         int selectedRow = guiControl.tablesDisplayPane.getSelectedTest();
                         int response = JOptionPane.showConfirmDialog(null,"Delete "+testSelection.getTestName()+" test for Run/Scan "+testSelection.getRunNo()+"/"+testSelection.getScanNo()+"?","Confirm Deletion",JOptionPane.YES_NO_OPTION,JOptionPane.QUESTION_MESSAGE);
                         if(response==JOptionPane.NO_OPTION) return;
                         guiControl.isInterface.removeTests(guiControl.tablesDisplayPane.getTestControlObjectNames(),selectedRow,selectedRow); 
                         guiControl.tablesDisplayPane.updateTables();
                         break;
                       default:
                     }                                   
                 }
             });
       thisMenu.add(item);



       return thisMenu;
       }
    private JMenu getDCSOptionMenu() {
       JMenu thisMenu = new JMenu("DCS");

       thisMenu.setFont(menuFont);

       JMenuItem item = new JMenuItem("IS Server Name...");
       item.setFont(menuFont);
       thisMenu.add(item);
       item.addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
                   Preference preference = new Preference(guiControl,PreferencesInterface.DCS_SERVER_NAME);                      
                   }
              });
       item = new JMenuItem("IV Scan Data Directory...");
       item.setFont(menuFont);
       thisMenu.add(item);
       item.addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
                   Preference preference = new Preference(guiControl,PreferencesInterface.IV_DIRECTORY);                      
                   }
              });
       thisMenu.addSeparator();

       item = new JMenuItem("Import IV Scans...");
       item.setFont(menuFont);
       thisMenu.add(item);
       item.addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
                   new IVScanLister(guiControl.displayPane.getSCTView()).show();                     
                   }
              });
       item = new JMenuItem("Plot Selected IVScans");
       item.setFont(menuFont);
       thisMenu.add(item);
       item.addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
                   plotIVScanData(null);                     
                   }
              });
       item = new JMenuItem("Upload Selected IVScans to SCT Database");
       item.setFont(menuFont);
       thisMenu.add(item);
       item.addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
                    IVTestSelection i = guiControl.tablesDisplayPane.getIVTestSelection();
                    if(i==null) {
                      javax.swing.JOptionPane.showMessageDialog(null,"There is no IV scan Data to upload!");
                      return;
                      }
                    int response = JOptionPane.showConfirmDialog(null,"Are you sure want to upload the IV scans for Run/Scan "+i.getRunNo()+"/"+i.getScanNo()+"?");
                    if(response!=javax.swing.JOptionPane.YES_OPTION) return;
                    UploadManager upload = new UploadManager(guiControl);                      
                   }
              });

       return thisMenu;
       }

    private JMenu getIVScanOptionMenu() {
       JMenu thisMenu = new JMenu("IV scans");

       thisMenu.setFont(menuFont);


       JMenuItem item = new JMenuItem("Import IV Scans...");
       item.setFont(menuFont);
       thisMenu.add(item);
       item.addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
                   new IVScanLister(guiControl.displayPane.getSCTView()).show();                     
                   }
              });
       item = new JMenuItem("Upload to SCT Database");
       item.setFont(menuFont);
       thisMenu.add(item);
       item.addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
                    IVTestSelection i = guiControl.tablesDisplayPane.getIVTestSelection();
                    if(i==null) {
                      javax.swing.JOptionPane.showMessageDialog(null,"There is no IV scan Data to upload!");
                      return;
                      }
                    int response = JOptionPane.showConfirmDialog(null,"Are you sure want to upload the IV scans for Run/Scan "+i.getRunNo()+"/"+i.getScanNo()+"?");
                    if(response!=javax.swing.JOptionPane.YES_OPTION) return;
                    UploadManager upload = new UploadManager(guiControl);                      
                   }
              });

       return thisMenu;
       }

//****************************************************************************************
    private JMenu getDBSCTDAQDataOptionMenu(boolean isPanel) {
       JMenu thisMenu = new JMenu("SCTDAQ Reference");
//       thisMenu.setBackground(backgroundColor);
       thisMenu.setFont(menuFont);
//       thisMenu.setForeground(menuColor);
       JMenuItem item = new JMenuItem("Download SCTDAQ Reference Data");
       item.setFont(menuFont);
       thisMenu.add(item);
       item.addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
                   guiControl.isInterface.downloadTests(-1);
                   }
              });
       item = new JMenuItem("SCTDAQ Test Location ...");
       item.setFont(menuFont);
       thisMenu.add(item);
       item.addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
                 java.util.Vector listOfLocations = new java.util.Vector();
                 try {
                      listOfLocations = ProdDatabase.GeneralUtilities.getLocationList();
                 }catch(Exception e2){}
                 listOfLocations.insertElementAt("Any",0);
                 guiUtilities.userPrompt thisPrompt = new guiUtilities.userPrompt(guiControl,"Any","Institute", listOfLocations);
                 thisPrompt.pack();
                 thisPrompt.setLocationRelativeTo(guiControl);
                 thisPrompt.setVisible(true);
                 String thisLocation = thisPrompt.getValidatedText();
                 if (!thisLocation.equals("None")) {
                      guiControl.isInterface.setLocation(thisLocation);
//                      guiControl.isInterface.setTestFilter(guiControl.tablesDisplayPane.getTestControlObjectName());
                      guiControl.selectorPane.initParamList(); // maybe require change of parameter menu
                      guiControl.colorScalePane.setColorScale(); // ditto for color scale
                      guiControl.displayPane.setDisplayColors();
                      guiControl.displayPane.refreshDisplay();
                      guiControl.tablesDisplayPane.listTestResults();
                      }
                   
                   }
              });
       if(!isPanel) {
         sctdbAutoDownload.setFont(menuFont);
         thisMenu.add(sctdbAutoDownload);
         }
       return thisMenu;
       }
//****************************************************************************************
    private JMenu getDBRODDAQDataOptionMenu(boolean isPanel) {
       JMenu thisMenu = new JMenu("SctRodDaq Downloads");
//       thisMenu.setBackground(backgroundColor);
       thisMenu.setFont(menuFont);
//       thisMenu.setForeground(menuColor);

       JMenuItem item = new JMenuItem("Download SctRodDaq Data ...");
       item.setFont(menuFont);
       thisMenu.add(item);
       item.addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
                   new DatabaseLister().show();                   
                   }
              });

       if(!isPanel) {
         sctdbAutoUpload.setFont(menuFont);
         thisMenu.add(sctdbAutoUpload);
         }
       return thisMenu;
       }
//*************************************************************************************************8
   private JMenu getCCDataOptionMenu() {
       JMenu thisMenu = new JMenu("CalibrationController");
       thisMenu.setFont(menuFont);
       JMenuItem item = new JMenuItem("Ping");
       item.setFont(menuFont);
       item.addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
                   try { 
                      ipc.InfoHolder infoHolder = new ipc.InfoHolder();
                      if (si.getCalibrationController() != null)  {
                          si.getCalibrationController().get_info(infoHolder);
                         ipc.Info info = infoHolder.value;
                         System.out.println("CalibrationController running: " + info.pid + " by " + info.owner + " on " +info.host + " since " + info.time);
                         } 
                       else System.out.println("CalibrationController not running");
                       }catch(Exception eNoAbort){System.err.println("Error aborting calibrationController: "+eNoAbort.toString());}
                    }
              });   
       thisMenu.add(item);

       thisMenu.addSeparator();
       javax.swing.ButtonGroup thisGroup = new javax.swing.ButtonGroup();
       for(int i=0;i<ccUpdateModes.length;i++) {
         ccUpdateModes[i] = new JCheckBox(ccUpdateStrings[i]);
         thisGroup.add(ccUpdateModes[i]);
         ccUpdateModes[i].setFont(menuFont);
         thisMenu.add(ccUpdateModes[i]);
         }
       item = new JMenuItem("Abort");
       item.setFont(menuFont);
       item.addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
                   try { 
//                       System.out.println("abort of CC not yet implemented");
                       si.getCalibrationController().abort();
                       }catch(Exception eNoAbort){System.err.println("Error aborting calibrationController: "+eNoAbort.toString());}
                    }
              });    
       thisMenu.addSeparator();
       thisMenu.add(item);   
                       

       ccUpdateModes[0].setSelected(true);
       for(int i=0;i<ccUpdateModes.length;i++) {  
	   // ccUpdateModes[i].setEnabled(false);   
         switch(i) {
            case 0:
            ccUpdateModes[i].addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
                   try {
                       si.getCalibrationController().setUpdateOption(UpdateOption.update);
                       checkCCUpdateMode();
                   }catch(Exception e){System.err.println("Error : "+e.toString());}
                   }
              });
            break;
            case 1:
            ccUpdateModes[i].addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
                   try {
                       si.getCalibrationController().setUpdateOption(UpdateOption.noupdate);
                       checkCCUpdateMode();
                   }catch(Exception e){System.err.println("Error : "+e.toString());}
                   }
              });
            break;
            case 2:
            ccUpdateModes[i].addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
                   try {
                       si.getCalibrationController().setUpdateOption(UpdateOption._wait);
                       checkCCUpdateMode();
                   }catch(Exception e){System.err.println("Error : "+e.toString());}
                   }
              });
            break;
            default:
            }
        }
      return thisMenu;
      }
//************************************************************************************
   public void checkCCUpdateMode() {
         if(guiControl.calibrationControllerPanel==null || guiControl.calibrationControllerPanel.status==null) {   // why is this necessary????
             System.out.println("CalibrationControllerPanel.status object not yet available... update mode not yet known");
             return;
             }
         String updateMode = guiControl.calibrationControllerPanel.status.updateOption;
         if(updateMode.equals("NOUPDATE")) ccUpdateModes[1].setSelected(true);
         else if(updateMode.equals("WAIT")) ccUpdateModes[2].setSelected(true);
         else   ccUpdateModes[0].setSelected(true);
         }

//*************************************************************************************************8
   private JMenu getTestFilterMenu() {
       JMenu thisMenu = new JMenu("Test Filter");
       thisMenu.setFont(menuFont);
       javax.swing.ButtonGroup thisGroup = new javax.swing.ButtonGroup();
       testFilterButtons[0] = new JCheckBox("All tests");
       thisGroup.add(testFilterButtons[0]);
       testFilterButtons[0].setFont(menuFont);
       testFilterButtons[0].addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
                   switch(guiControl.displayStatus.getStatus()) {
                   case DisplayStatus.TEST_DATA:
                     guiControl.displayStatus.setTestDataMode(-1);      
                     break;
                   case DisplayStatus.SCTDB_DATA:
                    guiControl.displayStatus.setSCTDBDataMode(-1); 
                     break;
                   case DisplayStatus.SCTDB_RODDAQ_DATA:
                    guiControl.displayStatus.setSCTDBRodDaqMode(-1); 
                     break;
                   default:
                   }           
                 }
              });
        thisMenu.add(testFilterButtons[0]);
       for(int i=1;i<testFilterButtons.length;i++) {
         if(!testIsDefined[i-1]) continue;
         testFilterButtons[i] = new JCheckBox(testNames[i-1]);
         thisGroup.add(testFilterButtons[i]);
         testFilterButtons[i].setFont(menuFont);
         thisMenu.add(testFilterButtons[i]);
         }
       testFilterButtons[0].setSelected(true);

       for(int i=1;i<testFilterButtons.length;i++) {  
         if(!testIsDefined[i-1]) continue;
         switch(i-1) { 
          case TEST_FULLBYPASS:
             testFilterButtons[i].addActionListener(new java.awt.event.ActionListener() {
               public void actionPerformed(java.awt.event.ActionEvent evt) {
                   switch(guiControl.displayStatus.getStatus()) {
                   case DisplayStatus.TEST_DATA:
                     guiControl.displayStatus.setTestDataMode(TEST_FULLBYPASS);      
                     break;
                   case DisplayStatus.SCTDB_DATA:
                    guiControl.displayStatus.setSCTDBDataMode(TEST_FULLBYPASS); 
                     break;
                   case DisplayStatus.SCTDB_RODDAQ_DATA:
                     guiControl.displayStatus.setSCTDBRodDaqMode(TEST_FULLBYPASS); 
                     break;
                   default:
                   }           
                   }
              });
            break;
          case TEST_PIPELINE:
             testFilterButtons[i].addActionListener(new java.awt.event.ActionListener() {
               public void actionPerformed(java.awt.event.ActionEvent evt) {
                   switch(guiControl.displayStatus.getStatus()) {
                   case DisplayStatus.TEST_DATA:
                     guiControl.displayStatus.setTestDataMode(TEST_PIPELINE);      
                     break;
                   case DisplayStatus.SCTDB_DATA:
                    guiControl.displayStatus.setSCTDBDataMode(TEST_PIPELINE); 
                     break;
                   case DisplayStatus.SCTDB_RODDAQ_DATA:
                     guiControl.displayStatus.setSCTDBRodDaqMode(TEST_PIPELINE); 
                     break;
                   default:
                   }           
                   }
              });
            break;
          case TEST_STROBEDELAY:
             testFilterButtons[i].addActionListener(new java.awt.event.ActionListener() {
               public void actionPerformed(java.awt.event.ActionEvent evt) {
                   switch(guiControl.displayStatus.getStatus()) {
                   case DisplayStatus.TEST_DATA:
                     guiControl.displayStatus.setTestDataMode(TEST_STROBEDELAY);      
                     break;
                   case DisplayStatus.SCTDB_DATA:
                    guiControl.displayStatus.setSCTDBDataMode(TEST_STROBEDELAY); 
                     break;
                   case DisplayStatus.SCTDB_RODDAQ_DATA:
                     guiControl.displayStatus.setSCTDBRodDaqMode(TEST_STROBEDELAY); 
                     break;
                   default:
                   }           
                   }
              });
            break;
          case TEST_3PTGAIN:
             testFilterButtons[i].addActionListener(new java.awt.event.ActionListener() {
               public void actionPerformed(java.awt.event.ActionEvent evt) {
                   switch(guiControl.displayStatus.getStatus()) {
                   case DisplayStatus.TEST_DATA:
                     guiControl.displayStatus.setTestDataMode(TEST_3PTGAIN);      
                     break;
                   case DisplayStatus.SCTDB_DATA:
                    guiControl.displayStatus.setSCTDBDataMode(TEST_3PTGAIN); 
                     break;
                   case DisplayStatus.SCTDB_RODDAQ_DATA:
                     guiControl.displayStatus.setSCTDBRodDaqMode(TEST_3PTGAIN); 
                     break;
                   default:
                   }           
                   }
              });
            break;
          case TEST_TRIM:
             testFilterButtons[i].addActionListener(new java.awt.event.ActionListener() {
               public void actionPerformed(java.awt.event.ActionEvent evt) {
                   switch(guiControl.displayStatus.getStatus()) {
                   case DisplayStatus.TEST_DATA:
                     guiControl.displayStatus.setTestDataMode(TEST_TRIM);      
                     break;
                   case DisplayStatus.SCTDB_DATA:
                    guiControl.displayStatus.setSCTDBDataMode(TEST_TRIM); 
                     break;
                   case DisplayStatus.SCTDB_RODDAQ_DATA:
                     guiControl.displayStatus.setSCTDBRodDaqMode(TEST_TRIM); 
                     break;
                   default:
                   }           
                   }
              });
            break;
          case TEST_NPTGAIN:
             testFilterButtons[i].addActionListener(new java.awt.event.ActionListener() {
               public void actionPerformed(java.awt.event.ActionEvent evt) {
                   switch(guiControl.displayStatus.getStatus()) {
                   case DisplayStatus.TEST_DATA:
                     guiControl.displayStatus.setTestDataMode(TEST_NPTGAIN);      
                     break;
                   case DisplayStatus.SCTDB_DATA:
                    guiControl.displayStatus.setSCTDBDataMode(TEST_NPTGAIN); 
                     break;
                   case DisplayStatus.SCTDB_RODDAQ_DATA:
                     guiControl.displayStatus.setSCTDBRodDaqMode(TEST_NPTGAIN); 
                     break;
                   default:
                   }           
                   }
              });
            break;
          case TEST_NOISE:
             testFilterButtons[i].addActionListener(new java.awt.event.ActionListener() {
               public void actionPerformed(java.awt.event.ActionEvent evt) {
                   switch(guiControl.displayStatus.getStatus()) {
                   case DisplayStatus.TEST_DATA:
                     guiControl.displayStatus.setTestDataMode(TEST_NOISE);      
                     break;
                   case DisplayStatus.SCTDB_DATA:
                    guiControl.displayStatus.setSCTDBDataMode(TEST_NOISE); 
                     break;
                   case DisplayStatus.SCTDB_RODDAQ_DATA:
                     guiControl.displayStatus.setSCTDBRodDaqMode(TEST_NOISE); 
                     break;
                   default:
                   }           
                   }
              });
            break;
          case TEST_TIMEWALK:
             testFilterButtons[i].addActionListener(new java.awt.event.ActionListener() {
               public void actionPerformed(java.awt.event.ActionEvent evt) {
                   switch(guiControl.displayStatus.getStatus()) {
                   case DisplayStatus.TEST_DATA:
                     guiControl.displayStatus.setTestDataMode(TEST_TIMEWALK);      
                     break;
                   case DisplayStatus.SCTDB_DATA:
                    guiControl.displayStatus.setSCTDBDataMode(TEST_TIMEWALK); 
                     break;
                   case DisplayStatus.SCTDB_RODDAQ_DATA:
                     guiControl.displayStatus.setSCTDBRodDaqMode(TEST_TIMEWALK); 
                     break;
                   default:
                   }           
                   }
              });
            break;
          case TEST_NMASK:
             testFilterButtons[i].addActionListener(new java.awt.event.ActionListener() {
               public void actionPerformed(java.awt.event.ActionEvent evt) {
                   switch(guiControl.displayStatus.getStatus()) {
                   case DisplayStatus.TEST_DATA:
                     guiControl.displayStatus.setTestDataMode(TEST_NMASK);      
                     break;
                   case DisplayStatus.SCTDB_DATA:
                    guiControl.displayStatus.setSCTDBDataMode(TEST_NMASK); 
                     break;
                   case DisplayStatus.SCTDB_RODDAQ_DATA:
                     guiControl.displayStatus.setSCTDBRodDaqMode(TEST_NMASK); 
                     break;
                   default:
                   }           
                   }
              });
            break;
	     case TEST_RXTHRESHOLD:
             testFilterButtons[i].addActionListener(new java.awt.event.ActionListener() {
               public void actionPerformed(java.awt.event.ActionEvent evt) {
                   switch(guiControl.displayStatus.getStatus()) {
                   case DisplayStatus.TEST_DATA:
                     guiControl.displayStatus.setTestDataMode(TEST_RXTHRESHOLD);      
                     break;
                   case DisplayStatus.SCTDB_DATA:
                    guiControl.displayStatus.setSCTDBDataMode(TEST_RXTHRESHOLD); 
                     break;
                   case DisplayStatus.SCTDB_RODDAQ_DATA:
                     guiControl.displayStatus.setSCTDBRodDaqMode(TEST_RXTHRESHOLD); 
                     break;
                   default:
                   }           
                   }
              });
            break;
	     case TEST_RXDELAY:
             testFilterButtons[i].addActionListener(new java.awt.event.ActionListener() {
               public void actionPerformed(java.awt.event.ActionEvent evt) {
                   switch(guiControl.displayStatus.getStatus()) {
                   case DisplayStatus.TEST_DATA:
                     guiControl.displayStatus.setTestDataMode(TEST_RXDELAY);      
                     break;
                   case DisplayStatus.SCTDB_DATA:
                    guiControl.displayStatus.setSCTDBDataMode(TEST_RXDELAY); 
                     break;
                   case DisplayStatus.SCTDB_RODDAQ_DATA:
                     guiControl.displayStatus.setSCTDBRodDaqMode(TEST_RXDELAY); 
                     break;
                   default:
                   }           
	           }
              });
            break;
            default:
            }
          }
      return thisMenu;
      }

   public void resetTestListFilter() {
      testFilterButtons[0].setSelected(true);
      }

   private JMenu getTestInvokeMenu() {
       JMenu thisMenu = new JMenu("Tests");
       JMenuItem menuItem;

       //===========================================================================================

       JMenu bocTestsMenu = new JMenu("Boc Setup");
       bocTestsMenu.setFont(menuFont);
       menuItem = new JMenuItem("Raw Scan");
       menuItem.setFont(menuFont);
       menuItem.addActionListener(new java.awt.event.ActionListener() {
	       public void actionPerformed(java.awt.event.ActionEvent evt) {
		   si.getCalibrationController().doScan(si.getCalibrationController().getScanLibrary().rawScan(10));
	       }
	   });

       bocTestsMenu.add(menuItem);

       menuItem = new JMenuItem("RX Threshold");
       menuItem.setFont(menuFont);
       menuItem.addActionListener(new java.awt.event.ActionListener() {
	       public void actionPerformed(java.awt.event.ActionEvent evt) {
		   //Sct_CalibrationController.ScanRequest request = si.getCalibrationController().getScanLibrary().rawScan(10);
		   //request.getScan().configure((short)50, 0., 200., 5.);
		   //si.getCalibrationController().doScan( request );
		   si.getCalibrationController().doTest(si.getCalibrationController().getTestLibrary().rxThreshold()  );
	       }
	   });
       bocTestsMenu.add(menuItem);

       menuItem = new JMenuItem("RX Delay");
       menuItem.setFont(menuFont);
       menuItem.addActionListener(new java.awt.event.ActionListener() {
	       public void actionPerformed(java.awt.event.ActionEvent evt) {
		   //Sct_CalibrationController.ScanRequest request = si.getCalibrationController().getScanLibrary().rawScan(10);
		   //request.getScan().configure((short)20, 0., 24., 1.);
		   //si.getCalibrationController().doScan( request );
		   si.getCalibrationController().doTest(si.getCalibrationController().getTestLibrary().rxDelay()  );
	       }
	   });
       bocTestsMenu.add(menuItem);

       menuItem = new JMenuItem("TX Current");
       menuItem.setFont(menuFont);
       menuItem.addActionListener(new java.awt.event.ActionListener() {
	       public void actionPerformed(java.awt.event.ActionEvent evt) {
		   Sct_CalibrationController.ScanRequest request = si.getCalibrationController().getScanLibrary().rawScan(10);
		   request.getScan().configure((short)53, 60., 200., 10.);
		   si.getCalibrationController().doScan( request );
	       }
	   });
       bocTestsMenu.add(menuItem);

       thisMenu.add(bocTestsMenu);

       //==========================================================================================

       JMenu digitalTestsMenu = new JMenu("Digital Tests");
       digitalTestsMenu.setFont(menuFont);

       menuItem = new JMenuItem("NMask");
       menuItem.setFont(menuFont);

       menuItem.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
//                    guiControl.displayStatus.setTestDataMode(-1); 
                     si.getCalibrationController().doTest(si.getCalibrationController().getTestLibrary().nmask());               
                     }
             });


       digitalTestsMenu.add(menuItem);

       menuItem = new JMenuItem("Pipeline");
       menuItem.setFont(menuFont);
       menuItem.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
 //                    guiControl.displayStatus.setTestDataMode(-1); 
	             si.getCalibrationController().doTest(si.getCalibrationController().getTestLibrary().pipeline());           
                     }
             });

       digitalTestsMenu.add(menuItem);

       menuItem = new JMenuItem("FullByPass (Barrel)");
       menuItem.setFont(menuFont);
       menuItem.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
 //                    guiControl.displayStatus.setTestDataMode(-1); 
                     si.getCalibrationController().doTest(si.getCalibrationController().getTestLibrary().fullBypassBarrel() );          
                     }
             });

       digitalTestsMenu.add(menuItem);

       menuItem = new JMenuItem("FullByPass (Endcap)");
       menuItem.setFont(menuFont); 
       menuItem.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
 //                    guiControl.displayStatus.setTestDataMode(-1); 
		     si.getCalibrationController().doTest(si.getCalibrationController().getTestLibrary().fullBypassEndcap() );
                     }
             });

       digitalTestsMenu.add(menuItem);

       thisMenu.add(digitalTestsMenu);


       //===========================================================================================

       JMenu analogueTestsMenu = new JMenu("Analogue Tests");
       analogueTestsMenu.setFont(menuFont);


       menuItem = new JMenuItem("Strobe Delay");
       menuItem.setFont(menuFont);
       menuItem.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
 //                    guiControl.displayStatus.setTestDataMode(-1); 
                     si.getCalibrationController().doTest(si.getCalibrationController().getTestLibrary().strobeDelay());         
                     }
             });

       analogueTestsMenu.add(menuItem);

       menuItem = new JMenuItem("3PtGain");
       menuItem.setFont(menuFont);
       menuItem.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
 //                    guiControl.displayStatus.setTestDataMode(-1); 
                     si.getCalibrationController().doTest(si.getCalibrationController().getTestLibrary().threePointGain());        
                     }
             });

       analogueTestsMenu.add(menuItem);

       menuItem = new JMenuItem("Trim");
       menuItem.setFont(menuFont);
       menuItem.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
 //                    guiControl.displayStatus.setTestDataMode(-1); 
                     si.getCalibrationController().doTest(si.getCalibrationController().getTestLibrary().trimRange() );       
                     }
             });

       analogueTestsMenu.add(menuItem);

       menuItem = new JMenuItem("ResponseCurve");
       menuItem.setFont(menuFont);
       menuItem.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
 //                    guiControl.displayStatus.setTestDataMode(-1); 
                     si.getCalibrationController().doTest(si.getCalibrationController().getTestLibrary().responseCurve());      
                     }
             });

       analogueTestsMenu.add(menuItem);

       menuItem = new JMenuItem("Noise Occupancy");
       menuItem.setFont(menuFont);
       menuItem.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
 //                    guiControl.displayStatus.setTestDataMode(-1); 
                     si.getCalibrationController().doTest(si.getCalibrationController().getTestLibrary().noiseOccupancy() );     
                     }
             });

       analogueTestsMenu.add(menuItem);

       menuItem = new JMenuItem("Time Walk");
       menuItem.setFont(menuFont);
       menuItem.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
 //                    guiControl.displayStatus.setTestDataMode(-1); 
                     si.getCalibrationController().doTest(si.getCalibrationController().getTestLibrary().timeWalk());   
                     }
             });

       analogueTestsMenu.add(menuItem);

       thisMenu.add(analogueTestsMenu);

       JMenu sequencesMenu = new JMenu("Sequences");
       sequencesMenu.setFont(menuFont);

       menuItem = new JMenuItem("Characterisation");
       menuItem.setFont(menuFont);
       menuItem.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
 //                    guiControl.displayStatus.setTestDataMode(-1); 
                     si.getCalibrationController().doSequence(si.getCalibrationController().getSequenceLibrary().characterizationSequence()); 
                     }
             });
       sequencesMenu.add(menuItem);
       
       thisMenu.add(sequencesMenu);

       thisMenu.addSeparator();
       thisMenu.add(getSCTDAQMenu());

       return thisMenu;
       }

   public void updateMenuStates() {
      switch(guiControl.displayStatus.getStatus()) {
         case DisplayStatus.IS_MONITOR:
             enableDataManagerItems(true);
             break;
         default:
             enableDataManagerItems(false);
         }
    }
   


  private void enableDataManagerItems(boolean isEnabled) {
             for(int i=0;i<tableDataOptionMenu.getItemCount();i++) tableDataOptionMenu.getItem(i).setEnabled(isEnabled);
             }

  private JMenu getSCTDAQMenu() {
       JMenu sctdaqmenu = new JMenu("SCTDAQ Exerciser");

       sctdaqmenu.setFont(menuFont);

       menuItem = new JMenuItem("Ping");
       menuItem.setFont(menuFont);
       menuItem.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                     //There is no ping method atm
                     //System.out.println(si.getTestApi().ping(""));
                     }
             });
       sctdaqmenu.add(menuItem);
       sctdaqmenu.addSeparator();


       for(int i=0;i<sctapiItems.length;i++) {
         if(!testIsDefined[i] || !testIsSCTDAQ[i]) continue;
         sctapiItems[i] = new JMenuItem(testMenuNames[i]);
         sctapiItems[i].setFont(menuFont);
         sctdaqmenu.add(sctapiItems[i]);
         switch(i) {
            case TEST_FULLBYPASS:
              sctapiItems[i].addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
                   guiControl.displayStatus.setTestDataMode(-1); 
                   try {
                       if((si.getTestHighLevelApi())!=null) si.getTestHighLevelApi().fullBypass();
                   } catch (SctTestApi.NoDataException nde) {}
//                   System.out.println("Start full bypass test via sct_api_server");   
                   if(sctdbAutoDownload.isSelected()) guiControl.isInterface.downloadTests(TEST_FULLBYPASS);
                   }
              });
            case TEST_PIPELINE:
              sctapiItems[i].addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
//                    guiControl.displayStatus.setTestDataMode(-1);
                    try {
                        if((si.getTestHighLevelApi())!=null) si.getTestHighLevelApi().pipeline();
                    } catch (SctTestApi.NoDataException nde) {}
//                   System.out.println("Start pipeline test via sct_api_server");   
                   if(sctdbAutoDownload.isSelected()) guiControl.isInterface.downloadTests(TEST_PIPELINE);
                   }
              });
            break;
            case TEST_STROBEDELAY:
              sctapiItems[i].addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
//                    guiControl.displayStatus.setTestDataMode(-1); 
                    try {
                        if((si.getTestHighLevelApi())!=null) si.getTestHighLevelApi().strobeDelay();
                    } catch (SctTestApi.NoDataException nde) {}
//                    System.out.println("Start strobe delay test via sct_api_server");
                    if(sctdbAutoDownload.isSelected()) guiControl.isInterface.downloadTests(TEST_STROBEDELAY);
                   }
              });
             break;
            case TEST_3PTGAIN:
              sctapiItems[i].addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
//                    guiControl.displayStatus.setTestDataMode(-1); 
                    try {
                        if((si.getTestHighLevelApi())!=null) si.getTestHighLevelApi().threePointGain();
                    } catch (SctTestApi.NoDataException nde) {}
//                    System.out.println("Start 3PtGain test via sct_api_server");
                    if(sctdbAutoDownload.isSelected()) guiControl.isInterface.downloadTests(TEST_3PTGAIN);
                   }
              });
             break;
            case TEST_TRIM:
              sctapiItems[i].addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
//                    guiControl.displayStatus.setTestDataMode(-1); 
                    try {
                        if((si.getTestHighLevelApi())!=null) si.getTestHighLevelApi().trim();
                    } catch (SctTestApi.NoDataException nde) {}
                   //System.out.println("Start Trim Range test via sct_api_server");
                   if(sctdbAutoDownload.isSelected()) guiControl.isInterface.downloadTests(TEST_TRIM);
                   }
              });
             break;
            case TEST_NPTGAIN:
              sctapiItems[i].addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
//                    guiControl.displayStatus.setTestDataMode(-1); 
                    try {
                        if((si.getTestHighLevelApi())!=null) si.getTestHighLevelApi().responseCurve();
                    } catch (SctTestApi.NoDataException nde) {}
                   //System.out.println("Start NPtGain test via sct_api_server");
                   if(sctdbAutoDownload.isSelected()) guiControl.isInterface.downloadTests(TEST_NPTGAIN);
                   }
              });
             break;
            case TEST_NOISE:
              sctapiItems[i].addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
//                    guiControl.displayStatus.setTestDataMode(-1); 
                    try {
                        if((si.getTestHighLevelApi())!=null) si.getTestHighLevelApi().noiseOccupancy();
                    } catch (SctTestApi.NoDataException nde) {}
                   //System.out.println("Start Noise test via sct_api_server");
                   if(sctdbAutoDownload.isSelected()) guiControl.isInterface.downloadTests(TEST_NOISE);
                   }
              });
             break;
            case TEST_TIMEWALK:
              sctapiItems[i].addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
//                    guiControl.displayStatus.setTestDataMode(-1); 
                    try {
                        if((si.getTestHighLevelApi())!=null) si.getTestHighLevelApi().timeWalk();
                    } catch (SctTestApi.NoDataException nde) {}
                   //System.out.println("Start TimeWalk test via sct_api_server");
                   if(sctdbAutoDownload.isSelected()) guiControl.isInterface.downloadTests(TEST_TIMEWALK);
                   }
              });
             break;
             default:
             }
         }
    return sctdaqmenu;
    }

//   public boolean dcsIsEnabled() {
//      return dcsEnabled.isSelected();
//      }



   private void getTestDataMenu() {
       testDataMenu = new JMenu("Test Data Options");
       testDataMenu.setFont(menuFont);
       JMenuItem item1 = new JMenuItem("Test Report");
       item1.setFont(menuFont);
       testDataMenu.add(item1);
       item1.addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
//                System.out.println("Selected "+popupCell.getSerialNo());
                   TestSelection testSelection = guiControl.tablesDisplayPane.getTestSelection();
                   if(testSelection==null) {
                       javax.swing.JOptionPane.showMessageDialog(null,"No data selected.");
                       return;
                       }
                   java.util.Map dcsMap = null;
                   if(guiControl.tablesDisplayPane.getTestControlObjectName()!=null) dcsMap=guiControl.isInterface.getDCSMap(guiControl.tablesDisplayPane.getTestControlObjectName());
                   SummaryReader.DCSInfo dcsInfo = (dcsMap!=null) ? (SummaryReader.DCSInfo) dcsMap.get(getSelectedSerialNo()) : null;
                   SummaryReader.Test testResult = (SummaryReader.Test) guiControl.isInterface.getTest(testSelection.getResultObjectHeader(),getSelectedSerialNo(), dcsInfo);              
                   if(testResult!=null) SummaryReader.ReaderReportUtilities.showTestReport(getSelectedSerialNo(),testResult);
                   else javax.swing.JOptionPane.showMessageDialog(null,"No data for this module");
              }
          });  
       item1 = new JMenuItem("Summary Plots");
       item1.setFont(menuFont);
       testDataMenu.add(item1);
       item1.addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
                  TestSelection testSelection = guiControl.tablesDisplayPane.getTestSelection();
                  if(testSelection==null) {
                       javax.swing.JOptionPane.showMessageDialog(null,"No data selected.");
                       return;
                       }
                  String objectname;
                  if((objectname = testSelection.getTestObjectHeader())!=null) {
                     guiControl.isInterface.launchExternalViewer(objectname+getSelectedSerialNo());
                     }
                 }
          });  
       item1 = new JMenuItem("Module Configuration");
       item1.setFont(menuFont);
       testDataMenu.add(item1);
       item1.addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
            JFrame frame2 = new JFrame("Module Configuration");                    
            frame2.getContentPane().add(new GuiComponents.Panels.ModuleConfigurationPanel(getSelectedSerialNo()));
            frame2.pack();
            frame2.show();
                     }

          });  
       item1 = new JMenuItem("Dump test result");
       item1.setFont(menuFont);
       testDataMenu.add(item1);
       item1.addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
                     TestSelection testSelection = guiControl.tablesDisplayPane.getTestSelection();
                     if(testSelection==null)  {
                       javax.swing.JOptionPane.showMessageDialog(null,"No data selected.");
                       return;
                       }
                     String resultObject=testSelection.getResultObjectHeader()+getSelectedSerialNo();
                     if(!Sct.IS.SctNames.getISRepository().contains(resultObject)) {
                           javax.swing.JOptionPane.showMessageDialog(null,"No result for "+getSelectedSerialNo());
                           return;
                           }
                     TestSummaryIS result = new TestSummaryIS(); 
                     Sct.IS.SctNames.getISRepository().getValue(resultObject, result); 
                     java.util.Vector thisData = new java.util.Vector();
                     thisData.addElement(getSelectedSerialNo()+".txt");
                     thisData.addElement(result.dataString);
                     guiUtilities.RawDataViewer.getInstance().showNewData(thisData,"Result String for "+resultObject);
                     }

          });  
       item1 = new JMenuItem("Full SCTDB Module Report");
       item1.setFont(menuFont);
       testDataMenu.add(item1);
       item1.addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
             String sn = getSelectedSerialNo();
             ProdDatabase.ReportDownloader d = new ProdDatabase.ReportDownloader(guiUtilities.HTMLViewer.MODULESUMMARY,sn,0);
             if(d.isOkToStart()) d.start();
             }

          });  

       }
   private void getIVScanMenu() {
       ivScanMenu = new JMenu("IVScan");
       ivScanMenu.setFont(menuFont);
       JMenuItem item1 = new JMenuItem("Test Report");
       item1.setFont(menuFont);
       ivScanMenu.add(item1);
       item1.addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
//                System.out.println("Selected "+popupCell.getSerialNo());
                   IVTestSelection ivTestSelection = guiControl.tablesDisplayPane.getIVTestSelection();
                   if(ivTestSelection==null) {
                       javax.swing.JOptionPane.showMessageDialog(null,"No data selected.");
                       return;
                       }
                   SummaryReader.Test testResult = (SummaryReader.Test) guiControl.isInterface.getTest(ivTestSelection.getResultObjectHeader(),getSelectedSerialNo(),null);              
                   if(testResult!=null) SummaryReader.ReaderReportUtilities.showIVTestReport(getSelectedSerialNo(),testResult);
                   else javax.swing.JOptionPane.showMessageDialog(null,"No data for "+getSelectedSerialNo());
              }
          });  

       item1 = new JMenuItem("Plot IVScan");
       item1.setFont(menuFont);
       ivScanMenu.add(item1);
       item1.addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
                   plotIVScanData(guiControl.tablesDisplayPane.getSelectedSerialNo());
              }
          });  

       item1 = new JMenuItem("Dump test result");
       item1.setFont(menuFont);
       ivScanMenu.add(item1);
       item1.addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
                     IVTestSelection ivTestSelection = guiControl.tablesDisplayPane.getIVTestSelection();
                     if(ivTestSelection==null)  {
                       javax.swing.JOptionPane.showMessageDialog(null,"No data selected.");
                       return;
                       }
                     String resultObject=ivTestSelection.getResultObjectHeader()+getSelectedSerialNo();
                     if(!Sct.IS.SctNames.getISRepository().contains(resultObject)) {
                           javax.swing.JOptionPane.showMessageDialog(null,"No data for "+getSelectedSerialNo());
                           return;
                           }
                     TestSummaryIS result = new TestSummaryIS(); 
                     Sct.IS.SctNames.getISRepository().getValue(resultObject, result); 
                     java.util.Vector thisData = new java.util.Vector();
                     thisData.addElement(getSelectedSerialNo()+".txt");
                     thisData.addElement(result.dataString);
                     guiUtilities.RawDataViewer.getInstance().showNewData(thisData,"Result String for "+resultObject);
                     }

          });  
       item1 = new JMenuItem("Full SCTDB Module Report");
       item1.setFont(menuFont);
       ivScanMenu.add(item1);
       item1.addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
             String sn = getSelectedSerialNo();
             ProdDatabase.ReportDownloader d = new ProdDatabase.ReportDownloader(guiUtilities.HTMLViewer.MODULESUMMARY,sn,0);
             if(d.isOkToStart()) d.start();
             }

          });  

       }

   private void getSCTDBDataMenu() {
       sctdbDataSNMenu = new JMenu("Data Options");
       sctdbDataSNMenu.setFont(menuFont);

       JMenuItem item1 = new JMenuItem("Test Report");
       item1.setFont(menuFont);
       sctdbDataSNMenu.add(item1);
       item1.addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
               TestSelection testSelection = guiControl.tablesDisplayPane.getTestSelection();
               if(testSelection==null)  {
                       javax.swing.JOptionPane.showMessageDialog(null,"No data selected.");
                       return;
                       }
               String resultObject= (testSelection.isSCTDBRodDaqData()) ? testSelection.getSCTDBRodDaqObjectHeader()+getSelectedSerialNo() : testSelection.getSCTDBObjectHeader()+getSelectedSerialNo();
               if(!Sct.IS.SctNames.getISRepository().contains(resultObject)) {
                  javax.swing.JOptionPane.showMessageDialog(null,"No data for "+getSelectedSerialNo());
                  return;
                  }
               SCTDB_Data result = new SCTDB_Data(); 
               Sct.IS.SctNames.getISRepository().getValue(resultObject, result); 
               ProdDatabase.ReportDownloader d = new ProdDatabase.ReportDownloader(guiUtilities.HTMLViewer.SCTDAQTESTDATA, result.testNumber, 0);
               if(d.isOkToStart()) d.start();
             }

          });  
       item1 = new JMenuItem("Full Module Report");
       item1.setFont(menuFont);
       sctdbDataSNMenu.add(item1);
       item1.addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
             String sn = getSelectedSerialNo();
             ProdDatabase.ReportDownloader d = new ProdDatabase.ReportDownloader(guiUtilities.HTMLViewer.MODULESUMMARY,sn,0);
             if(d.isOkToStart()) d.start();
             }

          });  


       }

//**************************************************************************
    private void getTableDataSNMenu() {
       dataManagerSNMenu = new JMenu("Data Manager");
       dataManagerSNMenu.setFont(menuFont);

       JMenuItem item = new JMenuItem("Plot Selected Data");
       item.setFont(menuFont);
       item.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                    switch(guiControl.displayStatus.getStatus()) {
                       case DisplayStatus.IS_MONITOR:
                          String objectname;
                          if((objectname = guiControl.tablesDisplayPane.getSelectedObject())!=null) guiControl.isInterface.launchExternalViewer(objectname);
                          else javax.swing.JOptionPane.showMessageDialog(null,"No plot data available.");
                        break;
                    default:
                     }                                   
                 }
             });
       dataManagerSNMenu.add(item);



       item = new JMenuItem("View Selected IS Object");
       item.setFont(menuFont);
       item.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                    switch(guiControl.displayStatus.getStatus()) {
                       case DisplayStatus.IS_MONITOR:
                          String objectname;
                          if((objectname = guiControl.tablesDisplayPane.getSelectedObject())!=null) guiControl.isInterface.viewISData(objectname);
                          else javax.swing.JOptionPane.showMessageDialog(null,"No data available.");
                        break;
                    default:
                     }                                   
                 }
             });

       dataManagerSNMenu.add(item);
       item = new JMenuItem("View Module Configuration");
       item.setFont(menuFont);
       item.addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
            JFrame frame2 = new JFrame("Module Configuration");                    
            frame2.getContentPane().add(new GuiComponents.Panels.ModuleConfigurationPanel(getSelectedSerialNo()));
            frame2.pack();
            frame2.show();
                     }

          });  
       dataManagerSNMenu.add(item);
       }

      private JMenu getDisplayMenu() {
       JMenu menu = new JMenu("Display");
       menu.setBackground(backgroundColor);
       menu.setFont(menuFont);
       menu.setForeground(menuColor);

       JMenuItem item;
       for(int i=1;i<DisplayStatus.statusNames.length;i++) {
          item = new JMenuItem(DisplayStatus.statusNames[i]);
          item.setFont(menuFont);
          switch(i) {
             case DisplayStatus.MODULE_GROUP_SELECTION:  // ModuleGroup Selection
             item.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                   guiControl.displayStatus.setModuleGroupSelectionMode();  
                   updateToolBar(DisplayStatus.MODULE_GROUP_SELECTION);           
                     }
             });
             break;
             case DisplayStatus.IS_MONITOR:  // Data Manager
             item.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                   guiControl.displayStatus.setISMode(); 
                   updateToolBar(DisplayStatus.IS_MONITOR);           
                     }
             });
             break;
             case DisplayStatus.TEST_DATA:   // Test Results
             item.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                    guiControl.displayStatus.setTestDataMode(-1);   
                   updateToolBar(DisplayStatus.TEST_DATA);           
                     }
             });
             break;
             case DisplayStatus.SCTDB_DATA:    // SCTDB Data
             item.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                     guiControl.displayStatus.setSCTDBDataMode(-1);  
                     updateToolBar(DisplayStatus.SCTDB_DATA);         
                     }
             });
             break;
             case DisplayStatus.DCS_DATA:    // DCS Data
             item.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                     guiControl.displayStatus.setDCSDataMode();  
                     updateToolBar(DisplayStatus.DCS_DATA);         
                     }
             });
             break;
            case DisplayStatus.SCTDB_RODDAQ_DATA:    // SctRodDaq Archive Data
             item.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                     guiControl.displayStatus.setSCTDBRodDaqMode(-1);  
                     updateToolBar(DisplayStatus.SCTDB_RODDAQ_DATA);         
                     }
             });
             break;
            case DisplayStatus.IV_DATA:    // SctRodDaq Archive Data
             item.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                    String ivdirectory = PreferencesInterface.getInstance().getPreference(PreferencesInterface.IV_DIRECTORY);
                    if(ivdirectory.equals(PreferencesInterface.unDefinedString)) javax.swing.JOptionPane.showMessageDialog(null,"You have not defined the IV data directory. You need to do this before importing IV scan data.");                        
                     guiControl.displayStatus.setIVDataMode();  
                     updateToolBar(DisplayStatus.IV_DATA);         
                     }
             });
             break;
             default:
             }
          menu.add(item);

          }
          return menu;
      }

   private void plotIVScanData(String serialNo) {
                   IVTestSelection ivTestSelection = guiControl.tablesDisplayPane.getIVTestSelection();
                   if(ivTestSelection==null) {
                       javax.swing.JOptionPane.showMessageDialog(null,"No IV Scan selected.");
                       return;
                       }
                   String summary = "IV Scan Plots for Run "+Integer.toString(ivTestSelection.getRunNo())+", Scan "+Integer.toString(ivTestSelection.getScanNo());
                   DisplayGUI.plotters.IVScansData ivScansData = new DisplayGUI.plotters.IVScansData(summary);
                   for(java.util.Enumeration e = ConfigurationInterface.getInstance().getSerialNumberMap(guiControl.displayPane.getSCTView()).elements(); e.hasMoreElements();) {
                       ModuleCell thisCell = (ModuleCell) e.nextElement();
                       String sn = thisCell.getSerialNo();
                       SummaryReader.IVData ivData = guiControl.isInterface.getIVData(ivTestSelection.getResultObjectHeader(),thisCell.getSerialNo());
                       if(ivData!=null) ivScansData.add(sn,ivData.getDataPointSet());
                       }
                    DisplayGUI.plotters.IVPlotDisplay ivPlotDisplay = new DisplayGUI.plotters.IVPlotDisplay();
                    ivPlotDisplay.showData(ivScansData,serialNo);
                    }


}
     
