/*
 * ArchiveQueryBox.java
 *
 * Created on 26 March 2004, 12:10
 */

package DisplayGUI;
import GuiComponents.System.*;

/**
 *
 * @author  robinson
 */
public class ArchiveQueryBox extends javax.swing.JFrame implements displayParams, TestDataInfo {
    

    private javax.swing.JLabel ScanLabel;
    private javax.swing.JButton closeButton;
    private javax.swing.JComboBox jComboBox1;
    private javax.swing.JTextField runField;
    private javax.swing.JTextField scanField;
    private javax.swing.JButton retrieveButton;
    private javax.swing.JLabel runLabel;
    private javax.swing.JLabel testLabel;
    private javax.swing.JLabel titleLabel;

    private gui guiControl;

    public ArchiveQueryBox(gui parent) {
        super("Archive Retrieval");
        guiControl=parent;
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        titleLabel = new javax.swing.JLabel();
        jComboBox1 = new javax.swing.JComboBox();
        testLabel = new javax.swing.JLabel();
        runField = new javax.swing.JTextField(5);
        scanField = new javax.swing.JTextField(5);
        runLabel = new javax.swing.JLabel();
        ScanLabel = new javax.swing.JLabel();
        retrieveButton = new javax.swing.JButton();
        closeButton = new javax.swing.JButton();

        jComboBox1.setBackground(backgroundColor);
        jComboBox1.setFont(displayScaleFont);
        jComboBox1.addItem("Any");
        for(int i=0;i<testNames.length;i++) {
           if(!testIsDefined[i]) continue;
           jComboBox1.addItem(testNames[i]);
           }

        getContentPane().setLayout(new java.awt.GridBagLayout());
        getContentPane().setBackground(backgroundColor);

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        titleLabel.setText("Retrieve Archived Data");
        titleLabel.setFont(displayBoldFont);
        titleLabel.setForeground(darkBlueColor);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        gridBagConstraints.weighty = 0.2;
        getContentPane().add(titleLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 0.7;
        gridBagConstraints.weighty = 0.2;
        getContentPane().add(jComboBox1, gridBagConstraints);

        testLabel.setText("Test: ");
        testLabel.setFont(displayScaleFont);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 0.3;
        getContentPane().add(testLabel, gridBagConstraints);

        runField.setText("*");
        runField.setFont(displayScaleFont);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weighty = 0.2;
        getContentPane().add(runField, gridBagConstraints);

        scanField.setText("*");
        scanField.setFont(displayScaleFont);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weighty = 0.2;
        getContentPane().add(scanField, gridBagConstraints);

        runLabel.setText("Run:");
        runLabel.setFont(displayScaleFont);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(runLabel, gridBagConstraints);

        ScanLabel.setText("Scan:");
        ScanLabel.setFont(displayScaleFont);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(ScanLabel, gridBagConstraints);

        retrieveButton.setText("Retrieve Data");
        retrieveButton.setFont(displayScaleFont);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
        getContentPane().add(retrieveButton, gridBagConstraints);
        retrieveButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
              String runNo= runField.getText();
              String scanNo = scanField.getText();

              if(!runNo.matches("\\*|\\d+")) {javax.swing.JOptionPane.showMessageDialog(null,"Run Number must be a number or '*'");return;}
              if(!scanNo.matches("\\*|\\d+")) {javax.swing.JOptionPane.showMessageDialog(null,"Scan Number must be a number or '*'");return;}
 
              String testType = (String)jComboBox1.getSelectedItem();
              if(testType.equals("Any")) testType="*";

              ArchivingServiceI.ArchivingServiceInterface a = SystemInterface.getInstance().getArchivingService();    
//              System.out.println("retrieve("+runNo+","+scanNo+",\"TestData\","+testType);
              try {
                a.retrieve(runNo,scanNo,"TestData",testType);
//                a.retrieve(runNo,scanNo,"SctData::RawScanResult","*");
              }catch(Exception e) {System.err.println("SctGUI::ArchiveQueryBox - Exception from ArchiveService: "+e.toString());}

            }
        });

        closeButton.setText("Close");
        closeButton.setFont(displayScaleFont);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHEAST;
        gridBagConstraints.weighty = 0.2;
        getContentPane().add(closeButton, gridBagConstraints);
        closeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                exitForm(null);
            }
        });

        pack();

    }
    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {
       setVisible(false);
       dispose();
    }
    


    
    

    
}
