#include <iostream> 
#include <list>
#include <memory>

#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

using namespace std;

//  Try to get rid of all these!!!
//      valgrind --leak-check=yes --show-reachable=yes --num-callers=10 ./doAll

#include "configXMLImpl.h"
using namespace SctConfiguration;

int main() {
  std::auto_ptr<SctConfiguration::Configuration> conf(new ConfigurationXMLImpl);

  SctConfiguration::Configuration &config=*conf;

  cout << "InitialiseAll\n";

  unsigned int totalPartitions = 0;
  unsigned int totalCrates = 0;
  unsigned int totalRods = 0;
  unsigned int totalModules = 0;

  try {
    list<unsigned int> partitions = config.listPartitions();

    for(list<unsigned int>::const_iterator p=partitions.begin();
        p!=partitions.end(); 
        p++) {
      cout << "Partition " << *p << endl;
      list<unsigned int> crates = config.listCratesInPartition(*p);

      for(list<unsigned int>::const_iterator c=crates.begin(); 
          c!=crates.end(); 
          c++) {
        //      crateMap.insert(make_pair(make_pair(*p, *c), new Crate(*p, *c)));
        cout << "Crate " << *c << endl;

        try {
          TimConfig tConf = config.getTimConfig(*p, *c);

          cout << "TIM: \n";
          cout << "baseAddress 0x" << hex << tConf.baseAddress << dec << endl;
        } catch(ConfigurationException &cx) {
          cout << "No TIM configuration for crate " << *p << " " << *c << endl;
        }

        list<unsigned int> rods = config.listRodsInCrate(*p, *c);

        for(list<unsigned int>::const_iterator r=rods.begin(); 
            r!=rods.end(); 
            r++) {
          cout << "ROD " << *r << endl;
          cout << "getRodConfig (" << *p << ", " << *c << ", " << *r << ");\n";
          RodConfig rodConf = config.getRodConfig(*p, *c, *r);

          cout << "BaseAddress 0x" << hex << rodConf.baseAddress << dec << endl;
          cout << "Slave 0: " << rodConf.slaves[0].idramFile << endl;

          {
            struct stat statBuf;
            int ret = stat(rodConf.slaves[0].idramFile.c_str(), &statBuf);
            if(ret)
              perror("Error stating idramFile");
          }

          totalRods ++;
          list<unsigned int> MURs = config.listMURSInRod(*p, *c, *r);

          for(list<unsigned int>::const_iterator mur=MURs.begin(); 
              mur!=MURs.end(); 
              mur++) {
            cout << "MUR " << *mur << endl;
            list<string> modules = config.listModulesInMUR(*p, *mur);

            for(list<string>::const_iterator m=modules.begin(); 
                m!=modules.end(); 
                m++) {
              cout << "Module " << *m << " ";

              try {
                // ROD
                unsigned int partition, crate, rod, channel;

                // MUR
                unsigned int MUR, module;

                // Serial number
                std::string sn;

                // Barrel format
                unsigned int barrel, row;
                int number;

                cout << "Found in partition " << *p << " " 
                     << "crate " << *c << " " 
                     << "rod " << *r << endl;

                cout << "FromSN: ";
                config.translateFromSN(*m, MUR, module);
                cout << "Got MUR = " << MUR << " and module = " << module << endl;

                int group = config.getModuleGroup(*m);
                cout << "Got module group = " << group << endl;

                cout << "To ROD: ";
                config.translateToROD(MUR, module, partition, crate, rod, channel);
                cout << "partition " << partition << " " 
                     << "crate " << crate << " " 
                     << "rod " << rod << " " 
                     << "channel " << channel << endl;

                cout << "To SN: ";
                config.translateToSN(MUR, module, sn);
                cout << "Serial number got back is: " << sn << endl;

                MUR = 100000;
                module = 100;

                cout << "FromROD: ";
                config.translateFromROD(partition, crate, rod, channel, MUR, module);
                cout << "Got MUR = " << MUR << " and module = " << module << endl;

                cout << "BOCConfig:\n";
                try {
                  BOCChannelConfig bocConf = config.getBOCConfig(*p, *c, *r, channel);
                  cout << " BOC: laser " << bocConf.current << " Delay " << bocConf.delay << " markspace " << bocConf.markSpace << endl;
                  cout << " BOC: 0 threshold " << bocConf.threshold0 << " delay " << bocConf.delay0 << endl;
                  cout << " BOC: 1 threshold " << bocConf.threshold1 << " delay " << bocConf.delay1 << endl;
                } catch(ConfigurationException &c) {
                  cout << "^ Unknown!\n";
                }

                try {
                  barrel = 100, row = 100;
                  number = 100;
                  cout << "ToBarrel: ";
                  config.translateToBarrel(MUR, module, barrel, row, number);
                  cout << "barrel " << barrel << " row " << row << " number " << number << endl;
                } catch(ConfigurationException &c) {
                  cout << "^ Not barrel\n";
                }

                try {
                  partition = 100;
                  crate = 100;
                  rod = 100;
                  channel = 100;
                  cout << "To Redundant Rod: ";
                  config.translateToRROD(MUR, module, partition, crate, rod, channel);
                  cout << "partition " << partition << " " 
                       << "crate " << crate << " " 
                       << "rod " << rod << " " 
                       << "channel " << channel << endl;

                  cout << "From Redundant Rod: ";
                  config.translateFromRROD(partition, crate, rod, channel, MUR, module);
                  cout << "MUR " << MUR << " " << "module " << module << endl;
                } catch(ConfigurationException &c) {
                  cout << "^ No redundant Rod mapping\n";
                }

                // Power supply
                unsigned int ppartition, pcrate, pchannel;

                cout << "To Power Supply: ";
                try {
                  config.translateToPowerSupply(MUR, module, ppartition, pcrate, pchannel);
                  cout << "Partition " << ppartition << " "
                       << "crate " << pcrate << " "
                       << "channel " << pchannel << endl;

                  cout << "From Power Supply: ";
                  config.translateFromPowerSupply(ppartition, pcrate, pchannel, MUR, module);
                  cout << "MUR " << MUR << " module " << module << endl;

                  cout << "Power Supply params: ";
                  cout << " Vcc" << config.getPowerParam(MUR, module, "ON", "LVch_Vcc", "value")
                       << " Vdd" << config.getPowerParam(MUR, module, "ON", "LVch_Vdd", "value") << endl;
                } catch(ConfigurationException &c) {
                  cout << "\n^ No power supply mapping... " << c.what() << "\n";
                }
              } catch(ConfigurationException &c) {
                cout << "\n^^^^^^ Exception doing tests on module translation\n -> " << c.what() << "\n";
              } 

              try {
                cout << "Module configuration for " << *m << ":\n";
                ABCDModule configuration = config.getModuleConfig(*m);
                cout << " Found module configuration\n";
                config.printModuleConfig(configuration);

                cout << " Get module string\n";
                cout << config.getModuleConfigurationString(*m, configuration).length() << endl;
                cout << config.getModuleConfigurationString(*m, configuration) << endl;
              } catch(ConfigurationException &c) {
                cout << "^ No Module configuration found " << c.what() << "\n";
              }

              totalModules ++;
            }

            try {
              list<string> rmodules = config.listRModulesInMUR(*p, *mur);
              cout << "Redundant Modules ";
              for(list<string>::const_iterator m=rmodules.begin(); 
                  m!=rmodules.end(); 
                  m++) {
                cout << *m << " ";
              }
              cout << endl;
            } catch(ConfigurationException &e) {
              cerr << "^^^ No redundant module information\n";
            }
          }

          cout << "Get BOC Mappings\n";
          char *mappings = config.getFibreMappings(*p, *c, *r);

          for(int i=0; i<48; i++) {
            for(int c=0; c<3; c++) {
              cout.width(2);
              cout.fill('0');
              cout << ((int)mappings[i*3 + c]) << (c==2?" ":",");
            }
            if(i%12 == 11) cout << endl;
          }
          cout.fill(' ');

          delete [] mappings;
          cout << "\nBOC Mappings got\n";
        }
        totalCrates++;
      }
      totalPartitions ++;
    }

    cout << "*** All modules ***\n";

    list<string> modules = config.listAllModules();

    for(list<string>::const_iterator m=modules.begin(); 
        m!=modules.end(); 
        m++) {
      cout << "Module " << *m << endl;
    }


    cout << "*** Unused modules ***\n";
    
    list<string> uModules = config.listUnusedModules();

    for(list<string>::const_iterator m=uModules.begin(); 
        m!=uModules.end(); 
        m++) {
      cout << "Module " << *m << endl;
    }
  } catch(ConfigurationException &c) {
    cout << "Bad configuration somewhere " << c.what() << "\n"; 
  }

  cout << "*** Initialisation counts ***\n";
  cout << "\ttotalPartitions: " << totalPartitions << endl;
  cout << "\ttotalCrates: " << totalCrates << endl;
  cout << "\ttotalRods: " << totalRods << endl;
  cout << "\ttotalModules: " << totalModules << endl;
}
