/*
 * ISHistogram1DAdapter.java
 *
 * Created on 27 November 2002, 12:18
 */

package oh.aida;

import oh.*;
import hep.aida.*;

/**
 *
 * @author  palmer
 */
public class ISHistogram1DAdapter extends ISHistogramAdapter implements hep.aida.IHistogram1D {
    
    /** Creates a new instance of ISHistogram1DAdapter */
    public ISHistogram1DAdapter(ISHistogram1D data) {
        super(data);
    }
       
    public void add(hep.aida.IHistogram1D iHistogram1D) throws java.lang.IllegalArgumentException {
        unimplementedFunction();
    }
    
    public hep.aida.IAxis axis() {
        return new AxisAdapter(0);
    }
    
    public int binEntries(int param) throws java.lang.IllegalArgumentException {
        return 0;
    }
    
    public double binError(int param) throws java.lang.IllegalArgumentException {
        return _binError(index(param));
    } 
    
    public double binHeight(int param) throws java.lang.IllegalArgumentException {
        return _binHeight(index(param));
    }
    
    public double binMean(int param) throws java.lang.IllegalArgumentException {
        return 0;
    }
    
    public int coordToIndex(double param) {
        return axis().coordToIndex(param);
    }
    
    public void fill(double param) throws java.lang.IllegalArgumentException {
        unimplementedFunction();
    }
    
    public void fill(double param, double param1) throws java.lang.IllegalArgumentException {
        unimplementedFunction();
    }
    
    public double mean() {
        return ((ISHistogram1D)data).is_xmean;
    }
    
    public double rms() {
        return ((ISHistogram1D)data).is_xrms;
    }
    
    /**
     * Helpful functions
     */
    
    /**
     * Returns the index into the bins array.  Need to add 1 to most indexes because
     * bin 0 is the underflow
     */
    protected int index(int indexX)  {
        int bcx = axis().bins();
        if ( indexX == IAxis.OVERFLOW_BIN ) indexX = bcx + 1;
        else if ( indexX == IAxis.UNDERFLOW_BIN ) indexX = 0;
        else indexX++;
        
        return indexX;
    }
    
}
