/*
 * ISHistogram.java
 *
 * Created on 27 November 2002, 12:24
 */

package oh;

/**
 *
 * @author  palmer
 */
public abstract class ISHistogram extends is.Info {
    public static final int IS_FIXED = 0;
    public static final int IS_VARIABLE = 1;

    /**
     * Histogram title
     */
    public String              is_title;

    /**
     * Annotations
     */
    public String[]            is_annotations;    
    
    /**
     * Axes
     */
    public ISAxis[]             is_axis;
    
    /**
     * Bin values
     */
    public double[]            is_bins;

    /**
     * Optional error values for the bins
     */
    public double[]            is_errors;

    /**
     * Optional pluserror values for the bins
     */
    public double[]            is_pluserrors;

    /**
     * Optional minuserror values for the bins
     */
    public double[]            is_minuserrors;
    
    protected ISHistogram( String type ) {
    	super( type );
    }
    
    public void publishGuts( is.Ostream out ) {
        if (is_axis == null) initialize();
        super.publishGuts( out );
        out.put( is_title ).put( is_annotations );
        for (int i=0; i<is_axis.length; i++) is_axis[i].publishGuts(out);
        out.put( is_bins ).put( is_errors ).put( is_pluserrors ).put( is_minuserrors );
    }
    
    public void refreshGuts( is.Istream in ){
        super.refreshGuts( in );
        is_title = in.getString( );
        is_annotations = in.getStringArray( );
        for (int i=0; i<is_axis.length; i++) is_axis[i].refreshGuts(in);
        is_bins = in.getDoubleArray( );
        is_errors = in.getDoubleArray( );
        is_pluserrors = in.getDoubleArray( );
        is_minuserrors = in.getDoubleArray( );
    }
    
    /**
     * Called if the axis is null
     */
    protected void initialize() {
    }
    
}    
    
