package is;

import java.sql.Time;
import java.sql.Date;
import java.util.StringTokenizer;

/**
 * Istream provides interface for unmarshalling attributes of the 
 * user-defined information class from the IS stream.
 * @author Sergei Kolos
 */
public class Istream
{
    private StringTokenizer    st;
    private String    data;
    private String    name;
    
    Istream( String data )
    {
	this.data = data;
	st = new StringTokenizer( this.data, "\n" );
    
	String token = st.nextToken();
	name = token.substring( token.indexOf( "\" i=\"" ) + 5, token.lastIndexOf( "\"" ) );
    }
    
    String getData( )
    {
	return data;
    }
    
    String readName( )
    {
	return name;
    }

    /**
     * Reads a single boolean value from this stream.
     * @return boolean value read form this stream
     */
    public boolean getBoolean()
    {
	String token = st.nextToken();
	String val = token.substring( token.indexOf( ">" ) + 1, token.lastIndexOf( "<" ) );
    
	int i = Integer.parseInt( val );
	return ( i == 0 ? false : true );
    }
    
    /**
     * Reads a single byte value from this stream.
     * @return byte value read form this stream
     */
    public byte getByte()
    {
	String token = st.nextToken();
	String val = token.substring( token.indexOf( ">" ) + 1, token.lastIndexOf( "<" ) );
    
	return Byte.parseByte( val );
    }
    
    /**
     * Reads a single short value from this stream.
     * @return short value read form this stream
     */
    public short getShort( )
    {
	String token = st.nextToken();
	String val = token.substring( token.indexOf( ">" ) + 1, token.lastIndexOf( "<" ) );
    
	return Short.parseShort( val );
    }
    
    /**
     * Reads a single int value from this stream.
     * @return int value read form this stream
     */
    public int getInt( )
    {
	String token = st.nextToken();
	String val = token.substring( token.indexOf( ">" ) + 1, token.lastIndexOf( "<" ) );
    
	return Integer.parseInt( val );
    }
    
    /**
     * Reads a single float value from this stream.
     * @return float value read form this stream
     */
    public float getFloat()
    {
	String token = st.nextToken();
	String val = token.substring( token.indexOf( ">" ) + 1, token.lastIndexOf( "<" ) );
    
	return Float.parseFloat( val );
    }
    
    /**
     * Reads a single double value from this stream.
     * @return double value read form this stream
     */
    public double getDouble()
    {
	String token = st.nextToken();
	String val = token.substring( token.indexOf( ">" ) + 1, token.lastIndexOf( "<" ) );
    
	return Double.parseDouble( val );
    }
    
    /**
     * Reads a single string value from this stream.
     * @return String value read form this stream
     */
    public String getString()
    {
	String token = st.nextToken();
	StringBuffer buffer = new StringBuffer(token);
	while( !token.endsWith( "</a>") )
	{
		token = st.nextToken();
		buffer.append("\n" + token);
	}
	String val = buffer.substring( buffer.indexOf( ">" ) + 1, buffer.lastIndexOf( "<" ) );
	return Util.invalidate( val );
    }
    
    /**
     * Reads a single date value from this stream.
     * @return Date value read form this stream
     */
    public Date getDate()
    {
	String token = st.nextToken();
	String val = token.substring( token.indexOf( ">" ) + 1, token.lastIndexOf( "<" ) );
    
	return new Date( Long.parseLong( val ) * 1000 );
    }

    /**
     * Reads a single time value from this stream.
     * @return Time value read form this stream
     */
    public Time getTime()
    {
	String token = st.nextToken();
	String val = token.substring( token.indexOf( ">" ) + 1, token.lastIndexOf( "<" ) );
    
	return new Time( Long.parseLong( val ) * 1000 );
    }

    /**
     * Reads an array of boolean values from this stream.
     * @return array of booleans read form this stream
     */
    public boolean[] getBooleanArray( )
    {
	String token = st.nextToken();
	int size = Integer.parseInt ( token.substring( token.indexOf( "s=\"" ) + 3, token.lastIndexOf( "\"" ) ) );
    
	boolean array[] = new boolean[size];
	StringTokenizer val = new StringTokenizer ( token.substring( token.indexOf( ">" ) + 1, token.lastIndexOf( "<" ) ) );

	for( int i = 0; i < size; i++ )
	{
		int b = Integer.parseInt( val.nextToken() );
		array[i] = ( b == 0 ? false : true );
	}
	return array;
    }
    
    /**
     * Reads an array of byte values from this stream.
     * @return array of bytes read form this stream
     */
    public byte[] getByteArray( )
    {
	String token = st.nextToken();
	int size = Integer.parseInt ( token.substring( token.indexOf( "s=\"" ) + 3, token.lastIndexOf( "\"" ) ) );
    
	byte array[] = new byte[size];
	StringTokenizer val = new StringTokenizer ( token.substring( token.indexOf( ">" ) + 1, token.lastIndexOf( "<" ) ) );

	for( int i = 0; i < size; i++ )
	{
		array[i] = Byte.parseByte( val.nextToken() );
	}
	return array;
    }
    
    /**
     * Reads an array of short values from this stream.
     * @return array of shorts read form this stream
     */
    public short[] getShortArray( )
    {
	String token = st.nextToken();
	int size = Integer.parseInt ( token.substring( token.indexOf( "s=\"" ) + 3, token.lastIndexOf( "\"" ) ) );
    
	short array[] = new short[size];
	StringTokenizer val = new StringTokenizer ( token.substring( token.indexOf( ">" ) + 1, token.lastIndexOf( "<" ) ) );

	for( int i = 0; i < size; i++ )
	{
		array[i] = Short.parseShort( val.nextToken() );
	}
	return array;
    }
    
    /**
     * Reads an array of int values from this stream.
     * @return array of ints read form this stream
     */
    public int[] getIntArray( )
    {
	String token = st.nextToken();
	int size = Integer.parseInt ( token.substring( token.indexOf( "s=\"" ) + 3, token.lastIndexOf( "\"" ) ) );
    
	int array[] = new int[size];
	StringTokenizer val = new StringTokenizer ( token.substring( token.indexOf( ">" ) + 1, token.lastIndexOf( "<" ) ) );

	for( int i = 0; i < size; i++ )
	{
		array[i] = Integer.parseInt( val.nextToken() );
	}
	return array;
    }
    
    /**
     * Reads an array of float values from this stream.
     * @return array of floats read form this stream
     */
    public float[] getFloatArray( )
    {
	String token = st.nextToken();
	int size = Integer.parseInt ( token.substring( token.indexOf( "s=\"" ) + 3, token.lastIndexOf( "\"" ) ) );
    
	float array[] = new float[size];
	StringTokenizer val = new StringTokenizer ( token.substring( token.indexOf( ">" ) + 1, token.lastIndexOf( "<" ) ) );

	for( int i = 0; i < size; i++ )
	{
		array[i] = Float.parseFloat( val.nextToken() );
	}
	return array;
    }
    
    /**
     * Reads an array of double values from this stream.
     * @return array of doubles read form this stream
     */
    public double[] getDoubleArray( )
    {
	String token = st.nextToken();
	int size = Integer.parseInt ( token.substring( token.indexOf( "s=\"" ) + 3, token.lastIndexOf( "\"" ) ) );
    
	double array[] = new double[size];
	StringTokenizer val = new StringTokenizer ( token.substring( token.indexOf( ">" ) + 1, token.lastIndexOf( "<" ) ) );

	for( int i = 0; i < size; i++ )
	{
		array[i] = Double.parseDouble( val.nextToken() );
	}
	return array;
    }
    
    /**
     * Reads an array of string values from this stream.
     * @return array of Strings read form this stream
     */
    public String[] getStringArray( )
    {
	String token = st.nextToken();
	StringBuffer buffer = new StringBuffer(token);
	while( !token.endsWith( "</a>") )
	{
		token = st.nextToken();
		buffer.append("\n" + token);
	}
	int start = buffer.indexOf( "s=\"" ) + 3;
	int end = buffer.indexOf( "\"", start );
	int size = Integer.parseInt ( buffer.substring( start, end ) );
    
	String array[] = new String[size];
	String values = buffer.substring( buffer.indexOf( ">" ) + 1, buffer.lastIndexOf( "<" ) );

	start = 0;
	for( int i = 0; i < size; i++ )
	{
		start = values.indexOf( "\"", start );
		start++;
		end = values.indexOf( "\"", start );
        
		array[i] = Util.invalidate( values.substring( start, end ) );
		start = end + 1;
	}
	return array;
    }
    
    /**
     * Reads an array of date values from this stream.
     * @return array of Dates read form this stream
     */
    public Date[] getDateArray( )
    {
	String token = st.nextToken();
	int size = Integer.parseInt ( token.substring( token.indexOf( "s=\"" ) + 3, token.lastIndexOf( "\"" ) ) );
    
	Date array[] = new Date[size];
	StringTokenizer val = new StringTokenizer ( token.substring( token.indexOf( ">" ) + 1, token.lastIndexOf( "<" ) ) );

	String date;
	for( int i = 0; i < size; i++ )
	{
		array[i] = new Date( Long.parseLong( val.nextToken() ) * 1000 );
	}
	return array;
    }
    
    /**
     * Reads an array of time values from this stream.
     * @return array of Times read form this stream
     */
    public Time[] getTimeArray( )
    {
	String token = st.nextToken();
	int size = Integer.parseInt ( token.substring( token.indexOf( "s=\"" ) + 3, token.lastIndexOf( "\"" ) ) );
    
	Time array[] = new Time[size];
	StringTokenizer val = new StringTokenizer ( token.substring( token.indexOf( ">" ) + 1, token.lastIndexOf( "<" ) ) );

	for( int i = 0; i < size; i++ )
	{
		array[i] = new Time( Long.parseLong( val.nextToken() ) * 1000 );        
	}
	return array;
    }
}
