#include <TH1.h>
#include <TH2.h>
#include "SctData/RawScanResult.h"
#include "SctData/ModuleConfiguration.h"
#include "SctData/ScanPoints.h"
#include "SctData/ScanHeader.h"
#include "SctData/mVThresholdVariable.h"
#include "Sct/SctNames.h"
#include "Sct/IS/IOManagerIS.h"
#include <iostream>

using namespace SctData;
using namespace Sct;
using namespace Sct::IS;

/**
 * This is a simple test program that creates a RawScanResult object and publishes it to an IS server.
 * The API is very likely to change and this may become obsolete quickly.
 */
int main(int argc, char** argv) {
	//RawScanResult owns its scans..must be newed
	TH2D* scan0 = new TH2D("Scan0","Scan",768,-3,3, 64, 0, 3);
    scan0->FillRandom("gaus",10000);	
	TH2D* scan1 = new TH2D("Scan1","Scan",768,-3,3, 64, 0, 3);
    scan1->FillRandom("gaus",10000);	

	cout << "Created hists" << endl;

	//Create the scanheader
	ScanHeader s(100, 1000, "TestSubmit", mVThresholdVariable::instance());

	cout << "Created scan" << endl;

	//Create the module configuration
	ModuleConfiguration m;
	
	cout << "Created module config" << endl;

	ScanPoints pts;
	for (int i=0; i<64; ++i) {
		pts.addPoint(i, 10000, 0);
	}
	
	//Create a RawRODData object
	RawScanResult r(s, m, pts, *scan0, *scan1);

	cout << "Created RawScanResult" << endl;
	
	IOManagerIS::instance().write(r);
	
	//All done!  Quit...
	cout << "All done!" << endl;
	return 0;
}
