#include "ArchTestResult.h"
#include <TFile.h>
#include <TKey.h>
#include <TDirectory.h>
#include <TSystem.h>
#include <TNamed.h>
#include <TObject.h>
#include <TObjArray.h>
#include <TString.h>
#include <TObjString.h>
#include <TVector.h>
#include <TVectorD.h>
#include <TH1.h>
#include <TH2.h>
#include <TCanvas.h>
#include <TROOT.h>
#include <is/isinfo.h>
#include <iostream>
#include <vector>
#include <boost/shared_ptr.hpp>
#include <iomanip>
#include <fstream>
#include <iostream>
//#include "Sct/shared_ptr_utility.h"
#include "ArchivingManager.h"
#include "ArchModuleDefects.h"

using namespace SctData;
using namespace Sct;
using namespace boost;
using boost::shared_ptr;



//Global Variables:
//TFile *storage_file = new TFile();



/********************************** ArchTestResult Methods Definitions ************************/


/***********************  Constructor  *************** */

ArchTestResult::ArchTestResult(): Archiving()  {

  cout<< "I am in the ArchTestResult Default Constructor"<< endl;
  runNumber = 0;
  moduleName = "0";
  NScans = 0; 
  names = new ArchTestNames();
  //names->SetTestType(testType);
  testSummary = NULL;
}
  
  
ArchTestResult::ArchTestResult(shared_ptr<TestResult> test): Archiving()  {

  cout<< "I am in the ArchTestResult Constructor"<< endl;
  

  /*--- Initialisation ---*/

  
  runNumber = test->getRunNumber();
  moduleName = test->getModuleName();
  NScans = test->getNScans();
  names = new ArchTestNames(runNumber, moduleName,test->getClassName());
  testType = names->getTestType();
  
  for (unsigned int i=0; i<NScans; i++) {
    scanNumbers.push_back(test->getScanNumberAt(i));
  }

  
  defects = test->getDefects().getAllDefects();
  //defects = DeleteRepetedDefects( test->getDefects().getAllDefects() );  //Apparently there are no repetitions
  
  

  
  testSummary = NULL; //It is filled in each single *TestResult sub-class


}








/**********************  Other Member Functions  *********************/

ArchTestResult::~ArchTestResult()  {
  
  //cout << "I am in the ArchTestResult destructor" << endl;
  

  
}



void ArchTestResult::SaveRawScans()  {
  
  cout << "Saving RawScans " << endl;
  //TO DO : Save time and date of first and last saving

  
  
  for (vector<shared_ptr<RawScanResult> >::iterator i = rawScans.begin(); i!=rawScans.end(); i++) {
    
    shared_ptr<RawScanResult> raw = *i;
    
    shared_ptr<ArchScanResult> myScanArchiving = ArchivingManager::instance().getScanFromMap(raw);
    shared_ptr<ArchScanResult> cloned_scan = myScanArchiving->clone(raw);
    
    cloned_scan->SetTestType(testType);
    cloned_scan->Save();
  
  }
  

  
  
}



void ArchTestResult::SaveFitScans()  {
  
  cout << "Saving FitScans " << endl;
  //TO DO : Save time and date of first and last saving
 
  for (vector<shared_ptr<FitScanResult> >::iterator i = fitScans.begin(); i!=fitScans.end(); i++) {
    shared_ptr<FitScanResult> fit = *i; 
    shared_ptr<ArchScanResult> myScanArchiving = ArchivingManager::instance().getScanFromMap(fit);
    shared_ptr<ArchScanResult> cloned_scan = myScanArchiving->clone(fit);
    
    cloned_scan->SetTestType(testType);
    cloned_scan->Save();


  }
 
  
}


vector<shared_ptr<const ModuleDefect> > ArchTestResult::DeleteRepetedDefects( vector<shared_ptr<const ModuleDefect> >  tmp_defects ) {
  //cout<<"     I am in DeleteRepetedDefects " <<endl;
  vector<shared_ptr<const ModuleDefect> > skimmedDefects;  
  vector<shared_ptr<const ModuleDefect> >::iterator ibegin=tmp_defects.begin();
  shared_ptr<const ModuleDefect> tmp_mydefect = *ibegin;
  skimmedDefects.push_back(tmp_mydefect);

  //cout<<" tmp_defects.size() = "<<tmp_defects.size() << endl;
  
  for (unsigned int i=0; i<tmp_defects.size(); ++i) { 
    
      //cout<<" i = "<< i << endl;
      string Name = tmp_defects[i]->getName();
      double first = tmp_defects[i]->getModuleElement().getFirst();
      double Nchannels = tmp_defects[i]->getModuleElement().getNChannels();
      double chipDefect = tmp_defects[i]->isChipDefect();
      double linkDefect = tmp_defects[i]->isLinkDefect();
      double unfittable = tmp_defects[i]->isUnfittable();
      double unusable = tmp_defects[i]->isUnuseable();
      double dodgy = tmp_defects[i]->isDodgy();
      //cout << "tmp_defects = "<<first<<" "<< Nchannels<<" "<<chipDefect<<" "<<linkDefect<<" "<<unfittable<<" "<<unusable<<" "<<dodgy<<endl; 
      
      bool defectToBeSaved = true;
      
      //for (unsigned int iSkimmed = tmp_defects.size()-1; iSkimmed >= 0 ; --iSkimmed){
      for (vector<shared_ptr<const ModuleDefect> >::iterator iSkimmed=skimmedDefects.begin();iSkimmed<skimmedDefects.end(); ++iSkimmed) {      
	 string skimmed_Name = (*iSkimmed)->getName();
         double skimmed_first = (*iSkimmed)->getModuleElement().getFirst();
	 double skimmed_Nchannels = (*iSkimmed)->getModuleElement().getNChannels();
	 double skimmed_chipDefect = (*iSkimmed)->isChipDefect();
	 double skimmed_linkDefect = (*iSkimmed)->isLinkDefect();
	 double skimmed_unfittable = (*iSkimmed)->isUnfittable();
	 double skimmed_unusable =(*iSkimmed)->isUnuseable();
	 double skimmed_dodgy = (*iSkimmed)->isDodgy();

     
      
	 //cout << "skimmed_defects = "<<skimmed_first<<" "<< skimmed_Nchannels<<" "<<skimmed_chipDefect<<" "<<skimmed_linkDefect<<" "<<skimmed_unfittable<<" "<<skimmed_unusable<<" "<<skimmed_dodgy<<endl; 
	 //cout<<" I am in iSkimmed..before break"<<endl;
	 
	 if (Name == skimmed_Name && 
	     first == skimmed_first &&  
	     Nchannels == skimmed_Nchannels && 
	     chipDefect == skimmed_chipDefect && 
	     linkDefect == skimmed_linkDefect &&
	     unfittable == skimmed_unfittable &&
	     unusable == skimmed_unusable &&
	     dodgy == skimmed_dodgy ) 
	   { 
	     //cout<<" I am IN break"<<endl; 
	     defectToBeSaved = false;
	     break; 
	   }
      
	 
      
       }
      
    
      if ( defectToBeSaved == true ) {
	skimmedDefects.push_back(tmp_defects[i]); 
	//cout<<" I am push_back"<<endl;
      }

       
  }


  
    return skimmedDefects;
    
}


void ArchTestResult::Save()  {
  
  cout<<" Saving TestData " << endl;
  
//TO DO : Save time and date of first and last saving  
  
  
  string filename = names->getfilename();
  string moduleID = names->getModuleID();
  string moduleDefectsID = names->getModuleDefectsID();
  string testType  = names->getTestType(); 
  string runID = names->getRunID();
  string DefectsID = names->getDefectsID();


  /* OPENING TEST FILE  */
  cout << "Opening file..."<<endl; 
 

  TFile *storage_file = new TFile(filename.c_str(),"update");
  //storage_file->ls();
  cout << "The file .root succesfully open"<<endl; 

  


  /* CREATING DIRECTORIES and SAVING DATA  */
  
    
    /* Making RunNumber   */
    //cout<<"I am making RunNumber Dir"<<endl;
    //storage_file->GetListOfKeys()->Print();
    TDirectory *this_run = (TDirectory*) gDirectory->Get(runID.c_str());
    //cout<<"The RUN is "<< runID <<endl;
    
    if (!this_run) {
      //cout<<"This NEW run "<< runID <<" doesn't exist"<<endl;
      this_run = storage_file->mkdir(runID.c_str());
      //cout<<"New RunNumber Dir made "<<endl;
    }
    //storage_file->GetListOfKeys()->Print();
    this_run->cd();  //make this_run the current directory
    
   
    /* Saving RunNumber as a TVector: it is saved only once, just the first time   */
    TObject* pers_runnumber = gDirectory->FindObjectAny(runID.c_str()); 
    if (!pers_runnumber) {
      double frunNumber = runNumber;
      TVector run(1,1,frunNumber, "END");
      run.Write(runID.c_str());
    }
    
    
    /* Making moduleNumber   */
    
    TDirectory* this_module = (TDirectory*) gDirectory->Get(moduleID.c_str()); //Can be made using FindAnyObject
    //cout<<"The MODULE is "<< moduleID <<endl;
    if (!this_module) {
      //cout<<"This NEW module "<< moduleID <<" doesn't exist"<<endl;
      this_module =gDirectory ->mkdir(moduleID.c_str());
    }
    this_module->cd();  //make this_module the current directory 


    /* Making ModuleDefects   */
    TDirectory* this_moduleDefects = (TDirectory*) gDirectory->Get(moduleDefectsID.c_str()); //Can be made using FindAnyObject
    if (!this_moduleDefects) {
      //cout<<"ModuleDefects doesn't exist"<<endl;
      this_moduleDefects =gDirectory ->mkdir(moduleDefectsID.c_str());
    }





    /* -----------------------------------   */
    /* -----  Saving ModuleDefects  ------   */
    /* -----------------------------------   */



    /* OLD OLD OLD OLD OLD OLD OLD OLD OLD OLD OLD OLD OLD OLD OLD OLD OLD
    for (unsigned int i=0; i<defects.size(); ++i) {    //loop on the number of all kinds of defects per module
      
     

      this_moduleDefects->cd();
      

      TDirectory* this_defect = (TDirectory*) gDirectory->Get(defects[i]->getName().c_str()); 
      if (!this_defect) {
	cout<<defects[i]->getName().c_str()<<" doesn't exist"<<endl;
	this_defect =gDirectory ->mkdir(defects[i]->getName().c_str());
      }
      this_defect->cd();
      

      TObject* pers_sdefect = gDirectory->FindObjectAny("Defect Description"); 
      if (!pers_sdefect) {
	TObjString* sdefect = new TObjString(defects[i]->getDescription().c_str());
	sdefect->Write("Defect Description");
      }
      
      
      //TObject* defectList = gDirectory->FindObjectAny(defects[i]->getName().c_str()); 
      //if (!defectList) ....create defectList
      
      //AT: New code to speed up    
      double first = defects[i]->getModuleElement().getFirst();
      double Nchannels = defects[i]->getModuleElement().getNChannels();
      double chipDefect = defects[i]->isChipDefect();
      double linkDefect = defects[i]->isLinkDefect();
      double unfittable = defects[i]->isUnfittable();
      double unusable = defects[i]->isUnuseable();
      double dodgy = defects[i]->isDodgy();

      TVector* vthisDefect = new TVector(0,6, first, Nchannels,chipDefect, linkDefect, unfittable, unusable, dodgy, "END"); 
      cout << "defects = "<<first<<" "<< Nchannels<<" "<<chipDefect<<" "<<linkDefect<<" "<<unfittable<<" "<<unusable<<" "<<dodgy<<endl; 
      //OLD vthisDefect->Write( names->getDefectID(first,Nchannels).c_str() );
      
      //defectList must be defined!!!!
      //defectList->Add(vthisDefect);
      

      
      delete vthisDefect;
      
      
      
    }
   
    */

    this_moduleDefects->cd();

    ArchModuleDefects archDefects(defects);
    //cout<<"ArchTestResult:  archDefects defined"<<endl;
    vector< shared_ptr<TObjArray> > sortedDefectList = archDefects.getDefects();
    //cout<<"ArchTestResult: sortedDefectList defined"<<endl;
    cout<<" sortedDefectList size = " << sortedDefectList.size() <<endl;

    
    for (vector<shared_ptr<TObjArray> >::iterator it = sortedDefectList.begin();it != sortedDefectList.end() ; ++it)
      {  
      this_moduleDefects->cd();


      shared_ptr<TObject> objFirst = (*it)->First();
      shared_ptr<TObjString> this_name = dynamic_pointer_cast<TObjString>(objFirst);
      const char *this_defectName = this_name->GetName();
      cout<< "Name = " <<this_defectName<<endl;
      

      cout<<"ArchTestResult: about to write sortedDefectList obj..."<<endl;
      
      (*it)->Write(this_defectName,TObject::kSingleKey );
      cout<<"ArchTestResult: sortedDefectList obj written"<<endl;

    }
   


    /* -----------------------------------   */
    


    
    
    /* Making TestType   */
    //cout<<"I am making TestType Dir "<<endl;
    this_module->cd();  //make this_module the current directory 
    TDirectory* this_testType = (TDirectory*) gDirectory->Get(testType.c_str());
    //cout<<"The test Type is "<< testType <<endl;
    
    if (!this_testType) {
      //cout<<"This NEW test "<< testType <<" doesn't exist"<<endl;
      this_testType = gDirectory->mkdir(testType.c_str());
    }
    this_testType->cd();



    /* CLOSING FILE  */
    //cout << "I am Closing File " << endl;
    storage_file->Close();
    delete storage_file;
    cout << "File closed " << endl;
}


void ArchTestResult::RetrieveRawFitScans()  {

  //Retrieving Raw and Fitted Scans:
  for (vector<unsigned int>::iterator i = scanNumbers.begin(); i!=scanNumbers.end(); i++) { 
    unsigned int scanNumber =  *i;
    string RawISName = Archiving::GetRawISUniqueID(runNumber, scanNumber, moduleName);
    rawScans.push_back(ISRetrieveRawScanResult(RawISName));
    
    //Pipeline,FullBypass have no FitScans:
    if (testType != "SctData::PipelineTestResult" && testType != "SctData::FullBypassTestResult" && testType != "SctData::NMaskTestResult") {
      //if (testType != "PipelineTestResult" && testType != "FullBypassTestResult" && testType != "NMaskTestResult") {
      if (testType != "PipelineTest" && testType != "FullBypassTest" && testType != "NMaskTest") {
	string FitISName = Archiving::GetFitISUniqueID(runNumber, scanNumber, moduleName);
	fitScans.push_back(ISRetrieveFitScanResult(FitISName));
      }
   
      
    }
    
    

  }

}



void ArchTestResult::AddTestToIndex()  {
  
  /* Append current Test to the Index */

  //cout << "I am in AddTestToIndex() " << endl;
  string index = names->getIndexFileName(); 
  ofstream index_file;
  index_file.open(index.c_str(),ios::app);  //append the Index File
  //assure(out, "Strfile.out");  //TO DO

  string indexTestName = names->getRunID() + ".";
  indexTestName = indexTestName + names->getModuleID();
  indexTestName = indexTestName + ".";
  indexTestName = indexTestName + names->getTestType() + ".";
  //cout << indexTestName <<endl;
  //if(TestIsPersisted()) {
   index_file << indexTestName <<endl;
   cout << "Test appended to Index"<<endl;    
  //} else {
  //  cout<<"Test NOT correctly saved in the archive...test NOT added to the Index"<<endl;
  //}
  
  index_file.close(); 
  
}
