#ifndef ArchNoiseOccupancyTestResult_H
#define ArchNoiseOccupancyTestResult_H

#include "Sct/SctNames.h"
#include "ArchTestResult.h"
#include "SctData/NoiseOccupancyTestResult.h"
#include <vector>


class TVectorD;

using namespace SctData;
using namespace Sct;


class ArchNoiseOccupancyTestResult: public  ArchTestResult {
  
 protected:
  vector <TGraph*> chipNOGraph;
  vector <TF1*> chipNOFit; 
  TVectorD* vchipNoise;
  
  static bool inMap;
  
  ArchNoiseOccupancyTestResult(shared_ptr<NoiseOccupancyTestResult>);

 public:
    ArchNoiseOccupancyTestResult();
    virtual shared_ptr<ArchTestResult> clone(shared_ptr<TestResult> test) {
                                   shared_ptr<NoiseOccupancyTestResult> NOtest = dynamic_pointer_cast<NoiseOccupancyTestResult>(test);
                                   return shared_ptr<ArchTestResult>(new ArchNoiseOccupancyTestResult(NOtest));
  } 
    ~ArchNoiseOccupancyTestResult();

    void SaveNOTestDataOnly();
    void Save();

    void TestSummary(shared_ptr<NoiseOccupancyTestResult>);



};


#endif
