#include "ArchNoiseOccupancyTestResult.h"
#include "ArchivingManager.h"
#include <TFile.h>
#include <TKey.h>
#include <TDirectory.h>
#include <TSystem.h>
#include <TNamed.h>
#include <TObject.h>
#include <TObjArray.h>
#include <TString.h>
#include <TObjString.h>
#include <TVector.h>
#include <TVectorD.h>
#include <TH1.h>
#include <TH2.h>
#include <TCanvas.h>
#include <TROOT.h>
#include <is/isinfo.h>
#include <iostream>
#include <vector>
#include "SummaryWriter/SummaryWriter.h"
#include "SummaryWriter/SummaryManager.h"

#include "Sct/SctParameters.h"

using namespace Sct;
using namespace SctData;


/********************************** ArchScan Methods Definitions ************************/
bool ArchNoiseOccupancyTestResult::inMap = ArchivingManager::instance().addTestArchiver("SctData::NoiseOccupancyTestResult", shared_ptr<ArchTestResult>(new ArchNoiseOccupancyTestResult()));  


/***********************  Constructor  *************** */

ArchNoiseOccupancyTestResult::ArchNoiseOccupancyTestResult(): ArchTestResult()  {

  //cout<< "I am in the ArchNoiseOccupancyTestResult Default Constructor"<< endl;
  
  
  
}
  
  
ArchNoiseOccupancyTestResult::ArchNoiseOccupancyTestResult(shared_ptr<NoiseOccupancyTestResult> NOtest): ArchTestResult(NOtest)  {

  //cout<< "I am in the ArchNoiseOccupancyTestResult Constructor"<< endl;
  
  //Save chipNoise as TVectorD's  
  double x[nChipModule];

  /*--- Initialisation ---*/
  for (unsigned int i = 0; i<nChipModule;i++) { 
    ChipNOResult& result = NOtest->getChipResult(i);
    chipNOGraph.push_back(result.graph.get());
    chipNOFit.push_back(result.fit.get());    
    x[i] = result.getNoise() ;
  }

  vchipNoise = new TVectorD(12 ,x);

  
  //Retrieve Test Summary from IS
  try{
    TestSummary(NOtest);
  } catch(...) {
    cout<<" ERROR in retrieving Test Summary from IS" <<endl;
  }


}



/**********************  Other Member Functions  *********************/

ArchNoiseOccupancyTestResult::~ArchNoiseOccupancyTestResult()  {
  
  //cout << "I am in the destructor" << endl;
  

  
}





void ArchNoiseOccupancyTestResult::SaveNOTestDataOnly() {

  cout<<"Saving NoiseOccupancyTestData "<<endl;
     
//TO DO : Save time and date of first and last saving  
  
  string filename = names->getfilename();
  string moduleID = names->getModuleID(); 
  string testType  = names->getTestType(); 
  string runID = names->getRunID();
  string vchipNoiseID = names->getChipNONoiseID();
  string chipNOFitID = names->getChipNOFitID();
  string chipNOGraphID = names->getChipNOGraphID();

  /* OPENING TEST FILE  */
  //cout << "Opening file..."<<endl; 
 

  TFile *storage_file = new TFile(filename.c_str(),"update");
  //storage_file->ls();
  //cout << "The file .root succesfully open"<<endl; 

  


  /* CREATING DIRECTORIES and SAVING DATA  */
  
    
    /* Making RunNumber   */
    //cout<<"I am making RunNumber Dir"<<endl;
    //storage_file->GetListOfKeys()->Print();
    TDirectory *this_run = (TDirectory*) gDirectory->Get(runID.c_str());
    //cout<<"The RUN is "<< runID <<endl;
    
    if (!this_run) {
      //cout<<"This NEW run "<< runID <<" doesn't exist"<<endl;
      this_run = storage_file->mkdir(runID.c_str());
      //cout<<"New RunNumber Dir made "<<endl;
    }
    storage_file->GetListOfKeys()->Print();
    this_run->cd();  //make this_run the current directory
    
   
    /* Saving RunNumber as a TVector: it is saved only once, just the first time   */
    TObject* pers_runnumber = gDirectory->FindObjectAny(runID.c_str()); 
    if (!pers_runnumber) {
      double frunNumber = runNumber;
      TVector run(1,1,frunNumber, "END");
      run.Write(runID.c_str());
    }
    
    
    /* Making moduleNumber   */
    
    TDirectory* this_module = (TDirectory*) gDirectory->Get(moduleID.c_str()); //Can be made using FindAnyObject
    //cout<<"The MODULE is "<< moduleID <<endl;
    if (!this_module) {
      //cout<<"This NEW module "<< moduleID <<" doesn't exist"<<endl;
      this_module =gDirectory ->mkdir(moduleID.c_str());
    }
    

    
    /* Making TestType   */
    //cout<<"I am making TestType Dir "<<endl;
    this_module->cd();  //make this_module the current directory 
    TDirectory* this_testType = (TDirectory*) gDirectory->Get(testType.c_str());
    //cout<<"The test Type is "<< testType <<endl;
    
    if (!this_testType) {
      //cout<<"This NEW test "<< testType <<" doesn't exist"<<endl;
      this_testType = gDirectory->mkdir(testType.c_str());
    }
    this_testType->cd();


    /* Saving chipNOFit */
    TDirectory* pers_ChipNOFit = (TDirectory*) gDirectory->Get(chipNOFitID.c_str());
    if (!pers_ChipNOFit) {
      //cout << "The ChipNOFit never saved before...saving now"<<endl;
      pers_ChipNOFit = this_testType->mkdir(chipNOFitID.c_str());
      
    }
    pers_ChipNOFit->cd();

    unsigned int chipN=0;
    for (vector<TF1*>::iterator i = chipNOFit.begin(); i!=chipNOFit.end(); i++) {
      (*i)->Write(names->getChipNOFitID(chipN).c_str());
      ++chipN;
    } 
    this_testType->cd();


    /* Saving chipNOGraph */
    TDirectory* pers_ChipNOGraph = (TDirectory*) gDirectory->Get(chipNOGraphID.c_str());
    if (!pers_ChipNOGraph) {
      //cout << "The ChipNOGraph never saved before...saving now"<<endl;
      pers_ChipNOGraph = this_testType->mkdir(chipNOGraphID.c_str());
      
    }
    pers_ChipNOGraph->cd();
    chipN=0;
    for (vector<TGraph*>::iterator i = chipNOGraph.begin(); i!=chipNOGraph.end(); i++) {
      (*i)->Write(names->getChipNOGraphID(chipN).c_str());
       ++chipN;
    }   
    this_testType->cd();
    
    /* Saving ChipNoise as a TVector: always saved!!  */
    //cout << "I am Saving ChipNoise as  TVectorD's" << endl;
    //TObject* pers_vchipNoise = gDirectory->FindObjectAny(vchipNoiseID.c_str()); 
    //if (!pers_vchipNoise) {
      //cout << "The ChipNoise never saved before...saving now"<<endl;
      vchipNoise->Write(vchipNoiseID.c_str());
      //}
    

    
    //Save TestSummery (if it has been retrieved)
    if(testSummary != NULL) {
      //cout<<"testSummary != NULL...";
      TObject* pers_testSummary = gDirectory->FindObjectAny(names->getTestSummaryID().c_str());
      if (!pers_testSummary) {
	testSummary->Write(names->getTestSummaryID().c_str());
	//cout<<"testSummary SAVED"<<endl;
      }
    }

    
    /* CLOSING FILE  */
    //cout << "I am Closing File " << endl;
    storage_file->Close();
    delete storage_file;
    //cout << "File closed " << endl;




}



void ArchNoiseOccupancyTestResult::Save() {

  //cout << "I am in SaveNoiseOccupancy() " <<endl;
  ArchTestResult::Save();
  SaveNOTestDataOnly();
  //SaveRawScans();
  //SaveFitScans();
  AddTestToIndex();
  





}



void ArchNoiseOccupancyTestResult::TestSummary(shared_ptr<NoiseOccupancyTestResult> NOtest) {
  
  ostringstream datastream;
  shared_ptr<const SctData::TestSummary::SummaryWriter> writer = 
    SctData::TestSummary::SummaryManager::instance().getWriter(NOtest->getClassName());
  writer->writeHeader(*(NOtest.get()), datastream);
  writer->write(*(NOtest.get()), datastream);
  string myString = datastream.str();
  //cout<< "TestSummary = " << myString;

  testSummary = new TObjString(myString.c_str());

  


  return;


}

