#include "ArchModuleDefects.h"
#include <boost/shared_ptr.hpp>
#include "SctData/ModuleDefect.h"
#include "TObjString.h"
#include "TVectorD.h"
#include "TVector.h"
#include <string>
#include <map>

//using namespace SctData;
//using namespace Sct;
using namespace boost;
using boost::shared_ptr;


ArchModuleDefects::ArchModuleDefects(vector<shared_ptr<const ModuleDefect> > testDefects ) {

  
  
  defects = testDefects;

  for (unsigned int i=0; i<defects.size(); ++i) {    //loop on the number of all kinds of defects per module
    
    
    //TObjString* name =  new TObjString(defects[i]->getName().c_str());
    
    
    double first = defects[i]->getModuleElement().getFirst();
    double Nchannels = defects[i]->getModuleElement().getNChannels();
    double chipDefect = defects[i]->isChipDefect();
    double linkDefect = defects[i]->isLinkDefect();
    double unfittable = defects[i]->isUnfittable();
    double unusable = defects[i]->isUnuseable();
    double dodgy = defects[i]->isDodgy();

    
    TVector* vthisDefect = new TVector(0,7,0,first,Nchannels,chipDefect,linkDefect,unfittable,unusable,dodgy,"END"); 
    //cout << "defects = "<<first<<" "<<Nchannels<<" "<<chipDefect<<" "<<linkDefect<<" "<<unfittable<<" "<<unusable<<" "<<dodgy<<endl; 
    
    
      

       //Check if this kind of defect already exists

       if (IsInMap(defects[i]->getName().c_str()) == true) {
      
      
	 float index = IndexInMap(defects[i]->getName().c_str());

	 //get the TObjArray defectList and add this defect, i, to the TObjArray defectList      
	 TObjArray* tmp_obj[defectList.size()];
	 for(int ii= 0;ii<defectList.size(); ++ii) { 
	   tmp_obj[ii] = (defectList[ii]).get();
	   TObjString* this_name = dynamic_cast<TObjString*>(tmp_obj[ii]->First());
	   const char *tmp_this_name = this_name->GetName();
	   if (IndexInMap(tmp_this_name) == index) {
	     //cout<< "Name = " <<tmp_this_name<<endl;
	     tmp_obj[ii]->Add(vthisDefect);
	   }
	   
	   
	 }
       
       

       
       } else {
      

	 //if this kind of defect is new, i.e. not in the defect map:
	 //Add this defect to map
	 if (addToMap(defects[i]->getName().c_str()) == true) { 

	   //get the TObjArray defectList and add this defect, i, to the TObjArray defectList
	   TObjString* name =  new TObjString(defects[i]->getName().c_str());

	   TObjArray* obj = new TObjArray();	   
	   obj->Add(name);
	   obj->Add(vthisDefect);	
	   defectList.push_back(obj);
	
	 } else { 
	   cerr<<"ERROR in Adding Defect to map"<<endl;
	 }
	 
       }    
    

 

  }



} 


bool ArchModuleDefects::IsInMap(const string& defectName) throw() {
  
  if (defectMap.find(defectName) == defectMap.end()) {
    ostringstream os; os <<"ArchModuleDefects::isInMap couldn't find defect `"<< defectName<<"'";
    cerr << os.str() << endl;
    cerr << "There are " << defectMap.size() << " known defect types: ";
    for (map<string, int>::const_iterator it = defectMap.begin();it != defectMap.end() ; ++it)
      {
	cerr << (*it).first << endl;
      }
    //throw InvalidArgumentError(os.str(), __FILE__, __LINE__);
    return false;
  }
  
  
  return true;

}


int ArchModuleDefects::IndexInMap(const string& defectName) throw(LogicError) {
  
  if (defectMap.find(defectName) == defectMap.end()) {
  ostringstream os; os <<"ArchModuleDefects::IndexInMap couldn't find defect `"<< defectName<<"'";
    cerr << os.str() << endl;
    cerr << "There are " << defectMap.size() << " known response defect types: ";
    for (map<string, int>::const_iterator it = defectMap.begin();it != defectMap.end() ; ++it)
      {
	cerr << (*it).first << endl;

      }
    throw InvalidArgumentError(os.str(), __FILE__, __LINE__);
  }
  return (*defectMap.find(defectName)).second;



}

    

bool ArchModuleDefects::addToMap(const string& defectName) throw() {
  //if this defectName is already in the map return false
  //cout<<"I am in AddToMap"<<endl;
  if (defectMap.find(defectName) != defectMap.end()) {
    cout<<" Defect already in map"<<endl;
    return false;
  }

  //cout<<" Adding Defect to map..."<<endl;
  int size = defectMap.size();
  defectMap[defectName] = size+1;
  return true;
}
 



vector< shared_ptr<TObjArray> > ArchModuleDefects::getDefects() {

 return defectList;


}

map <string, int> ArchModuleDefects::getMap() {

 return defectMap;



}
