#ifndef ArchFullBypassTestResult_H
#define ArchFullBypassTestResult_H


#include "Sct/SctNames.h"
#include "ArchTestResult.h"
#include "SctData/FullBypassTestResult.h"
#include <TVectorD.h>
#include <vector>
#include <boost/shared_ptr.hpp>


using boost::shared_ptr;
using namespace SctData;
using namespace Sct;


class ArchFullBypassTestResult: public  ArchTestResult {
  
 private:
  vector<short> status_direct;  
  vector<float> vdd_direct;
  vector<short> status_bypass;
  vector<float> vdd_bypass;

  vector< shared_ptr<TVector> > v_status_direct; 
  vector< shared_ptr<TVector> > v_vdd_direct;
  vector< shared_ptr<TVector> > v_status_bypass;
  vector< shared_ptr<TVector> > v_vdd_bypass;
  
  static bool inMap;

  ArchFullBypassTestResult(shared_ptr<FullBypassTestResult>);

 public: 

  ArchFullBypassTestResult();
  virtual shared_ptr<ArchTestResult> clone(shared_ptr<TestResult> test) {
                                   shared_ptr<FullBypassTestResult> FBtest = dynamic_pointer_cast<FullBypassTestResult>(test);
                                   return shared_ptr<ArchTestResult>(new ArchFullBypassTestResult(FBtest));
  } 
  ~ArchFullBypassTestResult();
 
  void SaveFullBypassTestDataOnly();
  void Save();
  void TestSummary(shared_ptr<FullBypassTestResult>);
   
};


#endif
