#include <archiving/ArchRawScanResult.h>
#include "Sct/IS/IOManagerIS.h"
#include "SctData/ConfigurationVariable.h"
#include "SctData/RawScanResult.h"
#include <iostream>
#include <sstream>
#include <boost/shared_ptr.hpp>

using namespace SctData;
using namespace Sct;
using namespace Sct::IS;
using namespace std;
using namespace boost;

int Help() {
	cout << "Takes 4 arguments: run number, scan number, module name, scan type number" << endl << "Optional 5th argument is the cycle number" << endl;
	return 0;
}

int main(int argc, char** argv) {
	if (argc < 5) return Help();

	unsigned int runNumber = 0;
	unsigned int scanNumber = 0;
	string moduleName = argv[3];
	unsigned int typeNumber = 0;
	unsigned int cycle = 0;  //default	

	string arg1 = argv[1]; 
	string arg2 = argv[2];
	string arg4 = argv[4];

	istringstream istr1(arg1);
	istr1 >> runNumber;

	istringstream istr2(arg2);
	istr2 >> scanNumber;

	istringstream istr4(arg4);
	istr4 >> typeNumber;

	if (argc > 5) {
		string arg5 = argv[5];
		istringstream istr5(arg5);
		istr5 >> cycle;
	}

	shared_ptr<ConfigurationVariable> variable = ConfigurationVariableIOHelper::getFromTypeRep(typeNumber);

	cout << "Try and get raw data for: Run " << runNumber << " Scan: " << scanNumber << " Name: " << moduleName << " Type: " << typeNumber << " Cycle: " << cycle << endl;
	ArchRawScanResult ar;
	ar.SetUNIXDir();
	RawScanResult* raw = ar.CreateRawScanResult(runNumber, scanNumber, moduleName, *variable, cycle);

	IOManagerIS::instance().write(*raw);

	cout << "Done" << endl;
}
