/*
 * ScriptingInterface.java
 *
 * Created on 28 November 2002, 14:34
 */

package TestGUI;
import org.apache.bsf.*;
import GuiComponents.scripting.*;
import GuiComponents.Console.*;
import javax.swing.*;

/**
 *
 * @author  palmer
 */
public class ScriptingPanel extends javax.swing.JPanel {
    
    /** Creates new form ScriptingInterface */
    public ScriptingPanel(MyJPanel parent) {        
        initComponents();
        initManager(parent);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;
        
        jButtonPanel = new javax.swing.JPanel();
        bBeanShell = new javax.swing.JButton();
        bJython = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        
        setLayout(new java.awt.BorderLayout());
        
        jButtonPanel.setLayout(new java.awt.GridBagLayout());
                        
        bBeanShell.setText("BeanShell");
        bBeanShell.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bBeanShellActionPerformed(evt);
            }
        });
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        jButtonPanel.add(bBeanShell, gridBagConstraints);
        
        bJython.setText("Jython");
        bJython.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bJythonActionPerformed(evt);
            }
        });
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        jButtonPanel.add(bJython, gridBagConstraints);
        
        jLabel1.setText("Create new scripting console...");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        jButtonPanel.add(jLabel1, gridBagConstraints);
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jButtonPanel.add(jLabel2, gridBagConstraints);
        
        add(jButtonPanel, java.awt.BorderLayout.CENTER);
        
    }//GEN-END:initComponents

    private void bJythonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bJythonActionPerformed
        addNewConsole(ScriptingInterface.instance().getJythonInterpreter(), "Jython");
    }//GEN-LAST:event_bJythonActionPerformed
    
    private void initManager(MyJPanel parent) {        
        try {
            ScriptingInterface.instance().getManager().declareBean("Panel", parent, parent.getClass());            
        } catch (BSFException be) {
            System.err.println("Error initializing manager: " + be);
        }
    }
    
    private void bBeanShellActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bBeanShellActionPerformed
        addNewConsole(ScriptingInterface.instance().getBeanShellInterpreter(), "BeanShell");
    }//GEN-LAST:event_bBeanShellActionPerformed
    
    /**
     * Adds the new console to this window...
     */
    protected boolean addNewConsole(Interpreter interpreter, String suffix) {    
        if (interpreter == null) {
            MyJPanel.getMessageArea().append("Can only have 1 scripting window open at once\n");
            return false;
        }	
	JFrame frame = new JFrame();
	frame.addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
		System.out.println("Closing window");
		evt.getWindow().hide();
                evt.getWindow().dispose();
		
            }
	});

        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(interpreter.getConsole());
        frame.getContentPane().add(scroll);  
        frame.setTitle("Scripting Window:" + suffix);
        frame.show();
        frame.setSize(800, 500);        
	
        return true;
    }
        
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton bBeanShell;
    private javax.swing.JButton bJython;
    private javax.swing.JPanel jButtonPanel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    // End of variables declaration//GEN-END:variables   
}
